package io.ciera.tool.sql.architecture.statement.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.classes.ClassRelationship;
import io.ciera.tool.sql.architecture.classes.impl.ClassRelationshipImpl;
import io.ciera.tool.sql.architecture.expression.Expression;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionImpl;
import io.ciera.tool.sql.architecture.invocable.CodeBlock;
import io.ciera.tool.sql.architecture.statement.RelateSmt;
import io.ciera.tool.sql.architecture.statement.Statement;
import io.ciera.tool.sql.architecture.statement.impl.StatementImpl;


public class RelateSmtImpl extends ModelInstance<RelateSmt,Sql> implements RelateSmt {

    public static final String KEY_LETTERS = "RelateSmt";
    public static final RelateSmt EMPTY_RELATESMT = new EmptyRelateSmt();

    private Sql context;

    // constructors
    private RelateSmtImpl( Sql context ) {
        this.context = context;
        ref_parent_name = "";
        ref_parent_package = "";
        ref_body_name = "";
        ref_block_number = "";
        ref_statement_number = "";
        ref_part_expression_number = "";
        ref_form_expression_number = "";
        ref_rel_name = "";
        ref_comp_name = "";
        ref_comp_package = "";
        R451_is_a_Statement_inst = StatementImpl.EMPTY_STATEMENT;
        R479_relates_formalizing_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
        R480_relates_participating_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
        R481_creates_instances_of_ClassRelationship_inst = ClassRelationshipImpl.EMPTY_CLASSRELATIONSHIP;
    }

    private RelateSmtImpl( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_part_expression_number, String ref_form_expression_number, String ref_rel_name, String ref_comp_name, String ref_comp_package ) {
        super(instanceId);
        this.context = context;
        this.ref_parent_name = ref_parent_name;
        this.ref_parent_package = ref_parent_package;
        this.ref_body_name = ref_body_name;
        this.ref_block_number = ref_block_number;
        this.ref_statement_number = ref_statement_number;
        this.ref_part_expression_number = ref_part_expression_number;
        this.ref_form_expression_number = ref_form_expression_number;
        this.ref_rel_name = ref_rel_name;
        this.ref_comp_name = ref_comp_name;
        this.ref_comp_package = ref_comp_package;
        R451_is_a_Statement_inst = StatementImpl.EMPTY_STATEMENT;
        R479_relates_formalizing_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
        R480_relates_participating_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
        R481_creates_instances_of_ClassRelationship_inst = ClassRelationshipImpl.EMPTY_CLASSRELATIONSHIP;
    }

    public static RelateSmt create( Sql context ) throws XtumlException {
        RelateSmt newRelateSmt = new RelateSmtImpl( context );
        if ( context.addInstance( newRelateSmt ) ) {
            newRelateSmt.getRunContext().addChange(new InstanceCreatedDelta(newRelateSmt, KEY_LETTERS));
            return newRelateSmt;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static RelateSmt create( Sql context, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_part_expression_number, String ref_form_expression_number, String ref_rel_name, String ref_comp_name, String ref_comp_package ) throws XtumlException {
        return create(context, UniqueId.random(), ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, ref_statement_number, ref_part_expression_number, ref_form_expression_number, ref_rel_name, ref_comp_name, ref_comp_package);
    }

    public static RelateSmt create( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_part_expression_number, String ref_form_expression_number, String ref_rel_name, String ref_comp_name, String ref_comp_package ) throws XtumlException {
        RelateSmt newRelateSmt = new RelateSmtImpl( context, instanceId, ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, ref_statement_number, ref_part_expression_number, ref_form_expression_number, ref_rel_name, ref_comp_name, ref_comp_package );
        if ( context.addInstance( newRelateSmt ) ) {
            return newRelateSmt;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_parent_name;
    @Override
    public void setParent_name(String ref_parent_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_name, this.ref_parent_name)) {
            final String oldValue = this.ref_parent_name;
            this.ref_parent_name = ref_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_name", oldValue, this.ref_parent_name));
        }
    }
    @Override
    public String getParent_name() throws XtumlException {
        checkLiving();
        return ref_parent_name;
    }
    private String ref_parent_package;
    @Override
    public String getParent_package() throws XtumlException {
        checkLiving();
        return ref_parent_package;
    }
    @Override
    public void setParent_package(String ref_parent_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_package, this.ref_parent_package)) {
            final String oldValue = this.ref_parent_package;
            this.ref_parent_package = ref_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_package", oldValue, this.ref_parent_package));
        }
    }
    private String ref_body_name;
    @Override
    public void setBody_name(String ref_body_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_body_name, this.ref_body_name)) {
            final String oldValue = this.ref_body_name;
            this.ref_body_name = ref_body_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_body_name", oldValue, this.ref_body_name));
        }
    }
    @Override
    public String getBody_name() throws XtumlException {
        checkLiving();
        return ref_body_name;
    }
    private String ref_block_number;
    @Override
    public void setBlock_number(String ref_block_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_block_number, this.ref_block_number)) {
            final String oldValue = this.ref_block_number;
            this.ref_block_number = ref_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_block_number", oldValue, this.ref_block_number));
        }
    }
    @Override
    public String getBlock_number() throws XtumlException {
        checkLiving();
        return ref_block_number;
    }
    private String ref_statement_number;
    @Override
    public String getStatement_number() throws XtumlException {
        checkLiving();
        return ref_statement_number;
    }
    @Override
    public void setStatement_number(String ref_statement_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_statement_number, this.ref_statement_number)) {
            final String oldValue = this.ref_statement_number;
            this.ref_statement_number = ref_statement_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_statement_number", oldValue, this.ref_statement_number));
        }
    }
    private String ref_part_expression_number;
    @Override
    public String getPart_expression_number() throws XtumlException {
        checkLiving();
        return ref_part_expression_number;
    }
    @Override
    public void setPart_expression_number(String ref_part_expression_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_part_expression_number, this.ref_part_expression_number)) {
            final String oldValue = this.ref_part_expression_number;
            this.ref_part_expression_number = ref_part_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_part_expression_number", oldValue, this.ref_part_expression_number));
        }
    }
    private String ref_form_expression_number;
    @Override
    public String getForm_expression_number() throws XtumlException {
        checkLiving();
        return ref_form_expression_number;
    }
    @Override
    public void setForm_expression_number(String ref_form_expression_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_form_expression_number, this.ref_form_expression_number)) {
            final String oldValue = this.ref_form_expression_number;
            this.ref_form_expression_number = ref_form_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_form_expression_number", oldValue, this.ref_form_expression_number));
        }
    }
    private String ref_rel_name;
    @Override
    public String getRel_name() throws XtumlException {
        checkLiving();
        return ref_rel_name;
    }
    @Override
    public void setRel_name(String ref_rel_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_rel_name, this.ref_rel_name)) {
            final String oldValue = this.ref_rel_name;
            this.ref_rel_name = ref_rel_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_rel_name", oldValue, this.ref_rel_name));
        }
    }
    private String ref_comp_name;
    @Override
    public void setComp_name(String ref_comp_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_comp_name, this.ref_comp_name)) {
            final String oldValue = this.ref_comp_name;
            this.ref_comp_name = ref_comp_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_comp_name", oldValue, this.ref_comp_name));
        }
    }
    @Override
    public String getComp_name() throws XtumlException {
        checkLiving();
        return ref_comp_name;
    }
    private String ref_comp_package;
    @Override
    public void setComp_package(String ref_comp_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_comp_package, this.ref_comp_package)) {
            final String oldValue = this.ref_comp_package;
            this.ref_comp_package = ref_comp_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_comp_package", oldValue, this.ref_comp_package));
        }
    }
    @Override
    public String getComp_package() throws XtumlException {
        checkLiving();
        return ref_comp_package;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getParent_name(), getParent_package(), getBody_name(), getBlock_number(), getStatement_number());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().push_buffer();
        Statement smt = self().R451_is_a_Statement();
        String actions = smt.getActions();
        String prefix = smt.getPrefix();
        CodeBlock block = smt.R450_is_contained_by_CodeBlock();
        String indent = context().getIndent( block.getTab_depth() + 1 );
        Expression form_expression = self().R479_relates_formalizing_Expression();
        form_expression.render();
        String form_expr = context().T().body();
        context().T().clear();
        Expression part_expression = self().R480_relates_participating_Expression();
        part_expression.render();
        String part_expr = context().T().body();
        context().T().pop_buffer();
        context().T().include( "statement/t.relate.java", actions, form_expr, indent, part_expr, prefix, self() );
    }



    // static operations


    // events


    // selections
    private Statement R451_is_a_Statement_inst;
    @Override
    public void setR451_is_a_Statement( Statement inst ) {
        R451_is_a_Statement_inst = inst;
    }
    @Override
    public Statement R451_is_a_Statement() throws XtumlException {
        return R451_is_a_Statement_inst;
    }
    private Expression R479_relates_formalizing_Expression_inst;
    @Override
    public void setR479_relates_formalizing_Expression( Expression inst ) {
        R479_relates_formalizing_Expression_inst = inst;
    }
    @Override
    public Expression R479_relates_formalizing_Expression() throws XtumlException {
        return R479_relates_formalizing_Expression_inst;
    }
    private Expression R480_relates_participating_Expression_inst;
    @Override
    public void setR480_relates_participating_Expression( Expression inst ) {
        R480_relates_participating_Expression_inst = inst;
    }
    @Override
    public Expression R480_relates_participating_Expression() throws XtumlException {
        return R480_relates_participating_Expression_inst;
    }
    private ClassRelationship R481_creates_instances_of_ClassRelationship_inst;
    @Override
    public void setR481_creates_instances_of_ClassRelationship( ClassRelationship inst ) {
        R481_creates_instances_of_ClassRelationship_inst = inst;
    }
    @Override
    public ClassRelationship R481_creates_instances_of_ClassRelationship() throws XtumlException {
        return R481_creates_instances_of_ClassRelationship_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public RelateSmt self() {
        return this;
    }

    @Override
    public RelateSmt oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_RELATESMT;
    }

}

class EmptyRelateSmt extends ModelInstance<RelateSmt,Sql> implements RelateSmt {

    // attributes
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getParent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setBody_name( String ref_body_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBody_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBlock_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getStatement_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getPart_expression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPart_expression_number( String ref_part_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getForm_expression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setForm_expression_number( String ref_form_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getRel_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRel_name( String ref_rel_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getComp_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getComp_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public Statement R451_is_a_Statement() {
        return StatementImpl.EMPTY_STATEMENT;
    }
    @Override
    public Expression R479_relates_formalizing_Expression() {
        return ExpressionImpl.EMPTY_EXPRESSION;
    }
    @Override
    public Expression R480_relates_participating_Expression() {
        return ExpressionImpl.EMPTY_EXPRESSION;
    }
    @Override
    public ClassRelationship R481_creates_instances_of_ClassRelationship() {
        return ClassRelationshipImpl.EMPTY_CLASSRELATIONSHIP;
    }


    @Override
    public String getKeyLetters() {
        return RelateSmtImpl.KEY_LETTERS;
    }

    @Override
    public RelateSmt self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public RelateSmt oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return RelateSmtImpl.EMPTY_RELATESMT;
    }

}
