package io.ciera.tool.sql.architecture.statement.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.statement.NullSmt;
import io.ciera.tool.sql.architecture.statement.NullSmtSet;
import io.ciera.tool.sql.architecture.statement.StatementSet;
import io.ciera.tool.sql.architecture.statement.impl.StatementSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class NullSmtSetImpl extends InstanceSet<NullSmtSet,NullSmt> implements NullSmtSet {

    public NullSmtSetImpl() {
    }

    public NullSmtSetImpl(Comparator<? super NullSmt> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( NullSmt nullsmt : this ) nullsmt.setParent_package( ref_parent_package );
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( NullSmt nullsmt : this ) nullsmt.setStatement_number( ref_statement_number );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( NullSmt nullsmt : this ) nullsmt.setParent_name( ref_parent_name );
    }
    @Override
    public void setName( String ref_name ) throws XtumlException {
        for ( NullSmt nullsmt : this ) nullsmt.setName( ref_name );
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( NullSmt nullsmt : this ) nullsmt.setBlock_number( ref_block_number );
    }


    // selections
    @Override
    public StatementSet R451_is_a_Statement() throws XtumlException {
        StatementSet statementset = new StatementSetImpl();
        for ( NullSmt nullsmt : this ) statementset.add( nullsmt.R451_is_a_Statement() );
        return statementset;
    }


    @Override
    public NullSmt nullElement() {
        return NullSmtImpl.EMPTY_NULLSMT;
    }

    @Override
    public NullSmtSet emptySet() {
      return new NullSmtSetImpl();
    }

    @Override
    public NullSmtSet emptySet(Comparator<? super NullSmt> comp) {
      return new NullSmtSetImpl(comp);
    }

    @Override
    public List<NullSmt> elements() {
        NullSmt[] elements = toArray(new NullSmt[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
