package io.ciera.tool.sql.architecture.statemachine.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.statemachine.EventSet;
import io.ciera.tool.sql.architecture.statemachine.StateTransitionSet;
import io.ciera.tool.sql.architecture.statemachine.TransitionTableCell;
import io.ciera.tool.sql.architecture.statemachine.TransitionTableCellSet;
import io.ciera.tool.sql.architecture.statemachine.TransitionTableRowSet;
import io.ciera.tool.sql.architecture.statemachine.impl.EventSetImpl;
import io.ciera.tool.sql.architecture.statemachine.impl.StateTransitionSetImpl;
import io.ciera.tool.sql.architecture.statemachine.impl.TransitionTableRowSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

import types.TransitionType;


public class TransitionTableCellSetImpl extends InstanceSet<TransitionTableCellSet,TransitionTableCell> implements TransitionTableCellSet {

    public TransitionTableCellSetImpl() {
    }

    public TransitionTableCellSetImpl(Comparator<? super TransitionTableCell> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setEvent_name( String ref_event_name ) throws XtumlException {
        for ( TransitionTableCell transitiontablecell : this ) transitiontablecell.setEvent_name( ref_event_name );
    }
    @Override
    public void setEvent_sm_package( String ref_event_sm_package ) throws XtumlException {
        for ( TransitionTableCell transitiontablecell : this ) transitiontablecell.setEvent_sm_package( ref_event_sm_package );
    }
    @Override
    public void setState_name( String ref_state_name ) throws XtumlException {
        for ( TransitionTableCell transitiontablecell : this ) transitiontablecell.setState_name( ref_state_name );
    }
    @Override
    public void setIndex( int m_index ) throws XtumlException {
        for ( TransitionTableCell transitiontablecell : this ) transitiontablecell.setIndex( m_index );
    }
    @Override
    public void setEvent_sm_name( String ref_event_sm_name ) throws XtumlException {
        for ( TransitionTableCell transitiontablecell : this ) transitiontablecell.setEvent_sm_name( ref_event_sm_name );
    }
    @Override
    public void setSm_package( String ref_sm_package ) throws XtumlException {
        for ( TransitionTableCell transitiontablecell : this ) transitiontablecell.setSm_package( ref_sm_package );
    }
    @Override
    public void setTransition_type( TransitionType m_transition_type ) throws XtumlException {
        for ( TransitionTableCell transitiontablecell : this ) transitiontablecell.setTransition_type( m_transition_type );
    }
    @Override
    public void setSm_name( String ref_sm_name ) throws XtumlException {
        for ( TransitionTableCell transitiontablecell : this ) transitiontablecell.setSm_name( ref_sm_name );
    }


    // selections
    @Override
    public TransitionTableRowSet R4755_TransitionTableRow() throws XtumlException {
        TransitionTableRowSet transitiontablerowset = new TransitionTableRowSetImpl();
        for ( TransitionTableCell transitiontablecell : this ) transitiontablerowset.add( transitiontablecell.R4755_TransitionTableRow() );
        return transitiontablerowset;
    }
    @Override
    public EventSet R4756_receives_Event() throws XtumlException {
        EventSet eventset = new EventSetImpl();
        for ( TransitionTableCell transitiontablecell : this ) eventset.add( transitiontablecell.R4756_receives_Event() );
        return eventset;
    }
    @Override
    public StateTransitionSet R4757_transitions_to_StateTransition() throws XtumlException {
        StateTransitionSet statetransitionset = new StateTransitionSetImpl();
        for ( TransitionTableCell transitiontablecell : this ) statetransitionset.add( transitiontablecell.R4757_transitions_to_StateTransition() );
        return statetransitionset;
    }


    @Override
    public TransitionTableCell nullElement() {
        return TransitionTableCellImpl.EMPTY_TRANSITIONTABLECELL;
    }

    @Override
    public TransitionTableCellSet emptySet() {
      return new TransitionTableCellSetImpl();
    }

    @Override
    public TransitionTableCellSet emptySet(Comparator<? super TransitionTableCell> comp) {
      return new TransitionTableCellSetImpl(comp);
    }

    @Override
    public List<TransitionTableCell> elements() {
        return Arrays.asList(toArray(new TransitionTableCell[0]));
    }

}
