package io.ciera.tool.sql.architecture.invocable.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.classes.AttributeDerivation;
import io.ciera.tool.sql.architecture.invocable.CodeBlock;
import io.ciera.tool.sql.architecture.invocable.InvocableObject;
import io.ciera.tool.sql.architecture.invocable.impl.InvocableObjectImpl;
import io.ciera.tool.sql.architecture.statement.ForSmt;
import io.ciera.tool.sql.architecture.statement.IfSmt;
import io.ciera.tool.sql.architecture.statement.Statement;
import io.ciera.tool.sql.architecture.statement.StatementSet;
import io.ciera.tool.sql.architecture.statement.VariableInScope;
import io.ciera.tool.sql.architecture.statement.VariableInScopeSet;
import io.ciera.tool.sql.architecture.statement.WhileSmt;
import io.ciera.tool.sql.architecture.statement.impl.ForSmtImpl;
import io.ciera.tool.sql.architecture.statement.impl.IfSmtImpl;
import io.ciera.tool.sql.architecture.statement.impl.StatementSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.VariableInScopeSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.WhileSmtImpl;
import io.ciera.tool.sql.architecture.type.Type;
import io.ciera.tool.sql.ooaofmarking.Mark;


public class CodeBlockImpl extends ModelInstance<CodeBlock,Sql> implements CodeBlock {

    public static final String KEY_LETTERS = "CodeBlock";
    public static final CodeBlock EMPTY_CODEBLOCK = new EmptyCodeBlock();

    private Sql context;

    // constructors
    private CodeBlockImpl( Sql context ) {
        this.context = context;
        ref_parent_name = "";
        ref_parent_package = "";
        ref_body_name = "";
        m_block_number = "";
        m_tab_depth = 0;
        m_top_level = false;
        m_prefix = "";
        m_suffix = "";
        R4000_is_invoked_in_InvocableObject_inst = InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
        R450_is_scope_for_Statement_set = new StatementSetImpl();
        R453_controls_then_for_IfSmt_inst = IfSmtImpl.EMPTY_IFSMT;
        R454_controls_else_for_IfSmt_inst = IfSmtImpl.EMPTY_IFSMT;
        R455_controls_ForSmt_inst = ForSmtImpl.EMPTY_FORSMT;
        R456_controls_WhileSmt_inst = WhileSmtImpl.EMPTY_WHILESMT;
        R458_has_in_scope_VariableInScope_set = new VariableInScopeSetImpl();
    }

    private CodeBlockImpl( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String m_block_number, int m_tab_depth, boolean m_top_level, String m_prefix, String m_suffix ) {
        super(instanceId);
        this.context = context;
        this.ref_parent_name = ref_parent_name;
        this.ref_parent_package = ref_parent_package;
        this.ref_body_name = ref_body_name;
        this.m_block_number = m_block_number;
        this.m_tab_depth = m_tab_depth;
        this.m_top_level = m_top_level;
        this.m_prefix = m_prefix;
        this.m_suffix = m_suffix;
        R4000_is_invoked_in_InvocableObject_inst = InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
        R450_is_scope_for_Statement_set = new StatementSetImpl();
        R453_controls_then_for_IfSmt_inst = IfSmtImpl.EMPTY_IFSMT;
        R454_controls_else_for_IfSmt_inst = IfSmtImpl.EMPTY_IFSMT;
        R455_controls_ForSmt_inst = ForSmtImpl.EMPTY_FORSMT;
        R456_controls_WhileSmt_inst = WhileSmtImpl.EMPTY_WHILESMT;
        R458_has_in_scope_VariableInScope_set = new VariableInScopeSetImpl();
    }

    public static CodeBlock create( Sql context ) throws XtumlException {
        CodeBlock newCodeBlock = new CodeBlockImpl( context );
        if ( context.addInstance( newCodeBlock ) ) {
            newCodeBlock.getRunContext().addChange(new InstanceCreatedDelta(newCodeBlock, KEY_LETTERS));
            return newCodeBlock;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static CodeBlock create( Sql context, String ref_parent_name, String ref_parent_package, String ref_body_name, String m_block_number, int m_tab_depth, boolean m_top_level, String m_prefix, String m_suffix ) throws XtumlException {
        return create(context, UniqueId.random(), ref_parent_name, ref_parent_package, ref_body_name, m_block_number, m_tab_depth, m_top_level, m_prefix, m_suffix);
    }

    public static CodeBlock create( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String m_block_number, int m_tab_depth, boolean m_top_level, String m_prefix, String m_suffix ) throws XtumlException {
        CodeBlock newCodeBlock = new CodeBlockImpl( context, instanceId, ref_parent_name, ref_parent_package, ref_body_name, m_block_number, m_tab_depth, m_top_level, m_prefix, m_suffix );
        if ( context.addInstance( newCodeBlock ) ) {
            return newCodeBlock;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_parent_name;
    @Override
    public String getParent_name() throws XtumlException {
        checkLiving();
        return ref_parent_name;
    }
    @Override
    public void setParent_name(String ref_parent_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_name, this.ref_parent_name)) {
            final String oldValue = this.ref_parent_name;
            this.ref_parent_name = ref_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_name", oldValue, this.ref_parent_name));
            if ( !R455_controls_ForSmt().isEmpty() ) R455_controls_ForSmt().setParent_name( ref_parent_name );
            if ( !R456_controls_WhileSmt().isEmpty() ) R456_controls_WhileSmt().setParent_name( ref_parent_name );
            if ( !R454_controls_else_for_IfSmt().isEmpty() ) R454_controls_else_for_IfSmt().setParent_name( ref_parent_name );
            if ( !R453_controls_then_for_IfSmt().isEmpty() ) R453_controls_then_for_IfSmt().setParent_name( ref_parent_name );
            if ( !R450_is_scope_for_Statement().isEmpty() ) R450_is_scope_for_Statement().setParent_name( ref_parent_name );
            if ( !R458_has_in_scope_VariableInScope().isEmpty() ) R458_has_in_scope_VariableInScope().setParent_name( ref_parent_name );
        }
    }
    private String ref_parent_package;
    @Override
    public void setParent_package(String ref_parent_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_package, this.ref_parent_package)) {
            final String oldValue = this.ref_parent_package;
            this.ref_parent_package = ref_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_package", oldValue, this.ref_parent_package));
            if ( !R456_controls_WhileSmt().isEmpty() ) R456_controls_WhileSmt().setParent_package( ref_parent_package );
            if ( !R455_controls_ForSmt().isEmpty() ) R455_controls_ForSmt().setParent_package( ref_parent_package );
            if ( !R454_controls_else_for_IfSmt().isEmpty() ) R454_controls_else_for_IfSmt().setParent_package( ref_parent_package );
            if ( !R450_is_scope_for_Statement().isEmpty() ) R450_is_scope_for_Statement().setParent_package( ref_parent_package );
            if ( !R453_controls_then_for_IfSmt().isEmpty() ) R453_controls_then_for_IfSmt().setParent_package( ref_parent_package );
            if ( !R458_has_in_scope_VariableInScope().isEmpty() ) R458_has_in_scope_VariableInScope().setParent_package( ref_parent_package );
        }
    }
    @Override
    public String getParent_package() throws XtumlException {
        checkLiving();
        return ref_parent_package;
    }
    private String ref_body_name;
    @Override
    public void setBody_name(String ref_body_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_body_name, this.ref_body_name)) {
            final String oldValue = this.ref_body_name;
            this.ref_body_name = ref_body_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_body_name", oldValue, this.ref_body_name));
            if ( !R456_controls_WhileSmt().isEmpty() ) R456_controls_WhileSmt().setBody_name( ref_body_name );
            if ( !R455_controls_ForSmt().isEmpty() ) R455_controls_ForSmt().setBody_name( ref_body_name );
            if ( !R450_is_scope_for_Statement().isEmpty() ) R450_is_scope_for_Statement().setBody_name( ref_body_name );
            if ( !R454_controls_else_for_IfSmt().isEmpty() ) R454_controls_else_for_IfSmt().setBody_name( ref_body_name );
            if ( !R458_has_in_scope_VariableInScope().isEmpty() ) R458_has_in_scope_VariableInScope().setBody_name( ref_body_name );
            if ( !R453_controls_then_for_IfSmt().isEmpty() ) R453_controls_then_for_IfSmt().setBody_name( ref_body_name );
        }
    }
    @Override
    public String getBody_name() throws XtumlException {
        checkLiving();
        return ref_body_name;
    }
    private String m_block_number;
    @Override
    public String getBlock_number() throws XtumlException {
        checkLiving();
        return m_block_number;
    }
    @Override
    public void setBlock_number(String m_block_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_block_number, this.m_block_number)) {
            final String oldValue = this.m_block_number;
            this.m_block_number = m_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_block_number", oldValue, this.m_block_number));
            if ( !R453_controls_then_for_IfSmt().isEmpty() ) R453_controls_then_for_IfSmt().setThen_block_number( m_block_number );
            if ( !R456_controls_WhileSmt().isEmpty() ) R456_controls_WhileSmt().setControl_block_number( m_block_number );
            if ( !R455_controls_ForSmt().isEmpty() ) R455_controls_ForSmt().setControl_block_number( m_block_number );
            if ( !R458_has_in_scope_VariableInScope().isEmpty() ) R458_has_in_scope_VariableInScope().setBlock_number( m_block_number );
            if ( !R454_controls_else_for_IfSmt().isEmpty() ) R454_controls_else_for_IfSmt().setElse_block_number( m_block_number );
            if ( !R450_is_scope_for_Statement().isEmpty() ) R450_is_scope_for_Statement().setBlock_number( m_block_number );
        }
    }
    private int m_tab_depth;
    @Override
    public void setTab_depth(int m_tab_depth) throws XtumlException {
        checkLiving();
        if (m_tab_depth != this.m_tab_depth) {
            final int oldValue = this.m_tab_depth;
            this.m_tab_depth = m_tab_depth;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_tab_depth", oldValue, this.m_tab_depth));
        }
    }
    @Override
    public int getTab_depth() throws XtumlException {
        checkLiving();
        return m_tab_depth;
    }
    private boolean m_top_level;
    @Override
    public boolean getTop_level() throws XtumlException {
        checkLiving();
        return m_top_level;
    }
    @Override
    public void setTop_level(boolean m_top_level) throws XtumlException {
        checkLiving();
        if (m_top_level != this.m_top_level) {
            final boolean oldValue = this.m_top_level;
            this.m_top_level = m_top_level;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_top_level", oldValue, this.m_top_level));
        }
    }
    private String m_prefix;
    @Override
    public String getPrefix() throws XtumlException {
        checkLiving();
        return m_prefix;
    }
    @Override
    public void setPrefix(String m_prefix) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_prefix, this.m_prefix)) {
            final String oldValue = this.m_prefix;
            this.m_prefix = m_prefix;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_prefix", oldValue, this.m_prefix));
        }
    }
    private String m_suffix;
    @Override
    public void setSuffix(String m_suffix) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_suffix, this.m_suffix)) {
            final String oldValue = this.m_suffix;
            this.m_suffix = m_suffix;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_suffix", oldValue, this.m_suffix));
        }
    }
    @Override
    public String getSuffix() throws XtumlException {
        checkLiving();
        return m_suffix;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getParent_name(), getParent_package(), getBody_name(), getBlock_number());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        StatementSet smts = self().R450_is_scope_for_Statement();
        boolean is_else_if = false;
        if ( smts.size() == 1 ) {
            IfSmt enclosing_else = self().R454_controls_else_for_IfSmt();
            IfSmt if_smt = self().R450_is_scope_for_Statement().R451_is_a_IfSmt().any();
            is_else_if = ( !enclosing_else.isEmpty() && !if_smt.isEmpty() ) && if_smt.getIs_else_if();
        }
        Statement statement = self().R450_is_scope_for_Statement().any();
        Statement prev_statement = statement.R477_executes_after_Statement();
        while ( !prev_statement.isEmpty() ) {
            statement = prev_statement;
            prev_statement = statement.R477_executes_after_Statement();
        }
        Mark action_comments_mark = context().Mark_instances().anyWhere(selected -> StringUtil.equality(((Mark)selected).getFeature_name(), "IncludeStatementComments"));
        while ( !statement.isEmpty() ) {
            if ( action_comments_mark.isEmpty() ) {
                statement.setActions("");
            }
            statement.render();
            statement = statement.R477_executes_before_Statement();
        }
        String statements = context().T().body();
        String indent = context().getIndent( self().getTab_depth() );
        InvocableObject invocable = self().R4000_is_invoked_in_InvocableObject();
        Type return_type = invocable.R428_return_value_is_typed_by_TypeReference().R3800_based_on_Type();
        AttributeDerivation deriv = invocable.R427_is_a_AttributeDerivation();
        boolean include_suffix = ( !deriv.isEmpty() || return_type.isEmpty() ) || StringUtil.equality("void", return_type.getName()) && StringUtil.equality("", return_type.getPackage());
        context().T().clear();
        context().T().include( "invocable/t.codeblock.java", include_suffix, indent, is_else_if, self(), statements );
    }



    // static operations


    // events


    // selections
    private InvocableObject R4000_is_invoked_in_InvocableObject_inst;
    @Override
    public void setR4000_is_invoked_in_InvocableObject( InvocableObject inst ) {
        R4000_is_invoked_in_InvocableObject_inst = inst;
    }
    @Override
    public InvocableObject R4000_is_invoked_in_InvocableObject() throws XtumlException {
        return R4000_is_invoked_in_InvocableObject_inst;
    }
    private StatementSet R450_is_scope_for_Statement_set;
    @Override
    public void addR450_is_scope_for_Statement( Statement inst ) {
        R450_is_scope_for_Statement_set.add(inst);
    }
    @Override
    public void removeR450_is_scope_for_Statement( Statement inst ) {
        R450_is_scope_for_Statement_set.remove(inst);
    }
    @Override
    public StatementSet R450_is_scope_for_Statement() throws XtumlException {
        return R450_is_scope_for_Statement_set;
    }
    private IfSmt R453_controls_then_for_IfSmt_inst;
    @Override
    public void setR453_controls_then_for_IfSmt( IfSmt inst ) {
        R453_controls_then_for_IfSmt_inst = inst;
    }
    @Override
    public IfSmt R453_controls_then_for_IfSmt() throws XtumlException {
        return R453_controls_then_for_IfSmt_inst;
    }
    private IfSmt R454_controls_else_for_IfSmt_inst;
    @Override
    public void setR454_controls_else_for_IfSmt( IfSmt inst ) {
        R454_controls_else_for_IfSmt_inst = inst;
    }
    @Override
    public IfSmt R454_controls_else_for_IfSmt() throws XtumlException {
        return R454_controls_else_for_IfSmt_inst;
    }
    private ForSmt R455_controls_ForSmt_inst;
    @Override
    public void setR455_controls_ForSmt( ForSmt inst ) {
        R455_controls_ForSmt_inst = inst;
    }
    @Override
    public ForSmt R455_controls_ForSmt() throws XtumlException {
        return R455_controls_ForSmt_inst;
    }
    private WhileSmt R456_controls_WhileSmt_inst;
    @Override
    public void setR456_controls_WhileSmt( WhileSmt inst ) {
        R456_controls_WhileSmt_inst = inst;
    }
    @Override
    public WhileSmt R456_controls_WhileSmt() throws XtumlException {
        return R456_controls_WhileSmt_inst;
    }
    private VariableInScopeSet R458_has_in_scope_VariableInScope_set;
    @Override
    public void addR458_has_in_scope_VariableInScope( VariableInScope inst ) {
        R458_has_in_scope_VariableInScope_set.add(inst);
    }
    @Override
    public void removeR458_has_in_scope_VariableInScope( VariableInScope inst ) {
        R458_has_in_scope_VariableInScope_set.remove(inst);
    }
    @Override
    public VariableInScopeSet R458_has_in_scope_VariableInScope() throws XtumlException {
        return R458_has_in_scope_VariableInScope_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public CodeBlock self() {
        return this;
    }

    @Override
    public CodeBlock oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_CODEBLOCK;
    }

}

class EmptyCodeBlock extends ModelInstance<CodeBlock,Sql> implements CodeBlock {

    // attributes
    public String getParent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBody_name( String ref_body_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBody_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getBlock_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBlock_number( String m_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setTab_depth( int m_tab_depth ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getTab_depth() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public boolean getTop_level() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setTop_level( boolean m_top_level ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getPrefix() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPrefix( String m_prefix ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSuffix( String m_suffix ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getSuffix() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public InvocableObject R4000_is_invoked_in_InvocableObject() {
        return InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
    }
    @Override
    public StatementSet R450_is_scope_for_Statement() {
        return (new StatementSetImpl());
    }
    @Override
    public IfSmt R453_controls_then_for_IfSmt() {
        return IfSmtImpl.EMPTY_IFSMT;
    }
    @Override
    public IfSmt R454_controls_else_for_IfSmt() {
        return IfSmtImpl.EMPTY_IFSMT;
    }
    @Override
    public ForSmt R455_controls_ForSmt() {
        return ForSmtImpl.EMPTY_FORSMT;
    }
    @Override
    public WhileSmt R456_controls_WhileSmt() {
        return WhileSmtImpl.EMPTY_WHILESMT;
    }
    @Override
    public VariableInScopeSet R458_has_in_scope_VariableInScope() {
        return (new VariableInScopeSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return CodeBlockImpl.KEY_LETTERS;
    }

    @Override
    public CodeBlock self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public CodeBlock oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return CodeBlockImpl.EMPTY_CODEBLOCK;
    }

}
