package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.expression.Expression;
import io.ciera.tool.sql.architecture.expression.VariableReference;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionImpl;
import io.ciera.tool.sql.architecture.statement.Finalization;
import io.ciera.tool.sql.architecture.statement.FinalizationSet;
import io.ciera.tool.sql.architecture.statement.Variable;
import io.ciera.tool.sql.architecture.statement.impl.VariableImpl;
import io.ciera.tool.sql.architecture.type.TypeReference;


public class VariableReferenceImpl extends ModelInstance<VariableReference,Sql> implements VariableReference {

    public static final String KEY_LETTERS = "VariableReference";
    public static final VariableReference EMPTY_VARIABLEREFERENCE = new EmptyVariableReference();

    private Sql context;

    // constructors
    private VariableReferenceImpl( Sql context ) {
        this.context = context;
        ref_parent_name = "";
        ref_parent_package = "";
        ref_body_name = "";
        ref_block_number = "";
        ref_statement_number = "";
        ref_expression_number = "";
        ref_var_block_number = "";
        ref_var_name = "";
        m_declaration = false;
        R776_is_a_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
        R782_refers_to_local_Variable_inst = VariableImpl.EMPTY_VARIABLE;
    }

    private VariableReferenceImpl( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_expression_number, String ref_var_block_number, String ref_var_name, boolean m_declaration ) {
        super(instanceId);
        this.context = context;
        this.ref_parent_name = ref_parent_name;
        this.ref_parent_package = ref_parent_package;
        this.ref_body_name = ref_body_name;
        this.ref_block_number = ref_block_number;
        this.ref_statement_number = ref_statement_number;
        this.ref_expression_number = ref_expression_number;
        this.ref_var_block_number = ref_var_block_number;
        this.ref_var_name = ref_var_name;
        this.m_declaration = m_declaration;
        R776_is_a_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
        R782_refers_to_local_Variable_inst = VariableImpl.EMPTY_VARIABLE;
    }

    public static VariableReference create( Sql context ) throws XtumlException {
        VariableReference newVariableReference = new VariableReferenceImpl( context );
        if ( context.addInstance( newVariableReference ) ) {
            newVariableReference.getRunContext().addChange(new InstanceCreatedDelta(newVariableReference, KEY_LETTERS));
            return newVariableReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static VariableReference create( Sql context, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_expression_number, String ref_var_block_number, String ref_var_name, boolean m_declaration ) throws XtumlException {
        return create(context, UniqueId.random(), ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, ref_statement_number, ref_expression_number, ref_var_block_number, ref_var_name, m_declaration);
    }

    public static VariableReference create( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_expression_number, String ref_var_block_number, String ref_var_name, boolean m_declaration ) throws XtumlException {
        VariableReference newVariableReference = new VariableReferenceImpl( context, instanceId, ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, ref_statement_number, ref_expression_number, ref_var_block_number, ref_var_name, m_declaration );
        if ( context.addInstance( newVariableReference ) ) {
            return newVariableReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_parent_name;
    @Override
    public String getParent_name() throws XtumlException {
        checkLiving();
        return ref_parent_name;
    }
    @Override
    public void setParent_name(String ref_parent_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_name, this.ref_parent_name)) {
            final String oldValue = this.ref_parent_name;
            this.ref_parent_name = ref_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_name", oldValue, this.ref_parent_name));
        }
    }
    private String ref_parent_package;
    @Override
    public void setParent_package(String ref_parent_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_package, this.ref_parent_package)) {
            final String oldValue = this.ref_parent_package;
            this.ref_parent_package = ref_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_package", oldValue, this.ref_parent_package));
        }
    }
    @Override
    public String getParent_package() throws XtumlException {
        checkLiving();
        return ref_parent_package;
    }
    private String ref_body_name;
    @Override
    public String getBody_name() throws XtumlException {
        checkLiving();
        return ref_body_name;
    }
    @Override
    public void setBody_name(String ref_body_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_body_name, this.ref_body_name)) {
            final String oldValue = this.ref_body_name;
            this.ref_body_name = ref_body_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_body_name", oldValue, this.ref_body_name));
        }
    }
    private String ref_block_number;
    @Override
    public String getBlock_number() throws XtumlException {
        checkLiving();
        return ref_block_number;
    }
    @Override
    public void setBlock_number(String ref_block_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_block_number, this.ref_block_number)) {
            final String oldValue = this.ref_block_number;
            this.ref_block_number = ref_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_block_number", oldValue, this.ref_block_number));
        }
    }
    private String ref_statement_number;
    @Override
    public void setStatement_number(String ref_statement_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_statement_number, this.ref_statement_number)) {
            final String oldValue = this.ref_statement_number;
            this.ref_statement_number = ref_statement_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_statement_number", oldValue, this.ref_statement_number));
        }
    }
    @Override
    public String getStatement_number() throws XtumlException {
        checkLiving();
        return ref_statement_number;
    }
    private String ref_expression_number;
    @Override
    public String getExpression_number() throws XtumlException {
        checkLiving();
        return ref_expression_number;
    }
    @Override
    public void setExpression_number(String ref_expression_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_expression_number, this.ref_expression_number)) {
            final String oldValue = this.ref_expression_number;
            this.ref_expression_number = ref_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_expression_number", oldValue, this.ref_expression_number));
        }
    }
    private String ref_var_block_number;
    @Override
    public void setVar_block_number(String ref_var_block_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_var_block_number, this.ref_var_block_number)) {
            final String oldValue = this.ref_var_block_number;
            this.ref_var_block_number = ref_var_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_var_block_number", oldValue, this.ref_var_block_number));
        }
    }
    @Override
    public String getVar_block_number() throws XtumlException {
        checkLiving();
        return ref_var_block_number;
    }
    private String ref_var_name;
    @Override
    public String getVar_name() throws XtumlException {
        checkLiving();
        return ref_var_name;
    }
    @Override
    public void setVar_name(String ref_var_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_var_name, this.ref_var_name)) {
            final String oldValue = this.ref_var_name;
            this.ref_var_name = ref_var_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_var_name", oldValue, this.ref_var_name));
        }
    }
    private boolean m_declaration;
    @Override
    public boolean getDeclaration() throws XtumlException {
        checkLiving();
        return m_declaration;
    }
    @Override
    public void setDeclaration(boolean m_declaration) throws XtumlException {
        checkLiving();
        if (m_declaration != this.m_declaration) {
            final boolean oldValue = this.m_declaration;
            this.m_declaration = m_declaration;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_declaration", oldValue, this.m_declaration));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getParent_name(), getParent_package(), getBody_name(), getBlock_number(), getStatement_number(), getExpression_number());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        Variable var = self().R782_refers_to_local_Variable();
        boolean var_readonly = var.getReadonly();
        TypeReference var_type = var.R461_is_typed_by_TypeReference();
        String type_name = var_type.getType_reference_name();
        String var_prefix = "";
        Finalization finalization = self().R782_refers_to_local_Variable().R485_finalized_by_Finalization().anyWhere(selected -> StringUtil.equality(((Finalization)selected).getBlock_number(), self().getBlock_number()) && StringUtil.equality(((Finalization)selected).getStatement_number(), self().getStatement_number()));
        if ( !finalization.isEmpty() ) {
            FinalizationSet previous_finalizations = ((FinalizationSet)self().R782_refers_to_local_Variable().R485_finalized_by_Finalization().where(selected -> StringUtil.lessThan(((Finalization)selected).getBlock_number(), self().getBlock_number()) || StringUtil.equality(((Finalization)selected).getBlock_number(), self().getBlock_number()) && StringUtil.lessThan(((Finalization)selected).getStatement_number(), self().getStatement_number())));
            int finalization_num = previous_finalizations.size();
            var_prefix = ( "_final" + context().STRING().itoa( finalization_num ) ) + "_";
        }
        context().T().include( "expression/t.variablereference.java", self(), type_name, var_prefix, var_readonly );
    }



    // static operations


    // events


    // selections
    private Expression R776_is_a_Expression_inst;
    @Override
    public void setR776_is_a_Expression( Expression inst ) {
        R776_is_a_Expression_inst = inst;
    }
    @Override
    public Expression R776_is_a_Expression() throws XtumlException {
        return R776_is_a_Expression_inst;
    }
    private Variable R782_refers_to_local_Variable_inst;
    @Override
    public void setR782_refers_to_local_Variable( Variable inst ) {
        R782_refers_to_local_Variable_inst = inst;
    }
    @Override
    public Variable R782_refers_to_local_Variable() throws XtumlException {
        return R782_refers_to_local_Variable_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public VariableReference self() {
        return this;
    }

    @Override
    public VariableReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_VARIABLEREFERENCE;
    }

}

class EmptyVariableReference extends ModelInstance<VariableReference,Sql> implements VariableReference {

    // attributes
    public String getParent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getBody_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBody_name( String ref_body_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBlock_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getStatement_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getExpression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setVar_block_number( String ref_var_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getVar_block_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getVar_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setVar_name( String ref_var_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getDeclaration() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDeclaration( boolean m_declaration ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public Expression R776_is_a_Expression() {
        return ExpressionImpl.EMPTY_EXPRESSION;
    }
    @Override
    public Variable R782_refers_to_local_Variable() {
        return VariableImpl.EMPTY_VARIABLE;
    }


    @Override
    public String getKeyLetters() {
        return VariableReferenceImpl.KEY_LETTERS;
    }

    @Override
    public VariableReference self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public VariableReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return VariableReferenceImpl.EMPTY_VARIABLEREFERENCE;
    }

}
