package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.classes.Attribute;
import io.ciera.tool.sql.architecture.classes.AttributeAccessor;
import io.ciera.tool.sql.architecture.classes.impl.AttributeImpl;
import io.ciera.tool.sql.architecture.expression.AttributeAccess;
import io.ciera.tool.sql.architecture.expression.Expression;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionImpl;

import types.AttributeAccessorType;


public class AttributeAccessImpl extends ModelInstance<AttributeAccess,Sql> implements AttributeAccess {

    public static final String KEY_LETTERS = "AttributeAccess";
    public static final AttributeAccess EMPTY_ATTRIBUTEACCESS = new EmptyAttributeAccess();

    private Sql context;

    // constructors
    private AttributeAccessImpl( Sql context ) {
        this.context = context;
        ref_parent_name = "";
        ref_parent_package = "";
        ref_body_name = "";
        ref_block_number = "";
        ref_statement_number = "";
        ref_expression_number = "";
        ref_root_expression_number = "";
        ref_attr_class_name = "";
        ref_attr_class_package = "";
        ref_attr_name = "";
        R776_is_a_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
        R785_refers_to_attribute_of_instance_expressed_by_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
        R788_refers_to_Attribute_inst = AttributeImpl.EMPTY_ATTRIBUTE;
    }

    private AttributeAccessImpl( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_expression_number, String ref_root_expression_number, String ref_attr_class_name, String ref_attr_class_package, String ref_attr_name ) {
        super(instanceId);
        this.context = context;
        this.ref_parent_name = ref_parent_name;
        this.ref_parent_package = ref_parent_package;
        this.ref_body_name = ref_body_name;
        this.ref_block_number = ref_block_number;
        this.ref_statement_number = ref_statement_number;
        this.ref_expression_number = ref_expression_number;
        this.ref_root_expression_number = ref_root_expression_number;
        this.ref_attr_class_name = ref_attr_class_name;
        this.ref_attr_class_package = ref_attr_class_package;
        this.ref_attr_name = ref_attr_name;
        R776_is_a_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
        R785_refers_to_attribute_of_instance_expressed_by_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
        R788_refers_to_Attribute_inst = AttributeImpl.EMPTY_ATTRIBUTE;
    }

    public static AttributeAccess create( Sql context ) throws XtumlException {
        AttributeAccess newAttributeAccess = new AttributeAccessImpl( context );
        if ( context.addInstance( newAttributeAccess ) ) {
            newAttributeAccess.getRunContext().addChange(new InstanceCreatedDelta(newAttributeAccess, KEY_LETTERS));
            return newAttributeAccess;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static AttributeAccess create( Sql context, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_expression_number, String ref_root_expression_number, String ref_attr_class_name, String ref_attr_class_package, String ref_attr_name ) throws XtumlException {
        return create(context, UniqueId.random(), ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, ref_statement_number, ref_expression_number, ref_root_expression_number, ref_attr_class_name, ref_attr_class_package, ref_attr_name);
    }

    public static AttributeAccess create( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_expression_number, String ref_root_expression_number, String ref_attr_class_name, String ref_attr_class_package, String ref_attr_name ) throws XtumlException {
        AttributeAccess newAttributeAccess = new AttributeAccessImpl( context, instanceId, ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, ref_statement_number, ref_expression_number, ref_root_expression_number, ref_attr_class_name, ref_attr_class_package, ref_attr_name );
        if ( context.addInstance( newAttributeAccess ) ) {
            return newAttributeAccess;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_parent_name;
    @Override
    public String getParent_name() throws XtumlException {
        checkLiving();
        return ref_parent_name;
    }
    @Override
    public void setParent_name(String ref_parent_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_name, this.ref_parent_name)) {
            final String oldValue = this.ref_parent_name;
            this.ref_parent_name = ref_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_name", oldValue, this.ref_parent_name));
        }
    }
    private String ref_parent_package;
    @Override
    public void setParent_package(String ref_parent_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_package, this.ref_parent_package)) {
            final String oldValue = this.ref_parent_package;
            this.ref_parent_package = ref_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_package", oldValue, this.ref_parent_package));
        }
    }
    @Override
    public String getParent_package() throws XtumlException {
        checkLiving();
        return ref_parent_package;
    }
    private String ref_body_name;
    @Override
    public void setBody_name(String ref_body_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_body_name, this.ref_body_name)) {
            final String oldValue = this.ref_body_name;
            this.ref_body_name = ref_body_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_body_name", oldValue, this.ref_body_name));
        }
    }
    @Override
    public String getBody_name() throws XtumlException {
        checkLiving();
        return ref_body_name;
    }
    private String ref_block_number;
    @Override
    public void setBlock_number(String ref_block_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_block_number, this.ref_block_number)) {
            final String oldValue = this.ref_block_number;
            this.ref_block_number = ref_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_block_number", oldValue, this.ref_block_number));
        }
    }
    @Override
    public String getBlock_number() throws XtumlException {
        checkLiving();
        return ref_block_number;
    }
    private String ref_statement_number;
    @Override
    public void setStatement_number(String ref_statement_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_statement_number, this.ref_statement_number)) {
            final String oldValue = this.ref_statement_number;
            this.ref_statement_number = ref_statement_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_statement_number", oldValue, this.ref_statement_number));
        }
    }
    @Override
    public String getStatement_number() throws XtumlException {
        checkLiving();
        return ref_statement_number;
    }
    private String ref_expression_number;
    @Override
    public void setExpression_number(String ref_expression_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_expression_number, this.ref_expression_number)) {
            final String oldValue = this.ref_expression_number;
            this.ref_expression_number = ref_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_expression_number", oldValue, this.ref_expression_number));
        }
    }
    @Override
    public String getExpression_number() throws XtumlException {
        checkLiving();
        return ref_expression_number;
    }
    private String ref_root_expression_number;
    @Override
    public String getRoot_expression_number() throws XtumlException {
        checkLiving();
        return ref_root_expression_number;
    }
    @Override
    public void setRoot_expression_number(String ref_root_expression_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_root_expression_number, this.ref_root_expression_number)) {
            final String oldValue = this.ref_root_expression_number;
            this.ref_root_expression_number = ref_root_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_root_expression_number", oldValue, this.ref_root_expression_number));
        }
    }
    private String ref_attr_class_name;
    @Override
    public String getAttr_class_name() throws XtumlException {
        checkLiving();
        return ref_attr_class_name;
    }
    @Override
    public void setAttr_class_name(String ref_attr_class_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_attr_class_name, this.ref_attr_class_name)) {
            final String oldValue = this.ref_attr_class_name;
            this.ref_attr_class_name = ref_attr_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_attr_class_name", oldValue, this.ref_attr_class_name));
        }
    }
    private String ref_attr_class_package;
    @Override
    public String getAttr_class_package() throws XtumlException {
        checkLiving();
        return ref_attr_class_package;
    }
    @Override
    public void setAttr_class_package(String ref_attr_class_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_attr_class_package, this.ref_attr_class_package)) {
            final String oldValue = this.ref_attr_class_package;
            this.ref_attr_class_package = ref_attr_class_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_attr_class_package", oldValue, this.ref_attr_class_package));
        }
    }
    private String ref_attr_name;
    @Override
    public String getAttr_name() throws XtumlException {
        checkLiving();
        return ref_attr_name;
    }
    @Override
    public void setAttr_name(String ref_attr_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_attr_name, this.ref_attr_name)) {
            final String oldValue = this.ref_attr_name;
            this.ref_attr_name = ref_attr_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_attr_name", oldValue, this.ref_attr_name));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getParent_name(), getParent_package(), getBody_name(), getBlock_number(), getStatement_number(), getExpression_number());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        if ( self().validateExpressionType() ) {
            context().T().push_buffer();
            Expression expression = self().R785_refers_to_attribute_of_instance_expressed_by_Expression();
            expression.render();
            String root_expression_body = context().T().body();
            context().T().pop_buffer();
            AttributeAccessor attribute_accessor = self().R788_refers_to_Attribute().R4510_value_accessed_through_AttributeAccessor().anyWhere(selected -> ((AttributeAccessor)selected).getAccessor_type().equality(AttributeAccessorType.GETTER));
            String accessor = attribute_accessor.getName();
            context().T().include( "expression/t.attributeaccess.java", accessor, root_expression_body );
        }
    }

    @Override
    public boolean validateExpressionType() throws XtumlException {
        return true;
    }



    // static operations


    // events


    // selections
    private Expression R776_is_a_Expression_inst;
    @Override
    public void setR776_is_a_Expression( Expression inst ) {
        R776_is_a_Expression_inst = inst;
    }
    @Override
    public Expression R776_is_a_Expression() throws XtumlException {
        return R776_is_a_Expression_inst;
    }
    private Expression R785_refers_to_attribute_of_instance_expressed_by_Expression_inst;
    @Override
    public void setR785_refers_to_attribute_of_instance_expressed_by_Expression( Expression inst ) {
        R785_refers_to_attribute_of_instance_expressed_by_Expression_inst = inst;
    }
    @Override
    public Expression R785_refers_to_attribute_of_instance_expressed_by_Expression() throws XtumlException {
        return R785_refers_to_attribute_of_instance_expressed_by_Expression_inst;
    }
    private Attribute R788_refers_to_Attribute_inst;
    @Override
    public void setR788_refers_to_Attribute( Attribute inst ) {
        R788_refers_to_Attribute_inst = inst;
    }
    @Override
    public Attribute R788_refers_to_Attribute() throws XtumlException {
        return R788_refers_to_Attribute_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public AttributeAccess self() {
        return this;
    }

    @Override
    public AttributeAccess oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_ATTRIBUTEACCESS;
    }

}

class EmptyAttributeAccess extends ModelInstance<AttributeAccess,Sql> implements AttributeAccess {

    // attributes
    public String getParent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBody_name( String ref_body_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBody_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBlock_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getStatement_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getExpression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getRoot_expression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRoot_expression_number( String ref_root_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getAttr_class_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAttr_class_name( String ref_attr_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getAttr_class_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAttr_class_package( String ref_attr_class_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getAttr_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAttr_name( String ref_attr_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public boolean validateExpressionType() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public Expression R776_is_a_Expression() {
        return ExpressionImpl.EMPTY_EXPRESSION;
    }
    @Override
    public Expression R785_refers_to_attribute_of_instance_expressed_by_Expression() {
        return ExpressionImpl.EMPTY_EXPRESSION;
    }
    @Override
    public Attribute R788_refers_to_Attribute() {
        return AttributeImpl.EMPTY_ATTRIBUTE;
    }


    @Override
    public String getKeyLetters() {
        return AttributeAccessImpl.KEY_LETTERS;
    }

    @Override
    public AttributeAccess self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public AttributeAccess oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return AttributeAccessImpl.EMPTY_ATTRIBUTEACCESS;
    }

}
