package io.ciera.tool.sql.architecture.component.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.classes.InstSet;
import io.ciera.tool.sql.architecture.classes.ModelInst;
import io.ciera.tool.sql.architecture.classes.impl.ModelInstImpl;
import io.ciera.tool.sql.architecture.component.ComponentDefinition;
import io.ciera.tool.sql.architecture.component.InstancePopulationSelector;
import io.ciera.tool.sql.architecture.component.impl.ComponentDefinitionImpl;
import io.ciera.tool.sql.architecture.expression.SelectFromInstances;
import io.ciera.tool.sql.architecture.expression.SelectFromInstancesSet;
import io.ciera.tool.sql.architecture.expression.impl.SelectFromInstancesSetImpl;


public class InstancePopulationSelectorImpl extends ModelInstance<InstancePopulationSelector,Sql> implements InstancePopulationSelector {

    public static final String KEY_LETTERS = "InstancePopulationSelector";
    public static final InstancePopulationSelector EMPTY_INSTANCEPOPULATIONSELECTOR = new EmptyInstancePopulationSelector();

    private Sql context;

    // constructors
    private InstancePopulationSelectorImpl( Sql context ) {
        this.context = context;
        ref_comp_name = "";
        ref_comp_package = "";
        m_name = "";
        ref_class_name = "";
        ref_class_package = "";
        R447_selects_instances_out_of_population_of_ComponentDefinition_inst = ComponentDefinitionImpl.EMPTY_COMPONENTDEFINITION;
        R449_selects_instances_of_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
        R799_invoked_by_SelectFromInstances_set = new SelectFromInstancesSetImpl();
    }

    private InstancePopulationSelectorImpl( Sql context, UniqueId instanceId, String ref_comp_name, String ref_comp_package, String m_name, String ref_class_name, String ref_class_package ) {
        super(instanceId);
        this.context = context;
        this.ref_comp_name = ref_comp_name;
        this.ref_comp_package = ref_comp_package;
        this.m_name = m_name;
        this.ref_class_name = ref_class_name;
        this.ref_class_package = ref_class_package;
        R447_selects_instances_out_of_population_of_ComponentDefinition_inst = ComponentDefinitionImpl.EMPTY_COMPONENTDEFINITION;
        R449_selects_instances_of_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
        R799_invoked_by_SelectFromInstances_set = new SelectFromInstancesSetImpl();
    }

    public static InstancePopulationSelector create( Sql context ) throws XtumlException {
        InstancePopulationSelector newInstancePopulationSelector = new InstancePopulationSelectorImpl( context );
        if ( context.addInstance( newInstancePopulationSelector ) ) {
            newInstancePopulationSelector.getRunContext().addChange(new InstanceCreatedDelta(newInstancePopulationSelector, KEY_LETTERS));
            return newInstancePopulationSelector;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static InstancePopulationSelector create( Sql context, String ref_comp_name, String ref_comp_package, String m_name, String ref_class_name, String ref_class_package ) throws XtumlException {
        return create(context, UniqueId.random(), ref_comp_name, ref_comp_package, m_name, ref_class_name, ref_class_package);
    }

    public static InstancePopulationSelector create( Sql context, UniqueId instanceId, String ref_comp_name, String ref_comp_package, String m_name, String ref_class_name, String ref_class_package ) throws XtumlException {
        InstancePopulationSelector newInstancePopulationSelector = new InstancePopulationSelectorImpl( context, instanceId, ref_comp_name, ref_comp_package, m_name, ref_class_name, ref_class_package );
        if ( context.addInstance( newInstancePopulationSelector ) ) {
            return newInstancePopulationSelector;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_comp_name;
    @Override
    public String getComp_name() throws XtumlException {
        checkLiving();
        return ref_comp_name;
    }
    @Override
    public void setComp_name(String ref_comp_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_comp_name, this.ref_comp_name)) {
            final String oldValue = this.ref_comp_name;
            this.ref_comp_name = ref_comp_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_comp_name", oldValue, this.ref_comp_name));
            if ( !R799_invoked_by_SelectFromInstances().isEmpty() ) R799_invoked_by_SelectFromInstances().setSelector_comp_name( ref_comp_name );
        }
    }
    private String ref_comp_package;
    @Override
    public String getComp_package() throws XtumlException {
        checkLiving();
        return ref_comp_package;
    }
    @Override
    public void setComp_package(String ref_comp_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_comp_package, this.ref_comp_package)) {
            final String oldValue = this.ref_comp_package;
            this.ref_comp_package = ref_comp_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_comp_package", oldValue, this.ref_comp_package));
            if ( !R799_invoked_by_SelectFromInstances().isEmpty() ) R799_invoked_by_SelectFromInstances().setSelector_comp_package( ref_comp_package );
        }
    }
    private String m_name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_name;
    }
    @Override
    public void setName(String m_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_name, this.m_name)) {
            final String oldValue = this.m_name;
            this.m_name = m_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_name", oldValue, this.m_name));
            if ( !R799_invoked_by_SelectFromInstances().isEmpty() ) R799_invoked_by_SelectFromInstances().setSelector_name( m_name );
        }
    }
    private String ref_class_name;
    @Override
    public String getClass_name() throws XtumlException {
        checkLiving();
        return ref_class_name;
    }
    @Override
    public void setClass_name(String ref_class_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_class_name, this.ref_class_name)) {
            final String oldValue = this.ref_class_name;
            this.ref_class_name = ref_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_name", oldValue, this.ref_class_name));
        }
    }
    private String ref_class_package;
    @Override
    public void setClass_package(String ref_class_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_class_package, this.ref_class_package)) {
            final String oldValue = this.ref_class_package;
            this.ref_class_package = ref_class_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_package", oldValue, this.ref_class_package));
        }
    }
    @Override
    public String getClass_package() throws XtumlException {
        checkLiving();
        return ref_class_package;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getComp_name(), getComp_package(), getName());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        InstSet objset = self().R449_selects_instances_of_ModelInst().R406_is_type_of_single_element_in_InstSet();
        String set_name = objset.getName();
        context().T().include( "component/t.instancepopulationselector.java", self(), set_name );
    }



    // static operations


    // events


    // selections
    private ComponentDefinition R447_selects_instances_out_of_population_of_ComponentDefinition_inst;
    @Override
    public void setR447_selects_instances_out_of_population_of_ComponentDefinition( ComponentDefinition inst ) {
        R447_selects_instances_out_of_population_of_ComponentDefinition_inst = inst;
    }
    @Override
    public ComponentDefinition R447_selects_instances_out_of_population_of_ComponentDefinition() throws XtumlException {
        return R447_selects_instances_out_of_population_of_ComponentDefinition_inst;
    }
    private ModelInst R449_selects_instances_of_ModelInst_inst;
    @Override
    public void setR449_selects_instances_of_ModelInst( ModelInst inst ) {
        R449_selects_instances_of_ModelInst_inst = inst;
    }
    @Override
    public ModelInst R449_selects_instances_of_ModelInst() throws XtumlException {
        return R449_selects_instances_of_ModelInst_inst;
    }
    private SelectFromInstancesSet R799_invoked_by_SelectFromInstances_set;
    @Override
    public void addR799_invoked_by_SelectFromInstances( SelectFromInstances inst ) {
        R799_invoked_by_SelectFromInstances_set.add(inst);
    }
    @Override
    public void removeR799_invoked_by_SelectFromInstances( SelectFromInstances inst ) {
        R799_invoked_by_SelectFromInstances_set.remove(inst);
    }
    @Override
    public SelectFromInstancesSet R799_invoked_by_SelectFromInstances() throws XtumlException {
        return R799_invoked_by_SelectFromInstances_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public InstancePopulationSelector self() {
        return this;
    }

    @Override
    public InstancePopulationSelector oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_INSTANCEPOPULATIONSELECTOR;
    }

}

class EmptyInstancePopulationSelector extends ModelInstance<InstancePopulationSelector,Sql> implements InstancePopulationSelector {

    // attributes
    public String getComp_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getComp_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getClass_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setClass_name( String ref_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setClass_package( String ref_class_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getClass_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public ComponentDefinition R447_selects_instances_out_of_population_of_ComponentDefinition() {
        return ComponentDefinitionImpl.EMPTY_COMPONENTDEFINITION;
    }
    @Override
    public ModelInst R449_selects_instances_of_ModelInst() {
        return ModelInstImpl.EMPTY_MODELINST;
    }
    @Override
    public SelectFromInstancesSet R799_invoked_by_SelectFromInstances() {
        return (new SelectFromInstancesSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return InstancePopulationSelectorImpl.KEY_LETTERS;
    }

    @Override
    public InstancePopulationSelector self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public InstancePopulationSelector oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return InstancePopulationSelectorImpl.EMPTY_INSTANCEPOPULATIONSELECTOR;
    }

}
