package io.ciera.tool.sql.architecture.classes.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.classes.ClassRelationship;
import io.ciera.tool.sql.architecture.classes.InstanceSelector;
import io.ciera.tool.sql.architecture.classes.Selector;
import io.ciera.tool.sql.architecture.classes.SetSelector;
import io.ciera.tool.sql.architecture.classes.impl.ClassRelationshipImpl;
import io.ciera.tool.sql.architecture.classes.impl.InstanceSelectorImpl;
import io.ciera.tool.sql.architecture.classes.impl.SetSelectorImpl;
import io.ciera.tool.sql.architecture.expression.SelectRelated;
import io.ciera.tool.sql.architecture.expression.SelectRelatedSet;
import io.ciera.tool.sql.architecture.expression.impl.SelectRelatedSetImpl;
import io.ciera.tool.sql.architecture.type.TypeReference;
import io.ciera.tool.sql.architecture.type.impl.TypeReferenceImpl;

import types.Mult;


public class SelectorImpl extends ModelInstance<Selector,Sql> implements Selector {

    public static final String KEY_LETTERS = "Selector";
    public static final Selector EMPTY_SELECTOR = new EmptySelector();

    private Sql context;

    // constructors
    private SelectorImpl( Sql context ) {
        this.context = context;
        m_parent_name = "";
        m_parent_package = "";
        m_name = "";
        m_multiplicity = Mult.UNINITIALIZED_ENUM;
        ref_rel_comp_name = "";
        ref_rel_comp_package = "";
        ref_rel_name = "";
        ref_type_name = "";
        ref_type_package = "";
        ref_type_reference_name = "";
        R445_is_a_InstanceSelector_inst = InstanceSelectorImpl.EMPTY_INSTANCESELECTOR;
        R445_is_a_SetSelector_inst = SetSelectorImpl.EMPTY_SETSELECTOR;
        R446_selects_instances_of_TypeReference_inst = TypeReferenceImpl.EMPTY_TYPEREFERENCE;
        R4512_traverses_across_ClassRelationship_inst = ClassRelationshipImpl.EMPTY_CLASSRELATIONSHIP;
        R797_invoked_by_SelectRelated_set = new SelectRelatedSetImpl();
    }

    private SelectorImpl( Sql context, UniqueId instanceId, String m_parent_name, String m_parent_package, String m_name, Mult m_multiplicity, String ref_rel_comp_name, String ref_rel_comp_package, String ref_rel_name, String ref_type_name, String ref_type_package, String ref_type_reference_name ) {
        super(instanceId);
        this.context = context;
        this.m_parent_name = m_parent_name;
        this.m_parent_package = m_parent_package;
        this.m_name = m_name;
        this.m_multiplicity = m_multiplicity;
        this.ref_rel_comp_name = ref_rel_comp_name;
        this.ref_rel_comp_package = ref_rel_comp_package;
        this.ref_rel_name = ref_rel_name;
        this.ref_type_name = ref_type_name;
        this.ref_type_package = ref_type_package;
        this.ref_type_reference_name = ref_type_reference_name;
        R445_is_a_InstanceSelector_inst = InstanceSelectorImpl.EMPTY_INSTANCESELECTOR;
        R445_is_a_SetSelector_inst = SetSelectorImpl.EMPTY_SETSELECTOR;
        R446_selects_instances_of_TypeReference_inst = TypeReferenceImpl.EMPTY_TYPEREFERENCE;
        R4512_traverses_across_ClassRelationship_inst = ClassRelationshipImpl.EMPTY_CLASSRELATIONSHIP;
        R797_invoked_by_SelectRelated_set = new SelectRelatedSetImpl();
    }

    public static Selector create( Sql context ) throws XtumlException {
        Selector newSelector = new SelectorImpl( context );
        if ( context.addInstance( newSelector ) ) {
            newSelector.getRunContext().addChange(new InstanceCreatedDelta(newSelector, KEY_LETTERS));
            return newSelector;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Selector create( Sql context, String m_parent_name, String m_parent_package, String m_name, Mult m_multiplicity, String ref_rel_comp_name, String ref_rel_comp_package, String ref_rel_name, String ref_type_name, String ref_type_package, String ref_type_reference_name ) throws XtumlException {
        return create(context, UniqueId.random(), m_parent_name, m_parent_package, m_name, m_multiplicity, ref_rel_comp_name, ref_rel_comp_package, ref_rel_name, ref_type_name, ref_type_package, ref_type_reference_name);
    }

    public static Selector create( Sql context, UniqueId instanceId, String m_parent_name, String m_parent_package, String m_name, Mult m_multiplicity, String ref_rel_comp_name, String ref_rel_comp_package, String ref_rel_name, String ref_type_name, String ref_type_package, String ref_type_reference_name ) throws XtumlException {
        Selector newSelector = new SelectorImpl( context, instanceId, m_parent_name, m_parent_package, m_name, m_multiplicity, ref_rel_comp_name, ref_rel_comp_package, ref_rel_name, ref_type_name, ref_type_package, ref_type_reference_name );
        if ( context.addInstance( newSelector ) ) {
            return newSelector;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String m_parent_name;
    @Override
    public void setParent_name(String m_parent_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_parent_name, this.m_parent_name)) {
            final String oldValue = this.m_parent_name;
            this.m_parent_name = m_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_parent_name", oldValue, this.m_parent_name));
            if ( !R797_invoked_by_SelectRelated().isEmpty() ) R797_invoked_by_SelectRelated().setSelector_parent_name( m_parent_name );
            if ( !R445_is_a_InstanceSelector().isEmpty() ) R445_is_a_InstanceSelector().setClass_name( m_parent_name );
            if ( !R445_is_a_SetSelector().isEmpty() ) R445_is_a_SetSelector().setSet_parent_name( m_parent_name );
        }
    }
    @Override
    public String getParent_name() throws XtumlException {
        checkLiving();
        return m_parent_name;
    }
    private String m_parent_package;
    @Override
    public void setParent_package(String m_parent_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_parent_package, this.m_parent_package)) {
            final String oldValue = this.m_parent_package;
            this.m_parent_package = m_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_parent_package", oldValue, this.m_parent_package));
            if ( !R445_is_a_InstanceSelector().isEmpty() ) R445_is_a_InstanceSelector().setClass_package( m_parent_package );
            if ( !R445_is_a_SetSelector().isEmpty() ) R445_is_a_SetSelector().setSet_parent_package( m_parent_package );
            if ( !R797_invoked_by_SelectRelated().isEmpty() ) R797_invoked_by_SelectRelated().setSelector_parent_package( m_parent_package );
        }
    }
    @Override
    public String getParent_package() throws XtumlException {
        checkLiving();
        return m_parent_package;
    }
    private String m_name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_name;
    }
    @Override
    public void setName(String m_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_name, this.m_name)) {
            final String oldValue = this.m_name;
            this.m_name = m_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_name", oldValue, this.m_name));
            if ( !R445_is_a_SetSelector().isEmpty() ) R445_is_a_SetSelector().setName( m_name );
            if ( !R797_invoked_by_SelectRelated().isEmpty() ) R797_invoked_by_SelectRelated().setSelector_name( m_name );
            if ( !R445_is_a_InstanceSelector().isEmpty() ) R445_is_a_InstanceSelector().setName( m_name );
        }
    }
    private Mult m_multiplicity;
    @Override
    public Mult getMultiplicity() throws XtumlException {
        checkLiving();
        return m_multiplicity;
    }
    @Override
    public void setMultiplicity(Mult m_multiplicity) throws XtumlException {
        checkLiving();
        if (m_multiplicity.inequality( this.m_multiplicity)) {
            final Mult oldValue = this.m_multiplicity;
            this.m_multiplicity = m_multiplicity;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_multiplicity", oldValue, this.m_multiplicity));
        }
    }
    private String ref_rel_comp_name;
    @Override
    public void setRel_comp_name(String ref_rel_comp_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_rel_comp_name, this.ref_rel_comp_name)) {
            final String oldValue = this.ref_rel_comp_name;
            this.ref_rel_comp_name = ref_rel_comp_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_rel_comp_name", oldValue, this.ref_rel_comp_name));
        }
    }
    @Override
    public String getRel_comp_name() throws XtumlException {
        checkLiving();
        return ref_rel_comp_name;
    }
    private String ref_rel_comp_package;
    @Override
    public String getRel_comp_package() throws XtumlException {
        checkLiving();
        return ref_rel_comp_package;
    }
    @Override
    public void setRel_comp_package(String ref_rel_comp_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_rel_comp_package, this.ref_rel_comp_package)) {
            final String oldValue = this.ref_rel_comp_package;
            this.ref_rel_comp_package = ref_rel_comp_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_rel_comp_package", oldValue, this.ref_rel_comp_package));
        }
    }
    private String ref_rel_name;
    @Override
    public void setRel_name(String ref_rel_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_rel_name, this.ref_rel_name)) {
            final String oldValue = this.ref_rel_name;
            this.ref_rel_name = ref_rel_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_rel_name", oldValue, this.ref_rel_name));
        }
    }
    @Override
    public String getRel_name() throws XtumlException {
        checkLiving();
        return ref_rel_name;
    }
    private String ref_type_name;
    @Override
    public String getType_name() throws XtumlException {
        checkLiving();
        return ref_type_name;
    }
    @Override
    public void setType_name(String ref_type_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_type_name, this.ref_type_name)) {
            final String oldValue = this.ref_type_name;
            this.ref_type_name = ref_type_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_type_name", oldValue, this.ref_type_name));
        }
    }
    private String ref_type_package;
    @Override
    public void setType_package(String ref_type_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_type_package, this.ref_type_package)) {
            final String oldValue = this.ref_type_package;
            this.ref_type_package = ref_type_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_type_package", oldValue, this.ref_type_package));
        }
    }
    @Override
    public String getType_package() throws XtumlException {
        checkLiving();
        return ref_type_package;
    }
    private String ref_type_reference_name;
    @Override
    public void setType_reference_name(String ref_type_reference_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_type_reference_name, this.ref_type_reference_name)) {
            final String oldValue = this.ref_type_reference_name;
            this.ref_type_reference_name = ref_type_reference_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_type_reference_name", oldValue, this.ref_type_reference_name));
        }
    }
    @Override
    public String getType_reference_name() throws XtumlException {
        checkLiving();
        return ref_type_reference_name;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getParent_name(), getParent_package(), getName());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private InstanceSelector R445_is_a_InstanceSelector_inst;
    @Override
    public void setR445_is_a_InstanceSelector( InstanceSelector inst ) {
        R445_is_a_InstanceSelector_inst = inst;
    }
    @Override
    public InstanceSelector R445_is_a_InstanceSelector() throws XtumlException {
        return R445_is_a_InstanceSelector_inst;
    }
    private SetSelector R445_is_a_SetSelector_inst;
    @Override
    public void setR445_is_a_SetSelector( SetSelector inst ) {
        R445_is_a_SetSelector_inst = inst;
    }
    @Override
    public SetSelector R445_is_a_SetSelector() throws XtumlException {
        return R445_is_a_SetSelector_inst;
    }
    private TypeReference R446_selects_instances_of_TypeReference_inst;
    @Override
    public void setR446_selects_instances_of_TypeReference( TypeReference inst ) {
        R446_selects_instances_of_TypeReference_inst = inst;
    }
    @Override
    public TypeReference R446_selects_instances_of_TypeReference() throws XtumlException {
        return R446_selects_instances_of_TypeReference_inst;
    }
    private ClassRelationship R4512_traverses_across_ClassRelationship_inst;
    @Override
    public void setR4512_traverses_across_ClassRelationship( ClassRelationship inst ) {
        R4512_traverses_across_ClassRelationship_inst = inst;
    }
    @Override
    public ClassRelationship R4512_traverses_across_ClassRelationship() throws XtumlException {
        return R4512_traverses_across_ClassRelationship_inst;
    }
    private SelectRelatedSet R797_invoked_by_SelectRelated_set;
    @Override
    public void addR797_invoked_by_SelectRelated( SelectRelated inst ) {
        R797_invoked_by_SelectRelated_set.add(inst);
    }
    @Override
    public void removeR797_invoked_by_SelectRelated( SelectRelated inst ) {
        R797_invoked_by_SelectRelated_set.remove(inst);
    }
    @Override
    public SelectRelatedSet R797_invoked_by_SelectRelated() throws XtumlException {
        return R797_invoked_by_SelectRelated_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Selector self() {
        return this;
    }

    @Override
    public Selector oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_SELECTOR;
    }

}

class EmptySelector extends ModelInstance<Selector,Sql> implements Selector {

    // attributes
    public void setParent_name( String m_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_package( String m_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public Mult getMultiplicity() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setMultiplicity( Mult m_multiplicity ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setRel_comp_name( String ref_rel_comp_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getRel_comp_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getRel_comp_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRel_comp_package( String ref_rel_comp_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setRel_name( String ref_rel_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getRel_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getType_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setType_name( String ref_type_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setType_package( String ref_type_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getType_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setType_reference_name( String ref_type_reference_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getType_reference_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public InstanceSelector R445_is_a_InstanceSelector() {
        return InstanceSelectorImpl.EMPTY_INSTANCESELECTOR;
    }
    @Override
    public SetSelector R445_is_a_SetSelector() {
        return SetSelectorImpl.EMPTY_SETSELECTOR;
    }
    @Override
    public TypeReference R446_selects_instances_of_TypeReference() {
        return TypeReferenceImpl.EMPTY_TYPEREFERENCE;
    }
    @Override
    public ClassRelationship R4512_traverses_across_ClassRelationship() {
        return ClassRelationshipImpl.EMPTY_CLASSRELATIONSHIP;
    }
    @Override
    public SelectRelatedSet R797_invoked_by_SelectRelated() {
        return (new SelectRelatedSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return SelectorImpl.KEY_LETTERS;
    }

    @Override
    public Selector self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Selector oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return SelectorImpl.EMPTY_SELECTOR;
    }

}
