package io.ciera.tool.sql.architecture.classes.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.classes.AttributeReferenceSet;
import io.ciera.tool.sql.architecture.classes.ClassRelationship;
import io.ciera.tool.sql.architecture.classes.ClassRelationshipSet;
import io.ciera.tool.sql.architecture.classes.ModelInstSet;
import io.ciera.tool.sql.architecture.classes.SelectorSet;
import io.ciera.tool.sql.architecture.classes.impl.AttributeReferenceSetImpl;
import io.ciera.tool.sql.architecture.classes.impl.ClassRelationshipSetImpl;
import io.ciera.tool.sql.architecture.classes.impl.ModelInstSetImpl;
import io.ciera.tool.sql.architecture.classes.impl.SelectorSetImpl;
import io.ciera.tool.sql.architecture.component.ComponentDefinitionSet;
import io.ciera.tool.sql.architecture.component.RelationshipPopulationSelectorSet;
import io.ciera.tool.sql.architecture.component.impl.ComponentDefinitionSetImpl;
import io.ciera.tool.sql.architecture.component.impl.RelationshipPopulationSelectorSetImpl;
import io.ciera.tool.sql.architecture.statement.RelateSmtSet;
import io.ciera.tool.sql.architecture.statement.UnrelateSmtSet;
import io.ciera.tool.sql.architecture.statement.impl.RelateSmtSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.UnrelateSmtSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

import types.Cond;
import types.Mult;
import types.RelationshipType;


public class ClassRelationshipSetImpl extends InstanceSet<ClassRelationshipSet,ClassRelationship> implements ClassRelationshipSet {

    public ClassRelationshipSetImpl() {
    }

    public ClassRelationshipSetImpl(Comparator<? super ClassRelationship> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setForm_cond( Cond m_form_cond ) throws XtumlException {
        for ( ClassRelationship classrelationship : this ) classrelationship.setForm_cond( m_form_cond );
    }
    @Override
    public void setForm_phrase( String m_form_phrase ) throws XtumlException {
        for ( ClassRelationship classrelationship : this ) classrelationship.setForm_phrase( m_form_phrase );
    }
    @Override
    public void setForm_package( String ref_form_package ) throws XtumlException {
        for ( ClassRelationship classrelationship : this ) classrelationship.setForm_package( ref_form_package );
    }
    @Override
    public void setPart_package( String ref_part_package ) throws XtumlException {
        for ( ClassRelationship classrelationship : this ) classrelationship.setPart_package( ref_part_package );
    }
    @Override
    public void setForm_mult( Mult m_form_mult ) throws XtumlException {
        for ( ClassRelationship classrelationship : this ) classrelationship.setForm_mult( m_form_mult );
    }
    @Override
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        for ( ClassRelationship classrelationship : this ) classrelationship.setComp_name( ref_comp_name );
    }
    @Override
    public void setPart_name( String ref_part_name ) throws XtumlException {
        for ( ClassRelationship classrelationship : this ) classrelationship.setPart_name( ref_part_name );
    }
    @Override
    public void setName( String m_name ) throws XtumlException {
        for ( ClassRelationship classrelationship : this ) classrelationship.setName( m_name );
    }
    @Override
    public void setPart_mult( Mult m_part_mult ) throws XtumlException {
        for ( ClassRelationship classrelationship : this ) classrelationship.setPart_mult( m_part_mult );
    }
    @Override
    public void setPeer_comp_name( String ref_peer_comp_name ) throws XtumlException {
        for ( ClassRelationship classrelationship : this ) classrelationship.setPeer_comp_name( ref_peer_comp_name );
    }
    @Override
    public void setPeer_name( String ref_peer_name ) throws XtumlException {
        for ( ClassRelationship classrelationship : this ) classrelationship.setPeer_name( ref_peer_name );
    }
    @Override
    public void setNum( int m_num ) throws XtumlException {
        for ( ClassRelationship classrelationship : this ) classrelationship.setNum( m_num );
    }
    @Override
    public void setPeer_package( String ref_peer_package ) throws XtumlException {
        for ( ClassRelationship classrelationship : this ) classrelationship.setPeer_package( ref_peer_package );
    }
    @Override
    public void setId_num( int m_id_num ) throws XtumlException {
        for ( ClassRelationship classrelationship : this ) classrelationship.setId_num( m_id_num );
    }
    @Override
    public void setPart_cond( Cond m_part_cond ) throws XtumlException {
        for ( ClassRelationship classrelationship : this ) classrelationship.setPart_cond( m_part_cond );
    }
    @Override
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        for ( ClassRelationship classrelationship : this ) classrelationship.setComp_package( ref_comp_package );
    }
    @Override
    public void setPart_phrase( String m_part_phrase ) throws XtumlException {
        for ( ClassRelationship classrelationship : this ) classrelationship.setPart_phrase( m_part_phrase );
    }
    @Override
    public void setForm_name( String ref_form_name ) throws XtumlException {
        for ( ClassRelationship classrelationship : this ) classrelationship.setForm_name( ref_form_name );
    }
    @Override
    public void setRel_type( RelationshipType m_rel_type ) throws XtumlException {
        for ( ClassRelationship classrelationship : this ) classrelationship.setRel_type( m_rel_type );
    }


    // selections
    @Override
    public ModelInstSet R434_has_participating_ModelInst() throws XtumlException {
        ModelInstSet modelinstset = new ModelInstSetImpl();
        for ( ClassRelationship classrelationship : this ) modelinstset.add( classrelationship.R434_has_participating_ModelInst() );
        return modelinstset;
    }
    @Override
    public ModelInstSet R435_has_formalizing_ModelInst() throws XtumlException {
        ModelInstSet modelinstset = new ModelInstSetImpl();
        for ( ClassRelationship classrelationship : this ) modelinstset.add( classrelationship.R435_has_formalizing_ModelInst() );
        return modelinstset;
    }
    @Override
    public ClassRelationshipSet R436_is_one_half_of_associative_ClassRelationship() throws XtumlException {
        ClassRelationshipSet classrelationshipset = new ClassRelationshipSetImpl();
        for ( ClassRelationship classrelationship : this ) classrelationshipset.add( classrelationship.R436_is_one_half_of_associative_ClassRelationship() );
        return classrelationshipset;
    }
    @Override
    public ClassRelationshipSet R436_is_other_half_of_associative_ClassRelationship() throws XtumlException {
        ClassRelationshipSet classrelationshipset = new ClassRelationshipSetImpl();
        for ( ClassRelationship classrelationship : this ) classrelationshipset.add( classrelationship.R436_is_other_half_of_associative_ClassRelationship() );
        return classrelationshipset;
    }
    @Override
    public ComponentDefinitionSet R448_forms_relationship_population_of_ComponentDefinition() throws XtumlException {
        ComponentDefinitionSet componentdefinitionset = new ComponentDefinitionSetImpl();
        for ( ClassRelationship classrelationship : this ) componentdefinitionset.add( classrelationship.R448_forms_relationship_population_of_ComponentDefinition() );
        return componentdefinitionset;
    }
    @Override
    public AttributeReferenceSet R4511_provides_link_for_AttributeReference() throws XtumlException {
        AttributeReferenceSet attributereferenceset = new AttributeReferenceSetImpl();
        for ( ClassRelationship classrelationship : this ) attributereferenceset.addAll( classrelationship.R4511_provides_link_for_AttributeReference() );
        return attributereferenceset;
    }
    @Override
    public SelectorSet R4512_traversed_by_Selector() throws XtumlException {
        SelectorSet selectorset = new SelectorSetImpl();
        for ( ClassRelationship classrelationship : this ) selectorset.addAll( classrelationship.R4512_traversed_by_Selector() );
        return selectorset;
    }
    @Override
    public RelationshipPopulationSelectorSet R4572_extent_accessed_by_RelationshipPopulationSelector() throws XtumlException {
        RelationshipPopulationSelectorSet relationshippopulationselectorset = new RelationshipPopulationSelectorSetImpl();
        for ( ClassRelationship classrelationship : this ) relationshippopulationselectorset.add( classrelationship.R4572_extent_accessed_by_RelationshipPopulationSelector() );
        return relationshippopulationselectorset;
    }
    @Override
    public RelateSmtSet R481_created_by_RelateSmt() throws XtumlException {
        RelateSmtSet relatesmtset = new RelateSmtSetImpl();
        for ( ClassRelationship classrelationship : this ) relatesmtset.addAll( classrelationship.R481_created_by_RelateSmt() );
        return relatesmtset;
    }
    @Override
    public UnrelateSmtSet R484_deleted_by_UnrelateSmt() throws XtumlException {
        UnrelateSmtSet unrelatesmtset = new UnrelateSmtSetImpl();
        for ( ClassRelationship classrelationship : this ) unrelatesmtset.addAll( classrelationship.R484_deleted_by_UnrelateSmt() );
        return unrelatesmtset;
    }


    @Override
    public ClassRelationship nullElement() {
        return ClassRelationshipImpl.EMPTY_CLASSRELATIONSHIP;
    }

    @Override
    public ClassRelationshipSet emptySet() {
      return new ClassRelationshipSetImpl();
    }

    @Override
    public ClassRelationshipSet emptySet(Comparator<? super ClassRelationship> comp) {
      return new ClassRelationshipSetImpl(comp);
    }

    @Override
    public List<ClassRelationship> elements() {
        ClassRelationship[] elements = toArray(new ClassRelationship[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
