package io.ciera.tool.sql.architecture.classes.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.classes.Attribute;
import io.ciera.tool.sql.architecture.classes.AttributeAccessor;
import io.ciera.tool.sql.architecture.classes.AttributeDerivation;
import io.ciera.tool.sql.architecture.classes.AttributeReference;
import io.ciera.tool.sql.architecture.classes.AttributeReferenceSet;
import io.ciera.tool.sql.architecture.classes.ModelInst;
import io.ciera.tool.sql.architecture.classes.impl.AttributeDerivationImpl;
import io.ciera.tool.sql.architecture.classes.impl.AttributeImpl;
import io.ciera.tool.sql.architecture.type.ArrayTypeReference;
import io.ciera.tool.sql.architecture.type.Type;

import java.util.Iterator;

import types.AttributeAccessorType;


public class AttributeAccessorImpl extends ModelInstance<AttributeAccessor,Sql> implements AttributeAccessor {

    public static final String KEY_LETTERS = "AttributeAccessor";
    public static final AttributeAccessor EMPTY_ATTRIBUTEACCESSOR = new EmptyAttributeAccessor();

    private Sql context;

    // constructors
    private AttributeAccessorImpl( Sql context ) {
        this.context = context;
        ref_attribute_name = "";
        ref_class_package = "";
        ref_class_name = "";
        m_accessor_type = AttributeAccessorType.UNINITIALIZED_ENUM;
        R441_value_derived_by_AttributeDerivation_inst = AttributeDerivationImpl.EMPTY_ATTRIBUTEDERIVATION;
        R4510_gets_and_sets_Attribute_inst = AttributeImpl.EMPTY_ATTRIBUTE;
    }

    private AttributeAccessorImpl( Sql context, UniqueId instanceId, String ref_attribute_name, String ref_class_package, String ref_class_name, AttributeAccessorType m_accessor_type ) {
        super(instanceId);
        this.context = context;
        this.ref_attribute_name = ref_attribute_name;
        this.ref_class_package = ref_class_package;
        this.ref_class_name = ref_class_name;
        this.m_accessor_type = m_accessor_type;
        R441_value_derived_by_AttributeDerivation_inst = AttributeDerivationImpl.EMPTY_ATTRIBUTEDERIVATION;
        R4510_gets_and_sets_Attribute_inst = AttributeImpl.EMPTY_ATTRIBUTE;
    }

    public static AttributeAccessor create( Sql context ) throws XtumlException {
        AttributeAccessor newAttributeAccessor = new AttributeAccessorImpl( context );
        if ( context.addInstance( newAttributeAccessor ) ) {
            newAttributeAccessor.getRunContext().addChange(new InstanceCreatedDelta(newAttributeAccessor, KEY_LETTERS));
            return newAttributeAccessor;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static AttributeAccessor create( Sql context, String ref_attribute_name, String ref_class_package, String ref_class_name, AttributeAccessorType m_accessor_type ) throws XtumlException {
        return create(context, UniqueId.random(), ref_attribute_name, ref_class_package, ref_class_name, m_accessor_type);
    }

    public static AttributeAccessor create( Sql context, UniqueId instanceId, String ref_attribute_name, String ref_class_package, String ref_class_name, AttributeAccessorType m_accessor_type ) throws XtumlException {
        AttributeAccessor newAttributeAccessor = new AttributeAccessorImpl( context, instanceId, ref_attribute_name, ref_class_package, ref_class_name, m_accessor_type );
        if ( context.addInstance( newAttributeAccessor ) ) {
            return newAttributeAccessor;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_attribute_name;
    @Override
    public void setAttribute_name(String ref_attribute_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_attribute_name, this.ref_attribute_name)) {
            final String oldValue = this.ref_attribute_name;
            this.ref_attribute_name = ref_attribute_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_attribute_name", oldValue, this.ref_attribute_name));
            if ( !R441_value_derived_by_AttributeDerivation().isEmpty() ) R441_value_derived_by_AttributeDerivation().setAttribute_name( ref_attribute_name );
        }
    }
    @Override
    public String getAttribute_name() throws XtumlException {
        checkLiving();
        return ref_attribute_name;
    }
    private String ref_class_package;
    @Override
    public String getClass_package() throws XtumlException {
        checkLiving();
        return ref_class_package;
    }
    @Override
    public void setClass_package(String ref_class_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_class_package, this.ref_class_package)) {
            final String oldValue = this.ref_class_package;
            this.ref_class_package = ref_class_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_package", oldValue, this.ref_class_package));
            if ( !R441_value_derived_by_AttributeDerivation().isEmpty() ) R441_value_derived_by_AttributeDerivation().setClass_package( ref_class_package );
        }
    }
    private String ref_class_name;
    @Override
    public void setClass_name(String ref_class_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_class_name, this.ref_class_name)) {
            final String oldValue = this.ref_class_name;
            this.ref_class_name = ref_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_name", oldValue, this.ref_class_name));
            if ( !R441_value_derived_by_AttributeDerivation().isEmpty() ) R441_value_derived_by_AttributeDerivation().setClass_name( ref_class_name );
        }
    }
    @Override
    public String getClass_name() throws XtumlException {
        checkLiving();
        return ref_class_name;
    }
    private AttributeAccessorType m_accessor_type;
    @Override
    public AttributeAccessorType getAccessor_type() throws XtumlException {
        checkLiving();
        return m_accessor_type;
    }
    @Override
    public void setAccessor_type(AttributeAccessorType m_accessor_type) throws XtumlException {
        checkLiving();
        if (m_accessor_type.inequality( this.m_accessor_type)) {
            final AttributeAccessorType oldValue = this.m_accessor_type;
            this.m_accessor_type = m_accessor_type;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_accessor_type", oldValue, this.m_accessor_type));
            if ( !R441_value_derived_by_AttributeDerivation().isEmpty() ) R441_value_derived_by_AttributeDerivation().setAccessor_type( m_accessor_type );
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getAttribute_name(), getClass_package(), getClass_name(), getAccessor_type());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public String getName() throws XtumlException {
        Attribute attribute = self().R4510_gets_and_sets_Attribute();
        String first_letter = context().T().sub( "c", context().STRING().substr( attribute.getBase_name(), 0, 1 ) );
        String the_rest = context().STRING().substr( attribute.getBase_name(), 1, -1 );
        String capital_name = first_letter + the_rest;
        if ( AttributeAccessorType.GETTER.equality(self().getAccessor_type()) ) {
            return "get" + capital_name;
        }
        else {
            return "set" + capital_name;
        }
    }

    @Override
    public void render() throws XtumlException {
        Attribute attribute = self().R4510_gets_and_sets_Attribute();
        String type_name = attribute.getType_reference_name();
        String name = self().getName();
        context().T().push_buffer();
        String attribute_derivation = "";
        AttributeDerivation attr_deriv = self().R441_value_derived_by_AttributeDerivation();
        if ( !attr_deriv.isEmpty() ) {
            attr_deriv.render();
            attribute_derivation = context().T().body();
            context().T().clear();
        }
        Type type = self().R4510_gets_and_sets_Attribute().R424_is_typed_by_TypeReference().R3800_based_on_Type();
        ArrayTypeReference array_type = self().R4510_gets_and_sets_Attribute().R424_is_typed_by_TypeReference().R3801_is_a_ArrayTypeReference();
        boolean is_array = !array_type.isEmpty();
        boolean primitive = type.primitive();
        boolean is_string = StringUtil.equality("String", type_name);
        boolean is_getter = self().getAccessor_type().equality(AttributeAccessorType.GETTER);
        String propagations = "";
        if ( !is_getter ) {
            AttributeReferenceSet refs = self().R4510_gets_and_sets_Attribute().R4506_provides_value_for_AttributeReference();
            AttributeReference ref;
            for ( Iterator<AttributeReference> _ref_iter = refs.elements().iterator(); _ref_iter.hasNext(); ) {
                ref = _ref_iter.next();
                String attribute_name = ref.getReferred_to_attribute_name();
                AttributeAccessor accessor = ref.R4506_provides_value_for_Attribute().R4510_value_accessed_through_AttributeAccessor().anyWhere(selected -> ((AttributeAccessor)selected).getAccessor_type().equality(AttributeAccessorType.SETTER));
                String accessor_name = accessor.getName();
                String selector_name = ( "R" + context().STRING().itoa( ref.getRel_num() ) ) + "_";
                if ( StringUtil.inequality("", ref.getForm_phrase()) ) {
                    selector_name = ( selector_name + context().T().sub( "_", ref.getForm_phrase() ) ) + "_";
                }
                selector_name = selector_name + ref.getReferring_attribute_class_name();
                context().T().include( "class/t.attributepropagation.java", accessor_name, attribute_name, selector_name );
            }
            propagations = context().T().body();
            context().T().clear();
        }
        context().T().pop_buffer();
        ModelInst obj = attribute.R410_abstracts_data_for_ModelInst();
        if ( obj.getUnmanaged() ) {
            context().T().include( "class/t.attributeaccessor.unmanaged.java", is_getter, name, self(), type_name );
        }
        else {
            context().T().include( "class/t.attributeaccessor.java", attribute_derivation, is_array, is_getter, is_string, name, primitive, propagations, self(), type_name );
        }
    }

    @Override
    public void render_empty() throws XtumlException {
        Attribute attribute = self().R4510_gets_and_sets_Attribute();
        String type_name = attribute.getType_reference_name();
        String name = self().getName();
        boolean is_getter = self().getAccessor_type().equality(AttributeAccessorType.GETTER);
        context().T().include( "class/t.attributeaccessor.empty.java", is_getter, name, self(), type_name );
    }

    @Override
    public void render_interface() throws XtumlException {
        Attribute attribute = self().R4510_gets_and_sets_Attribute();
        String type_name = attribute.getType_reference_name();
        String name = self().getName();
        boolean is_getter = self().getAccessor_type().equality(AttributeAccessorType.GETTER);
        context().T().include( "class/t.attributeaccessor.int.java", is_getter, name, self(), type_name );
    }

    @Override
    public void render_set() throws XtumlException {
        Attribute attribute = self().R4510_gets_and_sets_Attribute();
        String type_name = attribute.getType_reference_name();
        String name = self().getName();
        boolean is_getter = self().getAccessor_type().equality(AttributeAccessorType.GETTER);
        context().T().include( "class/t.attributeaccessor.set.java", is_getter, name, self(), type_name );
    }



    // static operations


    // events


    // selections
    private AttributeDerivation R441_value_derived_by_AttributeDerivation_inst;
    @Override
    public void setR441_value_derived_by_AttributeDerivation( AttributeDerivation inst ) {
        R441_value_derived_by_AttributeDerivation_inst = inst;
    }
    @Override
    public AttributeDerivation R441_value_derived_by_AttributeDerivation() throws XtumlException {
        return R441_value_derived_by_AttributeDerivation_inst;
    }
    private Attribute R4510_gets_and_sets_Attribute_inst;
    @Override
    public void setR4510_gets_and_sets_Attribute( Attribute inst ) {
        R4510_gets_and_sets_Attribute_inst = inst;
    }
    @Override
    public Attribute R4510_gets_and_sets_Attribute() throws XtumlException {
        return R4510_gets_and_sets_Attribute_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public AttributeAccessor self() {
        return this;
    }

    @Override
    public AttributeAccessor oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_ATTRIBUTEACCESSOR;
    }

}

class EmptyAttributeAccessor extends ModelInstance<AttributeAccessor,Sql> implements AttributeAccessor {

    // attributes
    public void setAttribute_name( String ref_attribute_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getAttribute_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getClass_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setClass_package( String ref_class_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setClass_name( String ref_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getClass_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public AttributeAccessorType getAccessor_type() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAccessor_type( AttributeAccessorType m_accessor_type ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_empty() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_interface() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_set() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public AttributeDerivation R441_value_derived_by_AttributeDerivation() {
        return AttributeDerivationImpl.EMPTY_ATTRIBUTEDERIVATION;
    }
    @Override
    public Attribute R4510_gets_and_sets_Attribute() {
        return AttributeImpl.EMPTY_ATTRIBUTE;
    }


    @Override
    public String getKeyLetters() {
        return AttributeAccessorImpl.KEY_LETTERS;
    }

    @Override
    public AttributeAccessor self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public AttributeAccessor oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return AttributeAccessorImpl.EMPTY_ATTRIBUTEACCESSOR;
    }

}
