package io.ciera.tool.sql.architecture.application.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.application.Application;
import io.ciera.tool.sql.architecture.application.ApplicationExecutor;
import io.ciera.tool.sql.architecture.application.ComponentInstantiation;
import io.ciera.tool.sql.architecture.application.ComponentInstantiationSet;
import io.ciera.tool.sql.architecture.application.impl.ApplicationImpl;
import io.ciera.tool.sql.architecture.application.impl.ComponentInstantiationSetImpl;


public class ApplicationExecutorImpl extends ModelInstance<ApplicationExecutor,Sql> implements ApplicationExecutor {

    public static final String KEY_LETTERS = "ApplicationExecutor";
    public static final ApplicationExecutor EMPTY_APPLICATIONEXECUTOR = new EmptyApplicationExecutor();

    private Sql context;

    // constructors
    private ApplicationExecutorImpl( Sql context ) {
        this.context = context;
        ref_app_name = "";
        ref_app_package = "";
        m_index = 0;
        R4027_executes_tasks_for_Application_inst = ApplicationImpl.EMPTY_APPLICATION;
        R4028_provides_execution_context_for_ComponentInstantiation_set = new ComponentInstantiationSetImpl();
    }

    private ApplicationExecutorImpl( Sql context, UniqueId instanceId, String ref_app_name, String ref_app_package, int m_index ) {
        super(instanceId);
        this.context = context;
        this.ref_app_name = ref_app_name;
        this.ref_app_package = ref_app_package;
        this.m_index = m_index;
        R4027_executes_tasks_for_Application_inst = ApplicationImpl.EMPTY_APPLICATION;
        R4028_provides_execution_context_for_ComponentInstantiation_set = new ComponentInstantiationSetImpl();
    }

    public static ApplicationExecutor create( Sql context ) throws XtumlException {
        ApplicationExecutor newApplicationExecutor = new ApplicationExecutorImpl( context );
        if ( context.addInstance( newApplicationExecutor ) ) {
            newApplicationExecutor.getRunContext().addChange(new InstanceCreatedDelta(newApplicationExecutor, KEY_LETTERS));
            return newApplicationExecutor;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ApplicationExecutor create( Sql context, String ref_app_name, String ref_app_package, int m_index ) throws XtumlException {
        return create(context, UniqueId.random(), ref_app_name, ref_app_package, m_index);
    }

    public static ApplicationExecutor create( Sql context, UniqueId instanceId, String ref_app_name, String ref_app_package, int m_index ) throws XtumlException {
        ApplicationExecutor newApplicationExecutor = new ApplicationExecutorImpl( context, instanceId, ref_app_name, ref_app_package, m_index );
        if ( context.addInstance( newApplicationExecutor ) ) {
            return newApplicationExecutor;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_app_name;
    @Override
    public String getApp_name() throws XtumlException {
        checkLiving();
        return ref_app_name;
    }
    @Override
    public void setApp_name(String ref_app_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_app_name, this.ref_app_name)) {
            final String oldValue = this.ref_app_name;
            this.ref_app_name = ref_app_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_app_name", oldValue, this.ref_app_name));
            if ( !R4028_provides_execution_context_for_ComponentInstantiation().isEmpty() ) R4028_provides_execution_context_for_ComponentInstantiation().setApp_name( ref_app_name );
        }
    }
    private String ref_app_package;
    @Override
    public String getApp_package() throws XtumlException {
        checkLiving();
        return ref_app_package;
    }
    @Override
    public void setApp_package(String ref_app_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_app_package, this.ref_app_package)) {
            final String oldValue = this.ref_app_package;
            this.ref_app_package = ref_app_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_app_package", oldValue, this.ref_app_package));
            if ( !R4028_provides_execution_context_for_ComponentInstantiation().isEmpty() ) R4028_provides_execution_context_for_ComponentInstantiation().setApp_package( ref_app_package );
        }
    }
    private int m_index;
    @Override
    public int getIndex() throws XtumlException {
        checkLiving();
        return m_index;
    }
    @Override
    public void setIndex(int m_index) throws XtumlException {
        checkLiving();
        if (m_index != this.m_index) {
            final int oldValue = this.m_index;
            this.m_index = m_index;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_index", oldValue, this.m_index));
            if ( !R4028_provides_execution_context_for_ComponentInstantiation().isEmpty() ) R4028_provides_execution_context_for_ComponentInstantiation().setExecutor_index( m_index );
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getApp_name(), getApp_package(), getIndex());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Application R4027_executes_tasks_for_Application_inst;
    @Override
    public void setR4027_executes_tasks_for_Application( Application inst ) {
        R4027_executes_tasks_for_Application_inst = inst;
    }
    @Override
    public Application R4027_executes_tasks_for_Application() throws XtumlException {
        return R4027_executes_tasks_for_Application_inst;
    }
    private ComponentInstantiationSet R4028_provides_execution_context_for_ComponentInstantiation_set;
    @Override
    public void addR4028_provides_execution_context_for_ComponentInstantiation( ComponentInstantiation inst ) {
        R4028_provides_execution_context_for_ComponentInstantiation_set.add(inst);
    }
    @Override
    public void removeR4028_provides_execution_context_for_ComponentInstantiation( ComponentInstantiation inst ) {
        R4028_provides_execution_context_for_ComponentInstantiation_set.remove(inst);
    }
    @Override
    public ComponentInstantiationSet R4028_provides_execution_context_for_ComponentInstantiation() throws XtumlException {
        return R4028_provides_execution_context_for_ComponentInstantiation_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ApplicationExecutor self() {
        return this;
    }

    @Override
    public ApplicationExecutor oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_APPLICATIONEXECUTOR;
    }

}

class EmptyApplicationExecutor extends ModelInstance<ApplicationExecutor,Sql> implements ApplicationExecutor {

    // attributes
    public String getApp_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setApp_name( String ref_app_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getApp_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setApp_package( String ref_app_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getIndex() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIndex( int m_index ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Application R4027_executes_tasks_for_Application() {
        return ApplicationImpl.EMPTY_APPLICATION;
    }
    @Override
    public ComponentInstantiationSet R4028_provides_execution_context_for_ComponentInstantiation() {
        return (new ComponentInstantiationSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return ApplicationExecutorImpl.KEY_LETTERS;
    }

    @Override
    public ApplicationExecutor self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ApplicationExecutor oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ApplicationExecutorImpl.EMPTY_APPLICATIONEXECUTOR;
    }

}
