package types;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


public enum Cond implements IXtumlType {

    UNINITIALIZED_ENUM( -1 ),
    CONDITIONAL( 1 ),
    UNCONDITIONAL( 0 );

    private final int value;

    Cond() {
        value = -1;
    }

    Cond( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( IXtumlType value ) throws XtumlException {
        if (value instanceof Cond) {
            return null != value && this.value == ((Cond)value).getValue();
        }
        else return false;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static Cond deserialize(Object o) throws XtumlException {
        if (o instanceof Cond) {
            return (Cond)o;
        }
        else if (o instanceof Integer) {
            return valueOf((int)o);
        }
        else if (o instanceof String) {
            try {
                return valueOf(Integer.parseInt((String)o));
            }
            catch (NumberFormatException e1) {
                Matcher m = Pattern.compile("([A-Za-z][A-Za-z0-9_]*)::([A-Za-z][A-Za-z0-9_]*)").matcher((String)o);
                if (m.matches() && "cond".equals(m.group(1).toLowerCase())) {
                    try {
                        return Enum.valueOf(Cond.class, m.group(2).toUpperCase());
                    } catch (IllegalArgumentException e2) {/* do nothing */}
                }
            }
        }
        throw new XtumlException("Cannot deserialize value: " + o != null ? o.toString() : "null");
    }

    public static Cond valueOf(int value) {
        switch( value ) {
        case 1:
            return CONDITIONAL;
        case 0:
            return UNCONDITIONAL;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
