package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


public enum StateChangeType implements IXtumlType {

    UNINITIALIZED_ENUM( -1 ),
    ENTRY( 0 ),
    EXIT( 1 );

    private final int value;

    StateChangeType() {
        value = -1;
    }

    StateChangeType( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( IXtumlType value ) throws XtumlException {
        if (value instanceof StateChangeType) {
            return null != value && this.value == ((StateChangeType)value).getValue();
        }
        else return false;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static StateChangeType deserialize(Object o) throws XtumlException {
        if (o instanceof StateChangeType) {
            return (StateChangeType)o;
        }
        else if (o instanceof Integer) {
            return valueOf((int)o);
        }
        else if (o instanceof String) {
            try {
                return valueOf(Integer.parseInt((String)o));
            }
            catch (NumberFormatException e1) {
                Matcher m = Pattern.compile("([A-Za-z][A-Za-z0-9_]*)::([A-Za-z][A-Za-z0-9_]*)").matcher((String)o);
                if (m.matches() && "statechangetype".equals(m.group(1).toLowerCase())) {
                    try {
                        return Enum.valueOf(StateChangeType.class, m.group(2).toUpperCase());
                    } catch (IllegalArgumentException e2) {/* do nothing */}
                }
            }
        }
        throw new XtumlException("Cannot deserialize value: " + o != null ? o.toString() : "null");
    }

    public static StateChangeType valueOf(int value) {
        switch( value ) {
        case 0:
            return ENTRY;
        case 1:
            return EXIT;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
