package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


public enum Multiplicity implements IXtumlType {

    UNINITIALIZED_ENUM( -1 ),
    MANY( 0 ),
    ONE( 1 ),
    UNKNOWN( 2 );

    private final int value;

    Multiplicity() {
        value = -1;
    }

    Multiplicity( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( IXtumlType value ) throws XtumlException {
        if (value instanceof Multiplicity) {
            return null != value && this.value == ((Multiplicity)value).getValue();
        }
        else return false;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static Multiplicity deserialize(Object o) throws XtumlException {
        if (o instanceof Multiplicity) {
            return (Multiplicity)o;
        }
        else if (o instanceof Integer) {
            return valueOf((int)o);
        }
        else if (o instanceof String) {
            try {
                return valueOf(Integer.parseInt((String)o));
            }
            catch (NumberFormatException e1) {
                Matcher m = Pattern.compile("([A-Za-z][A-Za-z0-9_]*)::([A-Za-z][A-Za-z0-9_]*)").matcher((String)o);
                if (m.matches() && "multiplicity".equals(m.group(1).toLowerCase())) {
                    try {
                        return Enum.valueOf(Multiplicity.class, m.group(2).toUpperCase());
                    } catch (IllegalArgumentException e2) {/* do nothing */}
                }
            }
        }
        throw new XtumlException("Cannot deserialize value: " + o != null ? o.toString() : "null");
    }

    public static Multiplicity valueOf(int value) {
        switch( value ) {
        case 0:
            return MANY;
        case 1:
            return ONE;
        case 2:
            return UNKNOWN;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
