package io.ciera.tool.sql.ooaofooa.value.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.value.V_UNY;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class V_UNYImpl extends ModelInstance<V_UNY,Sql> implements V_UNY {

    public static final String KEY_LETTERS = "V_UNY";
    public static final V_UNY EMPTY_V_UNY = new EmptyV_UNY();

    private Sql context;

    // constructors
    private V_UNYImpl( Sql context ) {
        this.context = context;
        ref_Value_ID = UniqueId.random();
        ref_Operand_Value_ID = UniqueId.random();
        m_Operator = "";
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R804_has_operand_Value_inst = ValueImpl.EMPTY_VALUE;
    }

    private V_UNYImpl( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_Operand_Value_ID, String m_Operator ) {
        super(instanceId);
        this.context = context;
        this.ref_Value_ID = ref_Value_ID;
        this.ref_Operand_Value_ID = ref_Operand_Value_ID;
        this.m_Operator = m_Operator;
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R804_has_operand_Value_inst = ValueImpl.EMPTY_VALUE;
    }

    public static V_UNY create( Sql context ) throws XtumlException {
        V_UNY newV_UNY = new V_UNYImpl( context );
        if ( context.addInstance( newV_UNY ) ) {
            newV_UNY.getRunContext().addChange(new InstanceCreatedDelta(newV_UNY, KEY_LETTERS));
            return newV_UNY;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static V_UNY create( Sql context, UniqueId ref_Value_ID, UniqueId ref_Operand_Value_ID, String m_Operator ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Value_ID, ref_Operand_Value_ID, m_Operator);
    }

    public static V_UNY create( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_Operand_Value_ID, String m_Operator ) throws XtumlException {
        V_UNY newV_UNY = new V_UNYImpl( context, instanceId, ref_Value_ID, ref_Operand_Value_ID, m_Operator );
        if ( context.addInstance( newV_UNY ) ) {
            return newV_UNY;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Value_ID;
    @Override
    public UniqueId getValue_ID() throws XtumlException {
        checkLiving();
        return ref_Value_ID;
    }
    @Override
    public void setValue_ID(UniqueId ref_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Value_ID.inequality( this.ref_Value_ID)) {
            final UniqueId oldValue = this.ref_Value_ID;
            this.ref_Value_ID = ref_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Value_ID", oldValue, this.ref_Value_ID));
        }
    }
    private UniqueId ref_Operand_Value_ID;
    @Override
    public void setOperand_Value_ID(UniqueId ref_Operand_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Operand_Value_ID.inequality( this.ref_Operand_Value_ID)) {
            final UniqueId oldValue = this.ref_Operand_Value_ID;
            this.ref_Operand_Value_ID = ref_Operand_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Operand_Value_ID", oldValue, this.ref_Operand_Value_ID));
        }
    }
    @Override
    public UniqueId getOperand_Value_ID() throws XtumlException {
        checkLiving();
        return ref_Operand_Value_ID;
    }
    private String m_Operator;
    @Override
    public void setOperator(String m_Operator) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Operator, this.m_Operator)) {
            final String oldValue = this.m_Operator;
            this.m_Operator = m_Operator;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Operator", oldValue, this.m_Operator));
        }
    }
    @Override
    public String getOperator() throws XtumlException {
        checkLiving();
        return m_Operator;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getValue_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Value R801_is_a_Value_inst;
    @Override
    public void setR801_is_a_Value( Value inst ) {
        R801_is_a_Value_inst = inst;
    }
    @Override
    public Value R801_is_a_Value() throws XtumlException {
        return R801_is_a_Value_inst;
    }
    private Value R804_has_operand_Value_inst;
    @Override
    public void setR804_has_operand_Value( Value inst ) {
        R804_has_operand_Value_inst = inst;
    }
    @Override
    public Value R804_has_operand_Value() throws XtumlException {
        return R804_has_operand_Value_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public V_UNY self() {
        return this;
    }

    @Override
    public V_UNY oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_V_UNY;
    }

}

class EmptyV_UNY extends ModelInstance<V_UNY,Sql> implements V_UNY {

    // attributes
    public UniqueId getValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setOperand_Value_ID( UniqueId ref_Operand_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getOperand_Value_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setOperator( String m_Operator ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getOperator() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Value R801_is_a_Value() {
        return ValueImpl.EMPTY_VALUE;
    }
    @Override
    public Value R804_has_operand_Value() {
        return ValueImpl.EMPTY_VALUE;
    }


    @Override
    public String getKeyLetters() {
        return V_UNYImpl.KEY_LETTERS;
    }

    @Override
    public V_UNY self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public V_UNY oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return V_UNYImpl.EMPTY_V_UNY;
    }

}
