package io.ciera.tool.sql.ooaofooa.value.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.subsystem.O_TFR;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.O_TFRImpl;
import io.ciera.tool.sql.ooaofooa.value.OperationValue;
import io.ciera.tool.sql.ooaofooa.value.SelectedReference;
import io.ciera.tool.sql.ooaofooa.value.V_PAR;
import io.ciera.tool.sql.ooaofooa.value.V_PARSet;
import io.ciera.tool.sql.ooaofooa.value.V_VAR;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.SelectedReferenceImpl;
import io.ciera.tool.sql.ooaofooa.value.impl.V_PARSetImpl;
import io.ciera.tool.sql.ooaofooa.value.impl.V_VARImpl;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class OperationValueImpl extends ModelInstance<OperationValue,Sql> implements OperationValue {

    public static final String KEY_LETTERS = "V_TRV";
    public static final OperationValue EMPTY_OPERATIONVALUE = new EmptyOperationValue();

    private Sql context;

    // constructors
    private OperationValueImpl( Sql context ) {
        this.context = context;
        ref_Value_ID = UniqueId.random();
        ref_Tfr_ID = UniqueId.random();
        ref_Var_ID = UniqueId.random();
        m_ParmListOK = false;
        m_modelClassKeyLettersLineNumber = 0;
        m_modelClassKeyLettersColumn = 0;
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R811_has_V_PAR_set = new V_PARSetImpl();
        R825_SelectedReference_inst = SelectedReferenceImpl.EMPTY_SELECTEDREFERENCE;
        R829_O_TFR_inst = O_TFRImpl.EMPTY_O_TFR;
        R830_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
    }

    private OperationValueImpl( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_Tfr_ID, UniqueId ref_Var_ID, boolean m_ParmListOK, int m_modelClassKeyLettersLineNumber, int m_modelClassKeyLettersColumn ) {
        super(instanceId);
        this.context = context;
        this.ref_Value_ID = ref_Value_ID;
        this.ref_Tfr_ID = ref_Tfr_ID;
        this.ref_Var_ID = ref_Var_ID;
        this.m_ParmListOK = m_ParmListOK;
        this.m_modelClassKeyLettersLineNumber = m_modelClassKeyLettersLineNumber;
        this.m_modelClassKeyLettersColumn = m_modelClassKeyLettersColumn;
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R811_has_V_PAR_set = new V_PARSetImpl();
        R825_SelectedReference_inst = SelectedReferenceImpl.EMPTY_SELECTEDREFERENCE;
        R829_O_TFR_inst = O_TFRImpl.EMPTY_O_TFR;
        R830_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
    }

    public static OperationValue create( Sql context ) throws XtumlException {
        OperationValue newOperationValue = new OperationValueImpl( context );
        if ( context.addInstance( newOperationValue ) ) {
            newOperationValue.getRunContext().addChange(new InstanceCreatedDelta(newOperationValue, KEY_LETTERS));
            return newOperationValue;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static OperationValue create( Sql context, UniqueId ref_Value_ID, UniqueId ref_Tfr_ID, UniqueId ref_Var_ID, boolean m_ParmListOK, int m_modelClassKeyLettersLineNumber, int m_modelClassKeyLettersColumn ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Value_ID, ref_Tfr_ID, ref_Var_ID, m_ParmListOK, m_modelClassKeyLettersLineNumber, m_modelClassKeyLettersColumn);
    }

    public static OperationValue create( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_Tfr_ID, UniqueId ref_Var_ID, boolean m_ParmListOK, int m_modelClassKeyLettersLineNumber, int m_modelClassKeyLettersColumn ) throws XtumlException {
        OperationValue newOperationValue = new OperationValueImpl( context, instanceId, ref_Value_ID, ref_Tfr_ID, ref_Var_ID, m_ParmListOK, m_modelClassKeyLettersLineNumber, m_modelClassKeyLettersColumn );
        if ( context.addInstance( newOperationValue ) ) {
            return newOperationValue;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Value_ID;
    @Override
    public UniqueId getValue_ID() throws XtumlException {
        checkLiving();
        return ref_Value_ID;
    }
    @Override
    public void setValue_ID(UniqueId ref_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Value_ID.inequality( this.ref_Value_ID)) {
            final UniqueId oldValue = this.ref_Value_ID;
            this.ref_Value_ID = ref_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Value_ID", oldValue, this.ref_Value_ID));
            if ( !R811_has_V_PAR().isEmpty() ) R811_has_V_PAR().setInvocation_Value_ID( ref_Value_ID );
            if ( !R825_SelectedReference().isEmpty() ) R825_SelectedReference().setOp_Value_ID( ref_Value_ID );
        }
    }
    private UniqueId ref_Tfr_ID;
    @Override
    public UniqueId getTfr_ID() throws XtumlException {
        checkLiving();
        return ref_Tfr_ID;
    }
    @Override
    public void setTfr_ID(UniqueId ref_Tfr_ID) throws XtumlException {
        checkLiving();
        if (ref_Tfr_ID.inequality( this.ref_Tfr_ID)) {
            final UniqueId oldValue = this.ref_Tfr_ID;
            this.ref_Tfr_ID = ref_Tfr_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Tfr_ID", oldValue, this.ref_Tfr_ID));
        }
    }
    private UniqueId ref_Var_ID;
    @Override
    public UniqueId getVar_ID() throws XtumlException {
        checkLiving();
        return ref_Var_ID;
    }
    @Override
    public void setVar_ID(UniqueId ref_Var_ID) throws XtumlException {
        checkLiving();
        if (ref_Var_ID.inequality( this.ref_Var_ID)) {
            final UniqueId oldValue = this.ref_Var_ID;
            this.ref_Var_ID = ref_Var_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Var_ID", oldValue, this.ref_Var_ID));
        }
    }
    private boolean m_ParmListOK;
    @Override
    public boolean getParmListOK() throws XtumlException {
        checkLiving();
        return m_ParmListOK;
    }
    @Override
    public void setParmListOK(boolean m_ParmListOK) throws XtumlException {
        checkLiving();
        if (m_ParmListOK != this.m_ParmListOK) {
            final boolean oldValue = this.m_ParmListOK;
            this.m_ParmListOK = m_ParmListOK;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_ParmListOK", oldValue, this.m_ParmListOK));
        }
    }
    private int m_modelClassKeyLettersLineNumber;
    @Override
    public void setModelClassKeyLettersLineNumber(int m_modelClassKeyLettersLineNumber) throws XtumlException {
        checkLiving();
        if (m_modelClassKeyLettersLineNumber != this.m_modelClassKeyLettersLineNumber) {
            final int oldValue = this.m_modelClassKeyLettersLineNumber;
            this.m_modelClassKeyLettersLineNumber = m_modelClassKeyLettersLineNumber;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_modelClassKeyLettersLineNumber", oldValue, this.m_modelClassKeyLettersLineNumber));
        }
    }
    @Override
    public int getModelClassKeyLettersLineNumber() throws XtumlException {
        checkLiving();
        return m_modelClassKeyLettersLineNumber;
    }
    private int m_modelClassKeyLettersColumn;
    @Override
    public void setModelClassKeyLettersColumn(int m_modelClassKeyLettersColumn) throws XtumlException {
        checkLiving();
        if (m_modelClassKeyLettersColumn != this.m_modelClassKeyLettersColumn) {
            final int oldValue = this.m_modelClassKeyLettersColumn;
            this.m_modelClassKeyLettersColumn = m_modelClassKeyLettersColumn;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_modelClassKeyLettersColumn", oldValue, this.m_modelClassKeyLettersColumn));
        }
    }
    @Override
    public int getModelClassKeyLettersColumn() throws XtumlException {
        checkLiving();
        return m_modelClassKeyLettersColumn;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getValue_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Value R801_is_a_Value_inst;
    @Override
    public void setR801_is_a_Value( Value inst ) {
        R801_is_a_Value_inst = inst;
    }
    @Override
    public Value R801_is_a_Value() throws XtumlException {
        return R801_is_a_Value_inst;
    }
    private V_PARSet R811_has_V_PAR_set;
    @Override
    public void addR811_has_V_PAR( V_PAR inst ) {
        R811_has_V_PAR_set.add(inst);
    }
    @Override
    public void removeR811_has_V_PAR( V_PAR inst ) {
        R811_has_V_PAR_set.remove(inst);
    }
    @Override
    public V_PARSet R811_has_V_PAR() throws XtumlException {
        return R811_has_V_PAR_set;
    }
    private SelectedReference R825_SelectedReference_inst;
    @Override
    public void setR825_SelectedReference( SelectedReference inst ) {
        R825_SelectedReference_inst = inst;
    }
    @Override
    public SelectedReference R825_SelectedReference() throws XtumlException {
        return R825_SelectedReference_inst;
    }
    private O_TFR R829_O_TFR_inst;
    @Override
    public void setR829_O_TFR( O_TFR inst ) {
        R829_O_TFR_inst = inst;
    }
    @Override
    public O_TFR R829_O_TFR() throws XtumlException {
        return R829_O_TFR_inst;
    }
    private V_VAR R830_V_VAR_inst;
    @Override
    public void setR830_V_VAR( V_VAR inst ) {
        R830_V_VAR_inst = inst;
    }
    @Override
    public V_VAR R830_V_VAR() throws XtumlException {
        return R830_V_VAR_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public OperationValue self() {
        return this;
    }

    @Override
    public OperationValue oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_OPERATIONVALUE;
    }

}

class EmptyOperationValue extends ModelInstance<OperationValue,Sql> implements OperationValue {

    // attributes
    public UniqueId getValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getTfr_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setTfr_ID( UniqueId ref_Tfr_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getVar_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setVar_ID( UniqueId ref_Var_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getParmListOK() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParmListOK( boolean m_ParmListOK ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setModelClassKeyLettersLineNumber( int m_modelClassKeyLettersLineNumber ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getModelClassKeyLettersLineNumber() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setModelClassKeyLettersColumn( int m_modelClassKeyLettersColumn ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getModelClassKeyLettersColumn() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Value R801_is_a_Value() {
        return ValueImpl.EMPTY_VALUE;
    }
    @Override
    public V_PARSet R811_has_V_PAR() {
        return (new V_PARSetImpl());
    }
    @Override
    public SelectedReference R825_SelectedReference() {
        return SelectedReferenceImpl.EMPTY_SELECTEDREFERENCE;
    }
    @Override
    public O_TFR R829_O_TFR() {
        return O_TFRImpl.EMPTY_O_TFR;
    }
    @Override
    public V_VAR R830_V_VAR() {
        return V_VARImpl.EMPTY_V_VAR;
    }


    @Override
    public String getKeyLetters() {
        return OperationValueImpl.KEY_LETTERS;
    }

    @Override
    public OperationValue self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public OperationValue oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return OperationValueImpl.EMPTY_OPERATIONVALUE;
    }

}
