package io.ciera.tool.sql.ooaofooa.value.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.subsystem.O_ATTR;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.O_ATTRImpl;
import io.ciera.tool.sql.ooaofooa.value.AttributeValueReference;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class AttributeValueReferenceImpl extends ModelInstance<AttributeValueReference,Sql> implements AttributeValueReference {

    public static final String KEY_LETTERS = "V_AVL";
    public static final AttributeValueReference EMPTY_ATTRIBUTEVALUEREFERENCE = new EmptyAttributeValueReference();

    private Sql context;

    // constructors
    private AttributeValueReferenceImpl( Sql context ) {
        this.context = context;
        ref_Value_ID = UniqueId.random();
        ref_Root_Value_ID = UniqueId.random();
        ref_Obj_ID = UniqueId.random();
        ref_Attr_ID = UniqueId.random();
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R806_is_value_of_O_ATTR_inst = O_ATTRImpl.EMPTY_O_ATTR;
        R807_has_root_Value_inst = ValueImpl.EMPTY_VALUE;
    }

    private AttributeValueReferenceImpl( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_Root_Value_ID, UniqueId ref_Obj_ID, UniqueId ref_Attr_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Value_ID = ref_Value_ID;
        this.ref_Root_Value_ID = ref_Root_Value_ID;
        this.ref_Obj_ID = ref_Obj_ID;
        this.ref_Attr_ID = ref_Attr_ID;
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R806_is_value_of_O_ATTR_inst = O_ATTRImpl.EMPTY_O_ATTR;
        R807_has_root_Value_inst = ValueImpl.EMPTY_VALUE;
    }

    public static AttributeValueReference create( Sql context ) throws XtumlException {
        AttributeValueReference newAttributeValueReference = new AttributeValueReferenceImpl( context );
        if ( context.addInstance( newAttributeValueReference ) ) {
            newAttributeValueReference.getRunContext().addChange(new InstanceCreatedDelta(newAttributeValueReference, KEY_LETTERS));
            return newAttributeValueReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static AttributeValueReference create( Sql context, UniqueId ref_Value_ID, UniqueId ref_Root_Value_ID, UniqueId ref_Obj_ID, UniqueId ref_Attr_ID ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Value_ID, ref_Root_Value_ID, ref_Obj_ID, ref_Attr_ID);
    }

    public static AttributeValueReference create( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_Root_Value_ID, UniqueId ref_Obj_ID, UniqueId ref_Attr_ID ) throws XtumlException {
        AttributeValueReference newAttributeValueReference = new AttributeValueReferenceImpl( context, instanceId, ref_Value_ID, ref_Root_Value_ID, ref_Obj_ID, ref_Attr_ID );
        if ( context.addInstance( newAttributeValueReference ) ) {
            return newAttributeValueReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Value_ID;
    @Override
    public UniqueId getValue_ID() throws XtumlException {
        checkLiving();
        return ref_Value_ID;
    }
    @Override
    public void setValue_ID(UniqueId ref_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Value_ID.inequality( this.ref_Value_ID)) {
            final UniqueId oldValue = this.ref_Value_ID;
            this.ref_Value_ID = ref_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Value_ID", oldValue, this.ref_Value_ID));
        }
    }
    private UniqueId ref_Root_Value_ID;
    @Override
    public void setRoot_Value_ID(UniqueId ref_Root_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Root_Value_ID.inequality( this.ref_Root_Value_ID)) {
            final UniqueId oldValue = this.ref_Root_Value_ID;
            this.ref_Root_Value_ID = ref_Root_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Root_Value_ID", oldValue, this.ref_Root_Value_ID));
        }
    }
    @Override
    public UniqueId getRoot_Value_ID() throws XtumlException {
        checkLiving();
        return ref_Root_Value_ID;
    }
    private UniqueId ref_Obj_ID;
    @Override
    public void setObj_ID(UniqueId ref_Obj_ID) throws XtumlException {
        checkLiving();
        if (ref_Obj_ID.inequality( this.ref_Obj_ID)) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
        }
    }
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
        return ref_Obj_ID;
    }
    private UniqueId ref_Attr_ID;
    @Override
    public void setAttr_ID(UniqueId ref_Attr_ID) throws XtumlException {
        checkLiving();
        if (ref_Attr_ID.inequality( this.ref_Attr_ID)) {
            final UniqueId oldValue = this.ref_Attr_ID;
            this.ref_Attr_ID = ref_Attr_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Attr_ID", oldValue, this.ref_Attr_ID));
        }
    }
    @Override
    public UniqueId getAttr_ID() throws XtumlException {
        checkLiving();
        return ref_Attr_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getValue_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Value R801_is_a_Value_inst;
    @Override
    public void setR801_is_a_Value( Value inst ) {
        R801_is_a_Value_inst = inst;
    }
    @Override
    public Value R801_is_a_Value() throws XtumlException {
        return R801_is_a_Value_inst;
    }
    private O_ATTR R806_is_value_of_O_ATTR_inst;
    @Override
    public void setR806_is_value_of_O_ATTR( O_ATTR inst ) {
        R806_is_value_of_O_ATTR_inst = inst;
    }
    @Override
    public O_ATTR R806_is_value_of_O_ATTR() throws XtumlException {
        return R806_is_value_of_O_ATTR_inst;
    }
    private Value R807_has_root_Value_inst;
    @Override
    public void setR807_has_root_Value( Value inst ) {
        R807_has_root_Value_inst = inst;
    }
    @Override
    public Value R807_has_root_Value() throws XtumlException {
        return R807_has_root_Value_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public AttributeValueReference self() {
        return this;
    }

    @Override
    public AttributeValueReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_ATTRIBUTEVALUEREFERENCE;
    }

}

class EmptyAttributeValueReference extends ModelInstance<AttributeValueReference,Sql> implements AttributeValueReference {

    // attributes
    public UniqueId getValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setRoot_Value_ID( UniqueId ref_Root_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getRoot_Value_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAttr_ID( UniqueId ref_Attr_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getAttr_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Value R801_is_a_Value() {
        return ValueImpl.EMPTY_VALUE;
    }
    @Override
    public O_ATTR R806_is_value_of_O_ATTR() {
        return O_ATTRImpl.EMPTY_O_ATTR;
    }
    @Override
    public Value R807_has_root_Value() {
        return ValueImpl.EMPTY_VALUE;
    }


    @Override
    public String getKeyLetters() {
        return AttributeValueReferenceImpl.KEY_LETTERS;
    }

    @Override
    public AttributeValueReference self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public AttributeValueReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return AttributeValueReferenceImpl.EMPTY_ATTRIBUTEVALUEREFERENCE;
    }

}
