package io.ciera.tool.sql.ooaofooa.subsystem.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.subsystem.ClassIdentifier;
import io.ciera.tool.sql.ooaofooa.subsystem.ClassIdentifierAttribute;
import io.ciera.tool.sql.ooaofooa.subsystem.O_ATTR;
import io.ciera.tool.sql.ooaofooa.subsystem.ReferredToIdentifierAttribute;
import io.ciera.tool.sql.ooaofooa.subsystem.ReferredToIdentifierAttributeSet;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.ClassIdentifierImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.O_ATTRImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.ReferredToIdentifierAttributeSetImpl;


public class ClassIdentifierAttributeImpl extends ModelInstance<ClassIdentifierAttribute,Sql> implements ClassIdentifierAttribute {

    public static final String KEY_LETTERS = "O_OIDA";
    public static final ClassIdentifierAttribute EMPTY_CLASSIDENTIFIERATTRIBUTE = new EmptyClassIdentifierAttribute();

    private Sql context;

    // constructors
    private ClassIdentifierAttributeImpl( Sql context ) {
        this.context = context;
        ref_Attr_ID = UniqueId.random();
        ref_Obj_ID = UniqueId.random();
        ref_Oid_ID = 0;
        m_localAttributeName = "";
        R105_is_made_up_of__O_ATTR_inst = O_ATTRImpl.EMPTY_O_ATTR;
        R105_is_part_of__ClassIdentifier_inst = ClassIdentifierImpl.EMPTY_CLASSIDENTIFIER;
        R110_identifies_for_this_association_ReferredToIdentifierAttribute_set = new ReferredToIdentifierAttributeSetImpl();
    }

    private ClassIdentifierAttributeImpl( Sql context, UniqueId instanceId, UniqueId ref_Attr_ID, UniqueId ref_Obj_ID, int ref_Oid_ID, String m_localAttributeName ) {
        super(instanceId);
        this.context = context;
        this.ref_Attr_ID = ref_Attr_ID;
        this.ref_Obj_ID = ref_Obj_ID;
        this.ref_Oid_ID = ref_Oid_ID;
        this.m_localAttributeName = m_localAttributeName;
        R105_is_made_up_of__O_ATTR_inst = O_ATTRImpl.EMPTY_O_ATTR;
        R105_is_part_of__ClassIdentifier_inst = ClassIdentifierImpl.EMPTY_CLASSIDENTIFIER;
        R110_identifies_for_this_association_ReferredToIdentifierAttribute_set = new ReferredToIdentifierAttributeSetImpl();
    }

    public static ClassIdentifierAttribute create( Sql context ) throws XtumlException {
        ClassIdentifierAttribute newClassIdentifierAttribute = new ClassIdentifierAttributeImpl( context );
        if ( context.addInstance( newClassIdentifierAttribute ) ) {
            newClassIdentifierAttribute.getRunContext().addChange(new InstanceCreatedDelta(newClassIdentifierAttribute, KEY_LETTERS));
            return newClassIdentifierAttribute;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ClassIdentifierAttribute create( Sql context, UniqueId ref_Attr_ID, UniqueId ref_Obj_ID, int ref_Oid_ID, String m_localAttributeName ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Attr_ID, ref_Obj_ID, ref_Oid_ID, m_localAttributeName);
    }

    public static ClassIdentifierAttribute create( Sql context, UniqueId instanceId, UniqueId ref_Attr_ID, UniqueId ref_Obj_ID, int ref_Oid_ID, String m_localAttributeName ) throws XtumlException {
        ClassIdentifierAttribute newClassIdentifierAttribute = new ClassIdentifierAttributeImpl( context, instanceId, ref_Attr_ID, ref_Obj_ID, ref_Oid_ID, m_localAttributeName );
        if ( context.addInstance( newClassIdentifierAttribute ) ) {
            return newClassIdentifierAttribute;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Attr_ID;
    @Override
    public UniqueId getAttr_ID() throws XtumlException {
        checkLiving();
        return ref_Attr_ID;
    }
    @Override
    public void setAttr_ID(UniqueId ref_Attr_ID) throws XtumlException {
        checkLiving();
        if (ref_Attr_ID.inequality( this.ref_Attr_ID)) {
            final UniqueId oldValue = this.ref_Attr_ID;
            this.ref_Attr_ID = ref_Attr_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Attr_ID", oldValue, this.ref_Attr_ID));
            if ( !R110_identifies_for_this_association_ReferredToIdentifierAttribute().isEmpty() ) R110_identifies_for_this_association_ReferredToIdentifierAttribute().setAttr_ID( ref_Attr_ID );
        }
    }
    private UniqueId ref_Obj_ID;
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
        return ref_Obj_ID;
    }
    @Override
    public void setObj_ID(UniqueId ref_Obj_ID) throws XtumlException {
        checkLiving();
        if (ref_Obj_ID.inequality( this.ref_Obj_ID)) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
            if ( !R110_identifies_for_this_association_ReferredToIdentifierAttribute().isEmpty() ) R110_identifies_for_this_association_ReferredToIdentifierAttribute().setObj_ID( ref_Obj_ID );
        }
    }
    private int ref_Oid_ID;
    @Override
    public int getOid_ID() throws XtumlException {
        checkLiving();
        return ref_Oid_ID;
    }
    @Override
    public void setOid_ID(int ref_Oid_ID) throws XtumlException {
        checkLiving();
        if (ref_Oid_ID != this.ref_Oid_ID) {
            final int oldValue = this.ref_Oid_ID;
            this.ref_Oid_ID = ref_Oid_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Oid_ID", oldValue, this.ref_Oid_ID));
            if ( !R110_identifies_for_this_association_ReferredToIdentifierAttribute().isEmpty() ) R110_identifies_for_this_association_ReferredToIdentifierAttribute().setOid_ID( ref_Oid_ID );
        }
    }
    private String m_localAttributeName;
    @Override
    public void setLocalAttributeName(String m_localAttributeName) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_localAttributeName, this.m_localAttributeName)) {
            final String oldValue = this.m_localAttributeName;
            this.m_localAttributeName = m_localAttributeName;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_localAttributeName", oldValue, this.m_localAttributeName));
        }
    }
    @Override
    public String getLocalAttributeName() throws XtumlException {
        checkLiving();
        return m_localAttributeName;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getAttr_ID(), getObj_ID(), getOid_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private O_ATTR R105_is_made_up_of__O_ATTR_inst;
    @Override
    public void setR105_is_made_up_of__O_ATTR( O_ATTR inst ) {
        R105_is_made_up_of__O_ATTR_inst = inst;
    }
    @Override
    public O_ATTR R105_is_made_up_of__O_ATTR() throws XtumlException {
        return R105_is_made_up_of__O_ATTR_inst;
    }
    private ClassIdentifier R105_is_part_of__ClassIdentifier_inst;
    @Override
    public void setR105_is_part_of__ClassIdentifier( ClassIdentifier inst ) {
        R105_is_part_of__ClassIdentifier_inst = inst;
    }
    @Override
    public ClassIdentifier R105_is_part_of__ClassIdentifier() throws XtumlException {
        return R105_is_part_of__ClassIdentifier_inst;
    }
    private ReferredToIdentifierAttributeSet R110_identifies_for_this_association_ReferredToIdentifierAttribute_set;
    @Override
    public void addR110_identifies_for_this_association_ReferredToIdentifierAttribute( ReferredToIdentifierAttribute inst ) {
        R110_identifies_for_this_association_ReferredToIdentifierAttribute_set.add(inst);
    }
    @Override
    public void removeR110_identifies_for_this_association_ReferredToIdentifierAttribute( ReferredToIdentifierAttribute inst ) {
        R110_identifies_for_this_association_ReferredToIdentifierAttribute_set.remove(inst);
    }
    @Override
    public ReferredToIdentifierAttributeSet R110_identifies_for_this_association_ReferredToIdentifierAttribute() throws XtumlException {
        return R110_identifies_for_this_association_ReferredToIdentifierAttribute_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ClassIdentifierAttribute self() {
        return this;
    }

    @Override
    public ClassIdentifierAttribute oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_CLASSIDENTIFIERATTRIBUTE;
    }

}

class EmptyClassIdentifierAttribute extends ModelInstance<ClassIdentifierAttribute,Sql> implements ClassIdentifierAttribute {

    // attributes
    public UniqueId getAttr_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAttr_ID( UniqueId ref_Attr_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getOid_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setOid_ID( int ref_Oid_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setLocalAttributeName( String m_localAttributeName ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLocalAttributeName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public O_ATTR R105_is_made_up_of__O_ATTR() {
        return O_ATTRImpl.EMPTY_O_ATTR;
    }
    @Override
    public ClassIdentifier R105_is_part_of__ClassIdentifier() {
        return ClassIdentifierImpl.EMPTY_CLASSIDENTIFIER;
    }
    @Override
    public ReferredToIdentifierAttributeSet R110_identifies_for_this_association_ReferredToIdentifierAttribute() {
        return (new ReferredToIdentifierAttributeSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return ClassIdentifierAttributeImpl.KEY_LETTERS;
    }

    @Override
    public ClassIdentifierAttribute self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ClassIdentifierAttribute oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ClassIdentifierAttributeImpl.EMPTY_CLASSIDENTIFIERATTRIBUTE;
    }

}
