package io.ciera.tool.sql.ooaofooa.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.statemachine.CreationTransition;
import io.ciera.tool.sql.ooaofooa.statemachine.LocalEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.Transition;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.LocalEventImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.TransitionImpl;


public class CreationTransitionImpl extends ModelInstance<CreationTransition,Sql> implements CreationTransition {

    public static final String KEY_LETTERS = "SM_CRTXN";
    public static final CreationTransition EMPTY_CREATIONTRANSITION = new EmptyCreationTransition();

    private Sql context;

    // constructors
    private CreationTransitionImpl( Sql context ) {
        this.context = context;
        ref_Trans_ID = UniqueId.random();
        ref_SM_ID = UniqueId.random();
        ref_SMevt_ID = UniqueId.random();
        m_SMspd_IDdeprecated = UniqueId.random();
        R507_is_a_Transition_inst = TransitionImpl.EMPTY_TRANSITION;
        R509_is_assigned_to_LocalEvent_inst = LocalEventImpl.EMPTY_LOCALEVENT;
    }

    private CreationTransitionImpl( Sql context, UniqueId instanceId, UniqueId ref_Trans_ID, UniqueId ref_SM_ID, UniqueId ref_SMevt_ID, UniqueId m_SMspd_IDdeprecated ) {
        super(instanceId);
        this.context = context;
        this.ref_Trans_ID = ref_Trans_ID;
        this.ref_SM_ID = ref_SM_ID;
        this.ref_SMevt_ID = ref_SMevt_ID;
        this.m_SMspd_IDdeprecated = m_SMspd_IDdeprecated;
        R507_is_a_Transition_inst = TransitionImpl.EMPTY_TRANSITION;
        R509_is_assigned_to_LocalEvent_inst = LocalEventImpl.EMPTY_LOCALEVENT;
    }

    public static CreationTransition create( Sql context ) throws XtumlException {
        CreationTransition newCreationTransition = new CreationTransitionImpl( context );
        if ( context.addInstance( newCreationTransition ) ) {
            newCreationTransition.getRunContext().addChange(new InstanceCreatedDelta(newCreationTransition, KEY_LETTERS));
            return newCreationTransition;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static CreationTransition create( Sql context, UniqueId ref_Trans_ID, UniqueId ref_SM_ID, UniqueId ref_SMevt_ID, UniqueId m_SMspd_IDdeprecated ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Trans_ID, ref_SM_ID, ref_SMevt_ID, m_SMspd_IDdeprecated);
    }

    public static CreationTransition create( Sql context, UniqueId instanceId, UniqueId ref_Trans_ID, UniqueId ref_SM_ID, UniqueId ref_SMevt_ID, UniqueId m_SMspd_IDdeprecated ) throws XtumlException {
        CreationTransition newCreationTransition = new CreationTransitionImpl( context, instanceId, ref_Trans_ID, ref_SM_ID, ref_SMevt_ID, m_SMspd_IDdeprecated );
        if ( context.addInstance( newCreationTransition ) ) {
            return newCreationTransition;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Trans_ID;
    @Override
    public void setTrans_ID(UniqueId ref_Trans_ID) throws XtumlException {
        checkLiving();
        if (ref_Trans_ID.inequality( this.ref_Trans_ID)) {
            final UniqueId oldValue = this.ref_Trans_ID;
            this.ref_Trans_ID = ref_Trans_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Trans_ID", oldValue, this.ref_Trans_ID));
        }
    }
    @Override
    public UniqueId getTrans_ID() throws XtumlException {
        checkLiving();
        return ref_Trans_ID;
    }
    private UniqueId ref_SM_ID;
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
        return ref_SM_ID;
    }
    @Override
    public void setSM_ID(UniqueId ref_SM_ID) throws XtumlException {
        checkLiving();
        if (ref_SM_ID.inequality( this.ref_SM_ID)) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
        }
    }
    private UniqueId ref_SMevt_ID;
    @Override
    public void setSMevt_ID(UniqueId ref_SMevt_ID) throws XtumlException {
        checkLiving();
        if (ref_SMevt_ID.inequality( this.ref_SMevt_ID)) {
            final UniqueId oldValue = this.ref_SMevt_ID;
            this.ref_SMevt_ID = ref_SMevt_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SMevt_ID", oldValue, this.ref_SMevt_ID));
        }
    }
    @Override
    public UniqueId getSMevt_ID() throws XtumlException {
        checkLiving();
        return ref_SMevt_ID;
    }
    private UniqueId m_SMspd_IDdeprecated;
    @Override
    public void setSMspd_IDdeprecated(UniqueId m_SMspd_IDdeprecated) throws XtumlException {
        checkLiving();
        if (m_SMspd_IDdeprecated.inequality( this.m_SMspd_IDdeprecated)) {
            final UniqueId oldValue = this.m_SMspd_IDdeprecated;
            this.m_SMspd_IDdeprecated = m_SMspd_IDdeprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_SMspd_IDdeprecated", oldValue, this.m_SMspd_IDdeprecated));
        }
    }
    @Override
    public UniqueId getSMspd_IDdeprecated() throws XtumlException {
        checkLiving();
        return m_SMspd_IDdeprecated;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getTrans_ID(), getSM_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Transition R507_is_a_Transition_inst;
    @Override
    public void setR507_is_a_Transition( Transition inst ) {
        R507_is_a_Transition_inst = inst;
    }
    @Override
    public Transition R507_is_a_Transition() throws XtumlException {
        return R507_is_a_Transition_inst;
    }
    private LocalEvent R509_is_assigned_to_LocalEvent_inst;
    @Override
    public void setR509_is_assigned_to_LocalEvent( LocalEvent inst ) {
        R509_is_assigned_to_LocalEvent_inst = inst;
    }
    @Override
    public LocalEvent R509_is_assigned_to_LocalEvent() throws XtumlException {
        return R509_is_assigned_to_LocalEvent_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public CreationTransition self() {
        return this;
    }

    @Override
    public CreationTransition oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_CREATIONTRANSITION;
    }

}

class EmptyCreationTransition extends ModelInstance<CreationTransition,Sql> implements CreationTransition {

    // attributes
    public void setTrans_ID( UniqueId ref_Trans_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getTrans_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSMevt_ID( UniqueId ref_SMevt_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMevt_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSMspd_IDdeprecated( UniqueId m_SMspd_IDdeprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMspd_IDdeprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Transition R507_is_a_Transition() {
        return TransitionImpl.EMPTY_TRANSITION;
    }
    @Override
    public LocalEvent R509_is_assigned_to_LocalEvent() {
        return LocalEventImpl.EMPTY_LOCALEVENT;
    }


    @Override
    public String getKeyLetters() {
        return CreationTransitionImpl.KEY_LETTERS;
    }

    @Override
    public CreationTransition self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public CreationTransition oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return CreationTransitionImpl.EMPTY_CREATIONTRANSITION;
    }

}
