package io.ciera.tool.sql.ooaofooa.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.StateActionBody;
import io.ciera.tool.sql.ooaofooa.body.TransitionActionBody;
import io.ciera.tool.sql.ooaofooa.body.impl.StateActionBodyImpl;
import io.ciera.tool.sql.ooaofooa.body.impl.TransitionActionBodyImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.Action;
import io.ciera.tool.sql.ooaofooa.statemachine.ActionHome;
import io.ciera.tool.sql.ooaofooa.statemachine.SM_SM;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.ActionHomeImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.SM_SMImpl;

import ooaofooa.datatypes.ActionDialect;
import ooaofooa.datatypes.ParseStatus;


public class ActionImpl extends ModelInstance<Action,Sql> implements Action {

    public static final String KEY_LETTERS = "SM_ACT";
    public static final Action EMPTY_ACTION = new EmptyAction();

    private Sql context;

    // constructors
    private ActionImpl( Sql context ) {
        this.context = context;
        m_Act_ID = UniqueId.random();
        ref_SM_ID = UniqueId.random();
        m_Suc_Pars = ParseStatus.UNINITIALIZED_ENUM;
        m_Action_Semantics = "";
        m_Action_Semantics_internal = "";
        m_Descrip = "";
        m_Dialect = ActionDialect.UNINITIALIZED_ENUM;
        R514_resides_in_ActionHome_inst = ActionHomeImpl.EMPTY_ACTIONHOME;
        R515_SM_SM_inst = SM_SMImpl.EMPTY_SM_SM;
        R688_TransitionActionBody_inst = TransitionActionBodyImpl.EMPTY_TRANSITIONACTIONBODY;
        R691_StateActionBody_inst = StateActionBodyImpl.EMPTY_STATEACTIONBODY;
    }

    private ActionImpl( Sql context, UniqueId instanceId, UniqueId m_Act_ID, UniqueId ref_SM_ID, ParseStatus m_Suc_Pars, String m_Action_Semantics, String m_Action_Semantics_internal, String m_Descrip, ActionDialect m_Dialect ) {
        super(instanceId);
        this.context = context;
        this.m_Act_ID = m_Act_ID;
        this.ref_SM_ID = ref_SM_ID;
        this.m_Suc_Pars = m_Suc_Pars;
        this.m_Action_Semantics = m_Action_Semantics;
        this.m_Action_Semantics_internal = m_Action_Semantics_internal;
        this.m_Descrip = m_Descrip;
        this.m_Dialect = m_Dialect;
        R514_resides_in_ActionHome_inst = ActionHomeImpl.EMPTY_ACTIONHOME;
        R515_SM_SM_inst = SM_SMImpl.EMPTY_SM_SM;
        R688_TransitionActionBody_inst = TransitionActionBodyImpl.EMPTY_TRANSITIONACTIONBODY;
        R691_StateActionBody_inst = StateActionBodyImpl.EMPTY_STATEACTIONBODY;
    }

    public static Action create( Sql context ) throws XtumlException {
        Action newAction = new ActionImpl( context );
        if ( context.addInstance( newAction ) ) {
            newAction.getRunContext().addChange(new InstanceCreatedDelta(newAction, KEY_LETTERS));
            return newAction;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Action create( Sql context, UniqueId m_Act_ID, UniqueId ref_SM_ID, ParseStatus m_Suc_Pars, String m_Action_Semantics, String m_Action_Semantics_internal, String m_Descrip, ActionDialect m_Dialect ) throws XtumlException {
        return create(context, UniqueId.random(), m_Act_ID, ref_SM_ID, m_Suc_Pars, m_Action_Semantics, m_Action_Semantics_internal, m_Descrip, m_Dialect);
    }

    public static Action create( Sql context, UniqueId instanceId, UniqueId m_Act_ID, UniqueId ref_SM_ID, ParseStatus m_Suc_Pars, String m_Action_Semantics, String m_Action_Semantics_internal, String m_Descrip, ActionDialect m_Dialect ) throws XtumlException {
        Action newAction = new ActionImpl( context, instanceId, m_Act_ID, ref_SM_ID, m_Suc_Pars, m_Action_Semantics, m_Action_Semantics_internal, m_Descrip, m_Dialect );
        if ( context.addInstance( newAction ) ) {
            return newAction;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Act_ID;
    @Override
    public void setAct_ID(UniqueId m_Act_ID) throws XtumlException {
        checkLiving();
        if (m_Act_ID.inequality( this.m_Act_ID)) {
            final UniqueId oldValue = this.m_Act_ID;
            this.m_Act_ID = m_Act_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Act_ID", oldValue, this.m_Act_ID));
            if ( !R514_resides_in_ActionHome().isEmpty() ) R514_resides_in_ActionHome().setAct_ID( m_Act_ID );
            if ( !R688_TransitionActionBody().isEmpty() ) R688_TransitionActionBody().setAct_ID( m_Act_ID );
            if ( !R691_StateActionBody().isEmpty() ) R691_StateActionBody().setAct_ID( m_Act_ID );
        }
    }
    @Override
    public UniqueId getAct_ID() throws XtumlException {
        checkLiving();
        return m_Act_ID;
    }
    private UniqueId ref_SM_ID;
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
        return ref_SM_ID;
    }
    @Override
    public void setSM_ID(UniqueId ref_SM_ID) throws XtumlException {
        checkLiving();
        if (ref_SM_ID.inequality( this.ref_SM_ID)) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
            if ( !R514_resides_in_ActionHome().isEmpty() ) R514_resides_in_ActionHome().setSM_ID( ref_SM_ID );
            if ( !R688_TransitionActionBody().isEmpty() ) R688_TransitionActionBody().setSM_ID( ref_SM_ID );
            if ( !R691_StateActionBody().isEmpty() ) R691_StateActionBody().setSM_ID( ref_SM_ID );
        }
    }
    private ParseStatus m_Suc_Pars;
    @Override
    public void setSuc_Pars(ParseStatus m_Suc_Pars) throws XtumlException {
        checkLiving();
        if (m_Suc_Pars.inequality( this.m_Suc_Pars)) {
            final ParseStatus oldValue = this.m_Suc_Pars;
            this.m_Suc_Pars = m_Suc_Pars;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Suc_Pars", oldValue, this.m_Suc_Pars));
        }
    }
    @Override
    public ParseStatus getSuc_Pars() throws XtumlException {
        checkLiving();
        return m_Suc_Pars;
    }
    private String m_Action_Semantics;
    @Override
    public void setAction_Semantics(String m_Action_Semantics) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Action_Semantics, this.m_Action_Semantics)) {
            final String oldValue = this.m_Action_Semantics;
            this.m_Action_Semantics = m_Action_Semantics;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Action_Semantics", oldValue, this.m_Action_Semantics));
        }
    }
    @Override
    public String getAction_Semantics() throws XtumlException {
        checkLiving();
        return m_Action_Semantics;
    }
    private String m_Action_Semantics_internal;
    @Override
    public String getAction_Semantics_internal() throws XtumlException {
        checkLiving();
        return m_Action_Semantics_internal;
    }
    @Override
    public void setAction_Semantics_internal(String m_Action_Semantics_internal) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Action_Semantics_internal, this.m_Action_Semantics_internal)) {
            final String oldValue = this.m_Action_Semantics_internal;
            this.m_Action_Semantics_internal = m_Action_Semantics_internal;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Action_Semantics_internal", oldValue, this.m_Action_Semantics_internal));
        }
    }
    private String m_Descrip;
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    private ActionDialect m_Dialect;
    @Override
    public void setDialect(ActionDialect m_Dialect) throws XtumlException {
        checkLiving();
        if (m_Dialect.inequality( this.m_Dialect)) {
            final ActionDialect oldValue = this.m_Dialect;
            this.m_Dialect = m_Dialect;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Dialect", oldValue, this.m_Dialect));
        }
    }
    @Override
    public ActionDialect getDialect() throws XtumlException {
        checkLiving();
        return m_Dialect;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getAct_ID(), getSM_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ActionHome R514_resides_in_ActionHome_inst;
    @Override
    public void setR514_resides_in_ActionHome( ActionHome inst ) {
        R514_resides_in_ActionHome_inst = inst;
    }
    @Override
    public ActionHome R514_resides_in_ActionHome() throws XtumlException {
        return R514_resides_in_ActionHome_inst;
    }
    private SM_SM R515_SM_SM_inst;
    @Override
    public void setR515_SM_SM( SM_SM inst ) {
        R515_SM_SM_inst = inst;
    }
    @Override
    public SM_SM R515_SM_SM() throws XtumlException {
        return R515_SM_SM_inst;
    }
    private TransitionActionBody R688_TransitionActionBody_inst;
    @Override
    public void setR688_TransitionActionBody( TransitionActionBody inst ) {
        R688_TransitionActionBody_inst = inst;
    }
    @Override
    public TransitionActionBody R688_TransitionActionBody() throws XtumlException {
        return R688_TransitionActionBody_inst;
    }
    private StateActionBody R691_StateActionBody_inst;
    @Override
    public void setR691_StateActionBody( StateActionBody inst ) {
        R691_StateActionBody_inst = inst;
    }
    @Override
    public StateActionBody R691_StateActionBody() throws XtumlException {
        return R691_StateActionBody_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Action self() {
        return this;
    }

    @Override
    public Action oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_ACTION;
    }

}

class EmptyAction extends ModelInstance<Action,Sql> implements Action {

    // attributes
    public void setAct_ID( UniqueId m_Act_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getAct_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSuc_Pars( ParseStatus m_Suc_Pars ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public ParseStatus getSuc_Pars() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAction_Semantics( String m_Action_Semantics ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getAction_Semantics() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getAction_Semantics_internal() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAction_Semantics_internal( String m_Action_Semantics_internal ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDialect( ActionDialect m_Dialect ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public ActionDialect getDialect() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ActionHome R514_resides_in_ActionHome() {
        return ActionHomeImpl.EMPTY_ACTIONHOME;
    }
    @Override
    public SM_SM R515_SM_SM() {
        return SM_SMImpl.EMPTY_SM_SM;
    }
    @Override
    public TransitionActionBody R688_TransitionActionBody() {
        return TransitionActionBodyImpl.EMPTY_TRANSITIONACTIONBODY;
    }
    @Override
    public StateActionBody R691_StateActionBody() {
        return StateActionBodyImpl.EMPTY_STATEACTIONBODY;
    }


    @Override
    public String getKeyLetters() {
        return ActionImpl.KEY_LETTERS;
    }

    @Override
    public Action self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Action oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ActionImpl.EMPTY_ACTION;
    }

}
