package io.ciera.tool.sql.ooaofooa.packageableelement.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.C_C;
import io.ciera.tool.sql.ooaofooa.component.impl.C_CImpl;
import io.ciera.tool.sql.ooaofooa.packageableelement.ComponentResultSet;
import io.ciera.tool.sql.ooaofooa.packageableelement.ComponentVisibility;
import io.ciera.tool.sql.ooaofooa.packageableelement.ComponentVisibilitySet;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.ComponentVisibilitySetImpl;

import ooaofooa.datatypes.ElementTypeConstants;


public class ComponentResultSetImpl extends ModelInstance<ComponentResultSet,Sql> implements ComponentResultSet {

    public static final String KEY_LETTERS = "PE_CRS";
    public static final ComponentResultSet EMPTY_COMPONENTRESULTSET = new EmptyComponentResultSet();

    private Sql context;

    // constructors
    private ComponentResultSetImpl( Sql context ) {
        this.context = context;
        ref_Id = UniqueId.random();
        m_Name = "";
        m_Type = ElementTypeConstants.UNINITIALIZED_ENUM;
        R8007_held_by_C_C_inst = C_CImpl.EMPTY_C_C;
        R8008_made_up_of_ComponentVisibility_set = new ComponentVisibilitySetImpl();
    }

    private ComponentResultSetImpl( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name, ElementTypeConstants m_Type ) {
        super(instanceId);
        this.context = context;
        this.ref_Id = ref_Id;
        this.m_Name = m_Name;
        this.m_Type = m_Type;
        R8007_held_by_C_C_inst = C_CImpl.EMPTY_C_C;
        R8008_made_up_of_ComponentVisibility_set = new ComponentVisibilitySetImpl();
    }

    public static ComponentResultSet create( Sql context ) throws XtumlException {
        ComponentResultSet newComponentResultSet = new ComponentResultSetImpl( context );
        if ( context.addInstance( newComponentResultSet ) ) {
            newComponentResultSet.getRunContext().addChange(new InstanceCreatedDelta(newComponentResultSet, KEY_LETTERS));
            return newComponentResultSet;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ComponentResultSet create( Sql context, UniqueId ref_Id, String m_Name, ElementTypeConstants m_Type ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Id, m_Name, m_Type);
    }

    public static ComponentResultSet create( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name, ElementTypeConstants m_Type ) throws XtumlException {
        ComponentResultSet newComponentResultSet = new ComponentResultSetImpl( context, instanceId, ref_Id, m_Name, m_Type );
        if ( context.addInstance( newComponentResultSet ) ) {
            return newComponentResultSet;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Id;
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return ref_Id;
    }
    @Override
    public void setId(UniqueId ref_Id) throws XtumlException {
        checkLiving();
        if (ref_Id.inequality( this.ref_Id)) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
            if ( !R8008_made_up_of_ComponentVisibility().isEmpty() ) R8008_made_up_of_ComponentVisibility().setId( ref_Id );
        }
    }
    private String m_Name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
            if ( !R8008_made_up_of_ComponentVisibility().isEmpty() ) R8008_made_up_of_ComponentVisibility().setName( m_Name );
        }
    }
    private ElementTypeConstants m_Type;
    @Override
    public ElementTypeConstants getType() throws XtumlException {
        checkLiving();
        return m_Type;
    }
    @Override
    public void setType(ElementTypeConstants m_Type) throws XtumlException {
        checkLiving();
        if (m_Type.inequality( this.m_Type)) {
            final ElementTypeConstants oldValue = this.m_Type;
            this.m_Type = m_Type;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Type", oldValue, this.m_Type));
            if ( !R8008_made_up_of_ComponentVisibility().isEmpty() ) R8008_made_up_of_ComponentVisibility().setType( m_Type );
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId(), getName(), getType());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private C_C R8007_held_by_C_C_inst;
    @Override
    public void setR8007_held_by_C_C( C_C inst ) {
        R8007_held_by_C_C_inst = inst;
    }
    @Override
    public C_C R8007_held_by_C_C() throws XtumlException {
        return R8007_held_by_C_C_inst;
    }
    private ComponentVisibilitySet R8008_made_up_of_ComponentVisibility_set;
    @Override
    public void addR8008_made_up_of_ComponentVisibility( ComponentVisibility inst ) {
        R8008_made_up_of_ComponentVisibility_set.add(inst);
    }
    @Override
    public void removeR8008_made_up_of_ComponentVisibility( ComponentVisibility inst ) {
        R8008_made_up_of_ComponentVisibility_set.remove(inst);
    }
    @Override
    public ComponentVisibilitySet R8008_made_up_of_ComponentVisibility() throws XtumlException {
        return R8008_made_up_of_ComponentVisibility_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ComponentResultSet self() {
        return this;
    }

    @Override
    public ComponentResultSet oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_COMPONENTRESULTSET;
    }

}

class EmptyComponentResultSet extends ModelInstance<ComponentResultSet,Sql> implements ComponentResultSet {

    // attributes
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public ElementTypeConstants getType() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setType( ElementTypeConstants m_Type ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public C_C R8007_held_by_C_C() {
        return C_CImpl.EMPTY_C_C;
    }
    @Override
    public ComponentVisibilitySet R8008_made_up_of_ComponentVisibility() {
        return (new ComponentVisibilitySetImpl());
    }


    @Override
    public String getKeyLetters() {
        return ComponentResultSetImpl.KEY_LETTERS;
    }

    @Override
    public ComponentResultSet self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ComponentResultSet oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ComponentResultSetImpl.EMPTY_COMPONENTRESULTSET;
    }

}
