package io.ciera.tool.sql.ooaofooa.interaction.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.domain.ExternalEntity;
import io.ciera.tool.sql.ooaofooa.domain.impl.ExternalEntityImpl;
import io.ciera.tool.sql.ooaofooa.interaction.ExternalEntityParticipant;
import io.ciera.tool.sql.ooaofooa.interaction.InteractionParticipant;
import io.ciera.tool.sql.ooaofooa.interaction.impl.InteractionParticipantImpl;


public class ExternalEntityParticipantImpl extends ModelInstance<ExternalEntityParticipant,Sql> implements ExternalEntityParticipant {

    public static final String KEY_LETTERS = "SQ_EEP";
    public static final ExternalEntityParticipant EMPTY_EXTERNALENTITYPARTICIPANT = new EmptyExternalEntityParticipant();

    private Sql context;

    // constructors
    private ExternalEntityParticipantImpl( Sql context ) {
        this.context = context;
        ref_Part_ID = UniqueId.random();
        ref_EE_ID = UniqueId.random();
        m_Label = "";
        m_InformalName = "";
        m_Descrip = "";
        m_isFormal = false;
        R930_is_a_InteractionParticipant_inst = InteractionParticipantImpl.EMPTY_INTERACTIONPARTICIPANT;
        R933_represents_ExternalEntity_inst = ExternalEntityImpl.EMPTY_EXTERNALENTITY;
    }

    private ExternalEntityParticipantImpl( Sql context, UniqueId instanceId, UniqueId ref_Part_ID, UniqueId ref_EE_ID, String m_Label, String m_InformalName, String m_Descrip, boolean m_isFormal ) {
        super(instanceId);
        this.context = context;
        this.ref_Part_ID = ref_Part_ID;
        this.ref_EE_ID = ref_EE_ID;
        this.m_Label = m_Label;
        this.m_InformalName = m_InformalName;
        this.m_Descrip = m_Descrip;
        this.m_isFormal = m_isFormal;
        R930_is_a_InteractionParticipant_inst = InteractionParticipantImpl.EMPTY_INTERACTIONPARTICIPANT;
        R933_represents_ExternalEntity_inst = ExternalEntityImpl.EMPTY_EXTERNALENTITY;
    }

    public static ExternalEntityParticipant create( Sql context ) throws XtumlException {
        ExternalEntityParticipant newExternalEntityParticipant = new ExternalEntityParticipantImpl( context );
        if ( context.addInstance( newExternalEntityParticipant ) ) {
            newExternalEntityParticipant.getRunContext().addChange(new InstanceCreatedDelta(newExternalEntityParticipant, KEY_LETTERS));
            return newExternalEntityParticipant;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ExternalEntityParticipant create( Sql context, UniqueId ref_Part_ID, UniqueId ref_EE_ID, String m_Label, String m_InformalName, String m_Descrip, boolean m_isFormal ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Part_ID, ref_EE_ID, m_Label, m_InformalName, m_Descrip, m_isFormal);
    }

    public static ExternalEntityParticipant create( Sql context, UniqueId instanceId, UniqueId ref_Part_ID, UniqueId ref_EE_ID, String m_Label, String m_InformalName, String m_Descrip, boolean m_isFormal ) throws XtumlException {
        ExternalEntityParticipant newExternalEntityParticipant = new ExternalEntityParticipantImpl( context, instanceId, ref_Part_ID, ref_EE_ID, m_Label, m_InformalName, m_Descrip, m_isFormal );
        if ( context.addInstance( newExternalEntityParticipant ) ) {
            return newExternalEntityParticipant;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Part_ID;
    @Override
    public UniqueId getPart_ID() throws XtumlException {
        checkLiving();
        return ref_Part_ID;
    }
    @Override
    public void setPart_ID(UniqueId ref_Part_ID) throws XtumlException {
        checkLiving();
        if (ref_Part_ID.inequality( this.ref_Part_ID)) {
            final UniqueId oldValue = this.ref_Part_ID;
            this.ref_Part_ID = ref_Part_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Part_ID", oldValue, this.ref_Part_ID));
        }
    }
    private UniqueId ref_EE_ID;
    @Override
    public void setEE_ID(UniqueId ref_EE_ID) throws XtumlException {
        checkLiving();
        if (ref_EE_ID.inequality( this.ref_EE_ID)) {
            final UniqueId oldValue = this.ref_EE_ID;
            this.ref_EE_ID = ref_EE_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_EE_ID", oldValue, this.ref_EE_ID));
        }
    }
    @Override
    public UniqueId getEE_ID() throws XtumlException {
        checkLiving();
        return ref_EE_ID;
    }
    private String m_Label;
    @Override
    public void setLabel(String m_Label) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Label, this.m_Label)) {
            final String oldValue = this.m_Label;
            this.m_Label = m_Label;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Label", oldValue, this.m_Label));
        }
    }
    @Override
    public String getLabel() throws XtumlException {
        checkLiving();
        return m_Label;
    }
    private String m_InformalName;
    @Override
    public String getInformalName() throws XtumlException {
        checkLiving();
        return m_InformalName;
    }
    @Override
    public void setInformalName(String m_InformalName) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_InformalName, this.m_InformalName)) {
            final String oldValue = this.m_InformalName;
            this.m_InformalName = m_InformalName;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_InformalName", oldValue, this.m_InformalName));
        }
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    private boolean m_isFormal;
    @Override
    public boolean getIsFormal() throws XtumlException {
        checkLiving();
        return m_isFormal;
    }
    @Override
    public void setIsFormal(boolean m_isFormal) throws XtumlException {
        checkLiving();
        if (m_isFormal != this.m_isFormal) {
            final boolean oldValue = this.m_isFormal;
            this.m_isFormal = m_isFormal;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_isFormal", oldValue, this.m_isFormal));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getPart_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private InteractionParticipant R930_is_a_InteractionParticipant_inst;
    @Override
    public void setR930_is_a_InteractionParticipant( InteractionParticipant inst ) {
        R930_is_a_InteractionParticipant_inst = inst;
    }
    @Override
    public InteractionParticipant R930_is_a_InteractionParticipant() throws XtumlException {
        return R930_is_a_InteractionParticipant_inst;
    }
    private ExternalEntity R933_represents_ExternalEntity_inst;
    @Override
    public void setR933_represents_ExternalEntity( ExternalEntity inst ) {
        R933_represents_ExternalEntity_inst = inst;
    }
    @Override
    public ExternalEntity R933_represents_ExternalEntity() throws XtumlException {
        return R933_represents_ExternalEntity_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ExternalEntityParticipant self() {
        return this;
    }

    @Override
    public ExternalEntityParticipant oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_EXTERNALENTITYPARTICIPANT;
    }

}

class EmptyExternalEntityParticipant extends ModelInstance<ExternalEntityParticipant,Sql> implements ExternalEntityParticipant {

    // attributes
    public UniqueId getPart_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPart_ID( UniqueId ref_Part_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setEE_ID( UniqueId ref_EE_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getEE_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLabel( String m_Label ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLabel() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getInformalName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setInformalName( String m_InformalName ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getIsFormal() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIsFormal( boolean m_isFormal ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public InteractionParticipant R930_is_a_InteractionParticipant() {
        return InteractionParticipantImpl.EMPTY_INTERACTIONPARTICIPANT;
    }
    @Override
    public ExternalEntity R933_represents_ExternalEntity() {
        return ExternalEntityImpl.EMPTY_EXTERNALENTITY;
    }


    @Override
    public String getKeyLetters() {
        return ExternalEntityParticipantImpl.KEY_LETTERS;
    }

    @Override
    public ExternalEntityParticipant self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ExternalEntityParticipant oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ExternalEntityParticipantImpl.EMPTY_EXTERNALENTITYPARTICIPANT;
    }

}
