package io.ciera.tool.sql.ooaofooa.instance.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.ooaofooa.association.AssociationSet;
import io.ciera.tool.sql.ooaofooa.association.impl.AssociationSetImpl;
import io.ciera.tool.sql.ooaofooa.instance.Link;
import io.ciera.tool.sql.ooaofooa.instance.LinkParticipationSet;
import io.ciera.tool.sql.ooaofooa.instance.LinkSet;
import io.ciera.tool.sql.ooaofooa.instance.impl.LinkParticipationSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class LinkSetImpl extends InstanceSet<LinkSet,Link> implements LinkSet {

    public LinkSetImpl() {
    }

    public LinkSetImpl(Comparator<? super Link> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setFromInst_ID( UniqueId ref_fromInst_ID ) throws XtumlException {
        for ( Link link : this ) link.setFromInst_ID( ref_fromInst_ID );
    }
    @Override
    public void setRel_ID( UniqueId ref_Rel_ID ) throws XtumlException {
        for ( Link link : this ) link.setRel_ID( ref_Rel_ID );
    }
    @Override
    public void setAssocInst_ID( UniqueId ref_assocInst_ID ) throws XtumlException {
        for ( Link link : this ) link.setAssocInst_ID( ref_assocInst_ID );
    }
    @Override
    public void setLink_ID( UniqueId m_Link_ID ) throws XtumlException {
        for ( Link link : this ) link.setLink_ID( m_Link_ID );
    }
    @Override
    public void setToInst_ID( UniqueId ref_toInst_ID ) throws XtumlException {
        for ( Link link : this ) link.setToInst_ID( ref_toInst_ID );
    }


    // selections
    @Override
    public LinkParticipationSet R2901_originates_at_LinkParticipation() throws XtumlException {
        LinkParticipationSet linkparticipationset = new LinkParticipationSetImpl();
        for ( Link link : this ) linkparticipationset.add( link.R2901_originates_at_LinkParticipation() );
        return linkparticipationset;
    }
    @Override
    public LinkParticipationSet R2902_ends_at_LinkParticipation() throws XtumlException {
        LinkParticipationSet linkparticipationset = new LinkParticipationSetImpl();
        for ( Link link : this ) linkparticipationset.add( link.R2902_ends_at_LinkParticipation() );
        return linkparticipationset;
    }
    @Override
    public LinkParticipationSet R2903_has_associator_LinkParticipation() throws XtumlException {
        LinkParticipationSet linkparticipationset = new LinkParticipationSetImpl();
        for ( Link link : this ) linkparticipationset.add( link.R2903_has_associator_LinkParticipation() );
        return linkparticipationset;
    }
    @Override
    public AssociationSet R2904_is_instance_of_Association() throws XtumlException {
        AssociationSet associationset = new AssociationSetImpl();
        for ( Link link : this ) associationset.add( link.R2904_is_instance_of_Association() );
        return associationset;
    }


    @Override
    public Link nullElement() {
        return LinkImpl.EMPTY_LINK;
    }

    @Override
    public LinkSet emptySet() {
      return new LinkSetImpl();
    }

    @Override
    public LinkSet emptySet(Comparator<? super Link> comp) {
      return new LinkSetImpl(comp);
    }

    @Override
    public List<Link> elements() {
        return Arrays.asList(toArray(new Link[0]));
    }

}
