package io.ciera.tool.sql.ooaofooa.instance.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.instance.ComponentInstance;
import io.ciera.tool.sql.ooaofooa.instance.EventQueueEntry;
import io.ciera.tool.sql.ooaofooa.instance.PendingEvent;
import io.ciera.tool.sql.ooaofooa.instance.impl.ComponentInstanceImpl;
import io.ciera.tool.sql.ooaofooa.instance.impl.EventQueueEntryImpl;
import io.ciera.tool.sql.ooaofooa.instance.impl.PendingEventImpl;


public class EventQueueEntryImpl extends ModelInstance<EventQueueEntry,Sql> implements EventQueueEntry {

    public static final String KEY_LETTERS = "I_EQE";
    public static final EventQueueEntry EMPTY_EVENTQUEUEENTRY = new EmptyEventQueueEntry();

    private Sql context;

    // constructors
    private EventQueueEntryImpl( Sql context ) {
        this.context = context;
        m_Event_Queue_Entry_ID = UniqueId.random();
        ref_Execution_Engine_ID = UniqueId.random();
        ref_Event_ID = UniqueId.random();
        ref_Next_Event_Queue_Entry_ID = UniqueId.random();
        R2944_ComponentInstance_inst = ComponentInstanceImpl.EMPTY_COMPONENTINSTANCE;
        R2944_PendingEvent_inst = PendingEventImpl.EMPTY_PENDINGEVENT;
        R2945_follows_EventQueueEntry_inst = EventQueueEntryImpl.EMPTY_EVENTQUEUEENTRY;
        R2945_precedes_EventQueueEntry_inst = EventQueueEntryImpl.EMPTY_EVENTQUEUEENTRY;
    }

    private EventQueueEntryImpl( Sql context, UniqueId instanceId, UniqueId m_Event_Queue_Entry_ID, UniqueId ref_Execution_Engine_ID, UniqueId ref_Event_ID, UniqueId ref_Next_Event_Queue_Entry_ID ) {
        super(instanceId);
        this.context = context;
        this.m_Event_Queue_Entry_ID = m_Event_Queue_Entry_ID;
        this.ref_Execution_Engine_ID = ref_Execution_Engine_ID;
        this.ref_Event_ID = ref_Event_ID;
        this.ref_Next_Event_Queue_Entry_ID = ref_Next_Event_Queue_Entry_ID;
        R2944_ComponentInstance_inst = ComponentInstanceImpl.EMPTY_COMPONENTINSTANCE;
        R2944_PendingEvent_inst = PendingEventImpl.EMPTY_PENDINGEVENT;
        R2945_follows_EventQueueEntry_inst = EventQueueEntryImpl.EMPTY_EVENTQUEUEENTRY;
        R2945_precedes_EventQueueEntry_inst = EventQueueEntryImpl.EMPTY_EVENTQUEUEENTRY;
    }

    public static EventQueueEntry create( Sql context ) throws XtumlException {
        EventQueueEntry newEventQueueEntry = new EventQueueEntryImpl( context );
        if ( context.addInstance( newEventQueueEntry ) ) {
            newEventQueueEntry.getRunContext().addChange(new InstanceCreatedDelta(newEventQueueEntry, KEY_LETTERS));
            return newEventQueueEntry;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static EventQueueEntry create( Sql context, UniqueId m_Event_Queue_Entry_ID, UniqueId ref_Execution_Engine_ID, UniqueId ref_Event_ID, UniqueId ref_Next_Event_Queue_Entry_ID ) throws XtumlException {
        return create(context, UniqueId.random(), m_Event_Queue_Entry_ID, ref_Execution_Engine_ID, ref_Event_ID, ref_Next_Event_Queue_Entry_ID);
    }

    public static EventQueueEntry create( Sql context, UniqueId instanceId, UniqueId m_Event_Queue_Entry_ID, UniqueId ref_Execution_Engine_ID, UniqueId ref_Event_ID, UniqueId ref_Next_Event_Queue_Entry_ID ) throws XtumlException {
        EventQueueEntry newEventQueueEntry = new EventQueueEntryImpl( context, instanceId, m_Event_Queue_Entry_ID, ref_Execution_Engine_ID, ref_Event_ID, ref_Next_Event_Queue_Entry_ID );
        if ( context.addInstance( newEventQueueEntry ) ) {
            return newEventQueueEntry;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Event_Queue_Entry_ID;
    @Override
    public UniqueId getEvent_Queue_Entry_ID() throws XtumlException {
        checkLiving();
        return m_Event_Queue_Entry_ID;
    }
    @Override
    public void setEvent_Queue_Entry_ID(UniqueId m_Event_Queue_Entry_ID) throws XtumlException {
        checkLiving();
        if (m_Event_Queue_Entry_ID.inequality( this.m_Event_Queue_Entry_ID)) {
            final UniqueId oldValue = this.m_Event_Queue_Entry_ID;
            this.m_Event_Queue_Entry_ID = m_Event_Queue_Entry_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Event_Queue_Entry_ID", oldValue, this.m_Event_Queue_Entry_ID));
            if ( !R2945_precedes_EventQueueEntry().isEmpty() ) R2945_precedes_EventQueueEntry().setNext_Event_Queue_Entry_ID( m_Event_Queue_Entry_ID );
        }
    }
    private UniqueId ref_Execution_Engine_ID;
    @Override
    public void setExecution_Engine_ID(UniqueId ref_Execution_Engine_ID) throws XtumlException {
        checkLiving();
        if (ref_Execution_Engine_ID.inequality( this.ref_Execution_Engine_ID)) {
            final UniqueId oldValue = this.ref_Execution_Engine_ID;
            this.ref_Execution_Engine_ID = ref_Execution_Engine_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Execution_Engine_ID", oldValue, this.ref_Execution_Engine_ID));
        }
    }
    @Override
    public UniqueId getExecution_Engine_ID() throws XtumlException {
        checkLiving();
        return ref_Execution_Engine_ID;
    }
    private UniqueId ref_Event_ID;
    @Override
    public void setEvent_ID(UniqueId ref_Event_ID) throws XtumlException {
        checkLiving();
        if (ref_Event_ID.inequality( this.ref_Event_ID)) {
            final UniqueId oldValue = this.ref_Event_ID;
            this.ref_Event_ID = ref_Event_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Event_ID", oldValue, this.ref_Event_ID));
        }
    }
    @Override
    public UniqueId getEvent_ID() throws XtumlException {
        checkLiving();
        return ref_Event_ID;
    }
    private UniqueId ref_Next_Event_Queue_Entry_ID;
    @Override
    public UniqueId getNext_Event_Queue_Entry_ID() throws XtumlException {
        checkLiving();
        return ref_Next_Event_Queue_Entry_ID;
    }
    @Override
    public void setNext_Event_Queue_Entry_ID(UniqueId ref_Next_Event_Queue_Entry_ID) throws XtumlException {
        checkLiving();
        if (ref_Next_Event_Queue_Entry_ID.inequality( this.ref_Next_Event_Queue_Entry_ID)) {
            final UniqueId oldValue = this.ref_Next_Event_Queue_Entry_ID;
            this.ref_Next_Event_Queue_Entry_ID = ref_Next_Event_Queue_Entry_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Next_Event_Queue_Entry_ID", oldValue, this.ref_Next_Event_Queue_Entry_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getEvent_Queue_Entry_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ComponentInstance R2944_ComponentInstance_inst;
    @Override
    public void setR2944_ComponentInstance( ComponentInstance inst ) {
        R2944_ComponentInstance_inst = inst;
    }
    @Override
    public ComponentInstance R2944_ComponentInstance() throws XtumlException {
        return R2944_ComponentInstance_inst;
    }
    private PendingEvent R2944_PendingEvent_inst;
    @Override
    public void setR2944_PendingEvent( PendingEvent inst ) {
        R2944_PendingEvent_inst = inst;
    }
    @Override
    public PendingEvent R2944_PendingEvent() throws XtumlException {
        return R2944_PendingEvent_inst;
    }
    private EventQueueEntry R2945_follows_EventQueueEntry_inst;
    @Override
    public void setR2945_follows_EventQueueEntry( EventQueueEntry inst ) {
        R2945_follows_EventQueueEntry_inst = inst;
    }
    @Override
    public EventQueueEntry R2945_follows_EventQueueEntry() throws XtumlException {
        return R2945_follows_EventQueueEntry_inst;
    }
    private EventQueueEntry R2945_precedes_EventQueueEntry_inst;
    @Override
    public void setR2945_precedes_EventQueueEntry( EventQueueEntry inst ) {
        R2945_precedes_EventQueueEntry_inst = inst;
    }
    @Override
    public EventQueueEntry R2945_precedes_EventQueueEntry() throws XtumlException {
        return R2945_precedes_EventQueueEntry_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public EventQueueEntry self() {
        return this;
    }

    @Override
    public EventQueueEntry oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_EVENTQUEUEENTRY;
    }

}

class EmptyEventQueueEntry extends ModelInstance<EventQueueEntry,Sql> implements EventQueueEntry {

    // attributes
    public UniqueId getEvent_Queue_Entry_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setEvent_Queue_Entry_ID( UniqueId m_Event_Queue_Entry_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setExecution_Engine_ID( UniqueId ref_Execution_Engine_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getExecution_Engine_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setEvent_ID( UniqueId ref_Event_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getEvent_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getNext_Event_Queue_Entry_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setNext_Event_Queue_Entry_ID( UniqueId ref_Next_Event_Queue_Entry_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ComponentInstance R2944_ComponentInstance() {
        return ComponentInstanceImpl.EMPTY_COMPONENTINSTANCE;
    }
    @Override
    public PendingEvent R2944_PendingEvent() {
        return PendingEventImpl.EMPTY_PENDINGEVENT;
    }
    @Override
    public EventQueueEntry R2945_follows_EventQueueEntry() {
        return EventQueueEntryImpl.EMPTY_EVENTQUEUEENTRY;
    }
    @Override
    public EventQueueEntry R2945_precedes_EventQueueEntry() {
        return EventQueueEntryImpl.EMPTY_EVENTQUEUEENTRY;
    }


    @Override
    public String getKeyLetters() {
        return EventQueueEntryImpl.KEY_LETTERS;
    }

    @Override
    public EventQueueEntry self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public EventQueueEntry oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return EventQueueEntryImpl.EMPTY_EVENTQUEUEENTRY;
    }

}
