package io.ciera.tool.sql.ooaofooa.event.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.ACT_SMT;
import io.ciera.tool.sql.ooaofooa.body.impl.ACT_SMTImpl;
import io.ciera.tool.sql.ooaofooa.event.GeneratePreexistingEvent;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class GeneratePreexistingEventImpl extends ModelInstance<GeneratePreexistingEvent,Sql> implements GeneratePreexistingEvent {

    public static final String KEY_LETTERS = "E_GPR";
    public static final GeneratePreexistingEvent EMPTY_GENERATEPREEXISTINGEVENT = new EmptyGeneratePreexistingEvent();

    private Sql context;

    // constructors
    private GeneratePreexistingEventImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        ref_Value_ID = UniqueId.random();
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R714_generates_event_held_by_Value_inst = ValueImpl.EMPTY_VALUE;
    }

    private GeneratePreexistingEventImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Value_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        this.ref_Value_ID = ref_Value_ID;
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R714_generates_event_held_by_Value_inst = ValueImpl.EMPTY_VALUE;
    }

    public static GeneratePreexistingEvent create( Sql context ) throws XtumlException {
        GeneratePreexistingEvent newGeneratePreexistingEvent = new GeneratePreexistingEventImpl( context );
        if ( context.addInstance( newGeneratePreexistingEvent ) ) {
            newGeneratePreexistingEvent.getRunContext().addChange(new InstanceCreatedDelta(newGeneratePreexistingEvent, KEY_LETTERS));
            return newGeneratePreexistingEvent;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static GeneratePreexistingEvent create( Sql context, UniqueId ref_Statement_ID, UniqueId ref_Value_ID ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Statement_ID, ref_Value_ID);
    }

    public static GeneratePreexistingEvent create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Value_ID ) throws XtumlException {
        GeneratePreexistingEvent newGeneratePreexistingEvent = new GeneratePreexistingEventImpl( context, instanceId, ref_Statement_ID, ref_Value_ID );
        if ( context.addInstance( newGeneratePreexistingEvent ) ) {
            return newGeneratePreexistingEvent;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
        return ref_Statement_ID;
    }
    @Override
    public void setStatement_ID(UniqueId ref_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_Statement_ID.inequality( this.ref_Statement_ID)) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
        }
    }
    private UniqueId ref_Value_ID;
    @Override
    public void setValue_ID(UniqueId ref_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Value_ID.inequality( this.ref_Value_ID)) {
            final UniqueId oldValue = this.ref_Value_ID;
            this.ref_Value_ID = ref_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Value_ID", oldValue, this.ref_Value_ID));
        }
    }
    @Override
    public UniqueId getValue_ID() throws XtumlException {
        checkLiving();
        return ref_Value_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ACT_SMT R603_is_a_ACT_SMT_inst;
    @Override
    public void setR603_is_a_ACT_SMT( ACT_SMT inst ) {
        R603_is_a_ACT_SMT_inst = inst;
    }
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() throws XtumlException {
        return R603_is_a_ACT_SMT_inst;
    }
    private Value R714_generates_event_held_by_Value_inst;
    @Override
    public void setR714_generates_event_held_by_Value( Value inst ) {
        R714_generates_event_held_by_Value_inst = inst;
    }
    @Override
    public Value R714_generates_event_held_by_Value() throws XtumlException {
        return R714_generates_event_held_by_Value_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public GeneratePreexistingEvent self() {
        return this;
    }

    @Override
    public GeneratePreexistingEvent oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_GENERATEPREEXISTINGEVENT;
    }

}

class EmptyGeneratePreexistingEvent extends ModelInstance<GeneratePreexistingEvent,Sql> implements GeneratePreexistingEvent {

    // attributes
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() {
        return ACT_SMTImpl.EMPTY_ACT_SMT;
    }
    @Override
    public Value R714_generates_event_held_by_Value() {
        return ValueImpl.EMPTY_VALUE;
    }


    @Override
    public String getKeyLetters() {
        return GeneratePreexistingEventImpl.KEY_LETTERS;
    }

    @Override
    public GeneratePreexistingEvent self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public GeneratePreexistingEvent oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return GeneratePreexistingEventImpl.EMPTY_GENERATEPREEXISTINGEVENT;
    }

}
