package io.ciera.tool.sql.ooaofooa.event.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.ACT_SMT;
import io.ciera.tool.sql.ooaofooa.body.impl.ACT_SMTImpl;
import io.ciera.tool.sql.ooaofooa.event.CreateEventStatement;
import io.ciera.tool.sql.ooaofooa.event.EventSpecificationStatement;
import io.ciera.tool.sql.ooaofooa.event.GenerateEventStatement;
import io.ciera.tool.sql.ooaofooa.event.impl.CreateEventStatementImpl;
import io.ciera.tool.sql.ooaofooa.event.impl.GenerateEventStatementImpl;
import io.ciera.tool.sql.ooaofooa.value.V_PAR;
import io.ciera.tool.sql.ooaofooa.value.V_PARSet;
import io.ciera.tool.sql.ooaofooa.value.impl.V_PARSetImpl;


public class EventSpecificationStatementImpl extends ModelInstance<EventSpecificationStatement,Sql> implements EventSpecificationStatement {

    public static final String KEY_LETTERS = "E_ESS";
    public static final EventSpecificationStatement EMPTY_EVENTSPECIFICATIONSTATEMENT = new EmptyEventSpecificationStatement();

    private Sql context;

    // constructors
    private EventSpecificationStatementImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        m_ParmListOK = false;
        m_PEIndicated = false;
        m_eventDerivedLabelLineNumber = 0;
        m_eventDerivedLabelColumn = 0;
        m_eventMeaningLineNumber = 0;
        m_eventMeaningColumn = 0;
        m_eventTargetKeyLettersLineNumber = 0;
        m_eventTargetKeyLettersColumn = 0;
        m_firstEventDataItemNameLineNumber = 0;
        m_firstEventDataItemNameColumn = 0;
        m_currentLaterEventDataItemNameLineNumber = 0;
        m_currentLaterEventDataItemNameColumn = 0;
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R700_V_PAR_set = new V_PARSetImpl();
        R701_is_a_CreateEventStatement_inst = CreateEventStatementImpl.EMPTY_CREATEEVENTSTATEMENT;
        R701_is_a_GenerateEventStatement_inst = GenerateEventStatementImpl.EMPTY_GENERATEEVENTSTATEMENT;
    }

    private EventSpecificationStatementImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, boolean m_ParmListOK, boolean m_PEIndicated, int m_eventDerivedLabelLineNumber, int m_eventDerivedLabelColumn, int m_eventMeaningLineNumber, int m_eventMeaningColumn, int m_eventTargetKeyLettersLineNumber, int m_eventTargetKeyLettersColumn, int m_firstEventDataItemNameLineNumber, int m_firstEventDataItemNameColumn, int m_currentLaterEventDataItemNameLineNumber, int m_currentLaterEventDataItemNameColumn ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        this.m_ParmListOK = m_ParmListOK;
        this.m_PEIndicated = m_PEIndicated;
        this.m_eventDerivedLabelLineNumber = m_eventDerivedLabelLineNumber;
        this.m_eventDerivedLabelColumn = m_eventDerivedLabelColumn;
        this.m_eventMeaningLineNumber = m_eventMeaningLineNumber;
        this.m_eventMeaningColumn = m_eventMeaningColumn;
        this.m_eventTargetKeyLettersLineNumber = m_eventTargetKeyLettersLineNumber;
        this.m_eventTargetKeyLettersColumn = m_eventTargetKeyLettersColumn;
        this.m_firstEventDataItemNameLineNumber = m_firstEventDataItemNameLineNumber;
        this.m_firstEventDataItemNameColumn = m_firstEventDataItemNameColumn;
        this.m_currentLaterEventDataItemNameLineNumber = m_currentLaterEventDataItemNameLineNumber;
        this.m_currentLaterEventDataItemNameColumn = m_currentLaterEventDataItemNameColumn;
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R700_V_PAR_set = new V_PARSetImpl();
        R701_is_a_CreateEventStatement_inst = CreateEventStatementImpl.EMPTY_CREATEEVENTSTATEMENT;
        R701_is_a_GenerateEventStatement_inst = GenerateEventStatementImpl.EMPTY_GENERATEEVENTSTATEMENT;
    }

    public static EventSpecificationStatement create( Sql context ) throws XtumlException {
        EventSpecificationStatement newEventSpecificationStatement = new EventSpecificationStatementImpl( context );
        if ( context.addInstance( newEventSpecificationStatement ) ) {
            newEventSpecificationStatement.getRunContext().addChange(new InstanceCreatedDelta(newEventSpecificationStatement, KEY_LETTERS));
            return newEventSpecificationStatement;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static EventSpecificationStatement create( Sql context, UniqueId ref_Statement_ID, boolean m_ParmListOK, boolean m_PEIndicated, int m_eventDerivedLabelLineNumber, int m_eventDerivedLabelColumn, int m_eventMeaningLineNumber, int m_eventMeaningColumn, int m_eventTargetKeyLettersLineNumber, int m_eventTargetKeyLettersColumn, int m_firstEventDataItemNameLineNumber, int m_firstEventDataItemNameColumn, int m_currentLaterEventDataItemNameLineNumber, int m_currentLaterEventDataItemNameColumn ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Statement_ID, m_ParmListOK, m_PEIndicated, m_eventDerivedLabelLineNumber, m_eventDerivedLabelColumn, m_eventMeaningLineNumber, m_eventMeaningColumn, m_eventTargetKeyLettersLineNumber, m_eventTargetKeyLettersColumn, m_firstEventDataItemNameLineNumber, m_firstEventDataItemNameColumn, m_currentLaterEventDataItemNameLineNumber, m_currentLaterEventDataItemNameColumn);
    }

    public static EventSpecificationStatement create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, boolean m_ParmListOK, boolean m_PEIndicated, int m_eventDerivedLabelLineNumber, int m_eventDerivedLabelColumn, int m_eventMeaningLineNumber, int m_eventMeaningColumn, int m_eventTargetKeyLettersLineNumber, int m_eventTargetKeyLettersColumn, int m_firstEventDataItemNameLineNumber, int m_firstEventDataItemNameColumn, int m_currentLaterEventDataItemNameLineNumber, int m_currentLaterEventDataItemNameColumn ) throws XtumlException {
        EventSpecificationStatement newEventSpecificationStatement = new EventSpecificationStatementImpl( context, instanceId, ref_Statement_ID, m_ParmListOK, m_PEIndicated, m_eventDerivedLabelLineNumber, m_eventDerivedLabelColumn, m_eventMeaningLineNumber, m_eventMeaningColumn, m_eventTargetKeyLettersLineNumber, m_eventTargetKeyLettersColumn, m_firstEventDataItemNameLineNumber, m_firstEventDataItemNameColumn, m_currentLaterEventDataItemNameLineNumber, m_currentLaterEventDataItemNameColumn );
        if ( context.addInstance( newEventSpecificationStatement ) ) {
            return newEventSpecificationStatement;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
        return ref_Statement_ID;
    }
    @Override
    public void setStatement_ID(UniqueId ref_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_Statement_ID.inequality( this.ref_Statement_ID)) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
            if ( !R701_is_a_GenerateEventStatement().isEmpty() ) R701_is_a_GenerateEventStatement().setStatement_ID( ref_Statement_ID );
            if ( !R701_is_a_CreateEventStatement().isEmpty() ) R701_is_a_CreateEventStatement().setStatement_ID( ref_Statement_ID );
            if ( !R700_V_PAR().isEmpty() ) R700_V_PAR().setStatement_ID( ref_Statement_ID );
        }
    }
    private boolean m_ParmListOK;
    @Override
    public void setParmListOK(boolean m_ParmListOK) throws XtumlException {
        checkLiving();
        if (m_ParmListOK != this.m_ParmListOK) {
            final boolean oldValue = this.m_ParmListOK;
            this.m_ParmListOK = m_ParmListOK;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_ParmListOK", oldValue, this.m_ParmListOK));
        }
    }
    @Override
    public boolean getParmListOK() throws XtumlException {
        checkLiving();
        return m_ParmListOK;
    }
    private boolean m_PEIndicated;
    @Override
    public void setPEIndicated(boolean m_PEIndicated) throws XtumlException {
        checkLiving();
        if (m_PEIndicated != this.m_PEIndicated) {
            final boolean oldValue = this.m_PEIndicated;
            this.m_PEIndicated = m_PEIndicated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_PEIndicated", oldValue, this.m_PEIndicated));
        }
    }
    @Override
    public boolean getPEIndicated() throws XtumlException {
        checkLiving();
        return m_PEIndicated;
    }
    private int m_eventDerivedLabelLineNumber;
    @Override
    public void setEventDerivedLabelLineNumber(int m_eventDerivedLabelLineNumber) throws XtumlException {
        checkLiving();
        if (m_eventDerivedLabelLineNumber != this.m_eventDerivedLabelLineNumber) {
            final int oldValue = this.m_eventDerivedLabelLineNumber;
            this.m_eventDerivedLabelLineNumber = m_eventDerivedLabelLineNumber;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_eventDerivedLabelLineNumber", oldValue, this.m_eventDerivedLabelLineNumber));
        }
    }
    @Override
    public int getEventDerivedLabelLineNumber() throws XtumlException {
        checkLiving();
        return m_eventDerivedLabelLineNumber;
    }
    private int m_eventDerivedLabelColumn;
    @Override
    public void setEventDerivedLabelColumn(int m_eventDerivedLabelColumn) throws XtumlException {
        checkLiving();
        if (m_eventDerivedLabelColumn != this.m_eventDerivedLabelColumn) {
            final int oldValue = this.m_eventDerivedLabelColumn;
            this.m_eventDerivedLabelColumn = m_eventDerivedLabelColumn;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_eventDerivedLabelColumn", oldValue, this.m_eventDerivedLabelColumn));
        }
    }
    @Override
    public int getEventDerivedLabelColumn() throws XtumlException {
        checkLiving();
        return m_eventDerivedLabelColumn;
    }
    private int m_eventMeaningLineNumber;
    @Override
    public void setEventMeaningLineNumber(int m_eventMeaningLineNumber) throws XtumlException {
        checkLiving();
        if (m_eventMeaningLineNumber != this.m_eventMeaningLineNumber) {
            final int oldValue = this.m_eventMeaningLineNumber;
            this.m_eventMeaningLineNumber = m_eventMeaningLineNumber;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_eventMeaningLineNumber", oldValue, this.m_eventMeaningLineNumber));
        }
    }
    @Override
    public int getEventMeaningLineNumber() throws XtumlException {
        checkLiving();
        return m_eventMeaningLineNumber;
    }
    private int m_eventMeaningColumn;
    @Override
    public void setEventMeaningColumn(int m_eventMeaningColumn) throws XtumlException {
        checkLiving();
        if (m_eventMeaningColumn != this.m_eventMeaningColumn) {
            final int oldValue = this.m_eventMeaningColumn;
            this.m_eventMeaningColumn = m_eventMeaningColumn;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_eventMeaningColumn", oldValue, this.m_eventMeaningColumn));
        }
    }
    @Override
    public int getEventMeaningColumn() throws XtumlException {
        checkLiving();
        return m_eventMeaningColumn;
    }
    private int m_eventTargetKeyLettersLineNumber;
    @Override
    public int getEventTargetKeyLettersLineNumber() throws XtumlException {
        checkLiving();
        return m_eventTargetKeyLettersLineNumber;
    }
    @Override
    public void setEventTargetKeyLettersLineNumber(int m_eventTargetKeyLettersLineNumber) throws XtumlException {
        checkLiving();
        if (m_eventTargetKeyLettersLineNumber != this.m_eventTargetKeyLettersLineNumber) {
            final int oldValue = this.m_eventTargetKeyLettersLineNumber;
            this.m_eventTargetKeyLettersLineNumber = m_eventTargetKeyLettersLineNumber;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_eventTargetKeyLettersLineNumber", oldValue, this.m_eventTargetKeyLettersLineNumber));
        }
    }
    private int m_eventTargetKeyLettersColumn;
    @Override
    public int getEventTargetKeyLettersColumn() throws XtumlException {
        checkLiving();
        return m_eventTargetKeyLettersColumn;
    }
    @Override
    public void setEventTargetKeyLettersColumn(int m_eventTargetKeyLettersColumn) throws XtumlException {
        checkLiving();
        if (m_eventTargetKeyLettersColumn != this.m_eventTargetKeyLettersColumn) {
            final int oldValue = this.m_eventTargetKeyLettersColumn;
            this.m_eventTargetKeyLettersColumn = m_eventTargetKeyLettersColumn;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_eventTargetKeyLettersColumn", oldValue, this.m_eventTargetKeyLettersColumn));
        }
    }
    private int m_firstEventDataItemNameLineNumber;
    @Override
    public int getFirstEventDataItemNameLineNumber() throws XtumlException {
        checkLiving();
        return m_firstEventDataItemNameLineNumber;
    }
    @Override
    public void setFirstEventDataItemNameLineNumber(int m_firstEventDataItemNameLineNumber) throws XtumlException {
        checkLiving();
        if (m_firstEventDataItemNameLineNumber != this.m_firstEventDataItemNameLineNumber) {
            final int oldValue = this.m_firstEventDataItemNameLineNumber;
            this.m_firstEventDataItemNameLineNumber = m_firstEventDataItemNameLineNumber;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_firstEventDataItemNameLineNumber", oldValue, this.m_firstEventDataItemNameLineNumber));
        }
    }
    private int m_firstEventDataItemNameColumn;
    @Override
    public int getFirstEventDataItemNameColumn() throws XtumlException {
        checkLiving();
        return m_firstEventDataItemNameColumn;
    }
    @Override
    public void setFirstEventDataItemNameColumn(int m_firstEventDataItemNameColumn) throws XtumlException {
        checkLiving();
        if (m_firstEventDataItemNameColumn != this.m_firstEventDataItemNameColumn) {
            final int oldValue = this.m_firstEventDataItemNameColumn;
            this.m_firstEventDataItemNameColumn = m_firstEventDataItemNameColumn;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_firstEventDataItemNameColumn", oldValue, this.m_firstEventDataItemNameColumn));
        }
    }
    private int m_currentLaterEventDataItemNameLineNumber;
    @Override
    public void setCurrentLaterEventDataItemNameLineNumber(int m_currentLaterEventDataItemNameLineNumber) throws XtumlException {
        checkLiving();
        if (m_currentLaterEventDataItemNameLineNumber != this.m_currentLaterEventDataItemNameLineNumber) {
            final int oldValue = this.m_currentLaterEventDataItemNameLineNumber;
            this.m_currentLaterEventDataItemNameLineNumber = m_currentLaterEventDataItemNameLineNumber;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_currentLaterEventDataItemNameLineNumber", oldValue, this.m_currentLaterEventDataItemNameLineNumber));
        }
    }
    @Override
    public int getCurrentLaterEventDataItemNameLineNumber() throws XtumlException {
        checkLiving();
        return m_currentLaterEventDataItemNameLineNumber;
    }
    private int m_currentLaterEventDataItemNameColumn;
    @Override
    public int getCurrentLaterEventDataItemNameColumn() throws XtumlException {
        checkLiving();
        return m_currentLaterEventDataItemNameColumn;
    }
    @Override
    public void setCurrentLaterEventDataItemNameColumn(int m_currentLaterEventDataItemNameColumn) throws XtumlException {
        checkLiving();
        if (m_currentLaterEventDataItemNameColumn != this.m_currentLaterEventDataItemNameColumn) {
            final int oldValue = this.m_currentLaterEventDataItemNameColumn;
            this.m_currentLaterEventDataItemNameColumn = m_currentLaterEventDataItemNameColumn;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_currentLaterEventDataItemNameColumn", oldValue, this.m_currentLaterEventDataItemNameColumn));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ACT_SMT R603_is_a_ACT_SMT_inst;
    @Override
    public void setR603_is_a_ACT_SMT( ACT_SMT inst ) {
        R603_is_a_ACT_SMT_inst = inst;
    }
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() throws XtumlException {
        return R603_is_a_ACT_SMT_inst;
    }
    private V_PARSet R700_V_PAR_set;
    @Override
    public void addR700_V_PAR( V_PAR inst ) {
        R700_V_PAR_set.add(inst);
    }
    @Override
    public void removeR700_V_PAR( V_PAR inst ) {
        R700_V_PAR_set.remove(inst);
    }
    @Override
    public V_PARSet R700_V_PAR() throws XtumlException {
        return R700_V_PAR_set;
    }
    private CreateEventStatement R701_is_a_CreateEventStatement_inst;
    @Override
    public void setR701_is_a_CreateEventStatement( CreateEventStatement inst ) {
        R701_is_a_CreateEventStatement_inst = inst;
    }
    @Override
    public CreateEventStatement R701_is_a_CreateEventStatement() throws XtumlException {
        return R701_is_a_CreateEventStatement_inst;
    }
    private GenerateEventStatement R701_is_a_GenerateEventStatement_inst;
    @Override
    public void setR701_is_a_GenerateEventStatement( GenerateEventStatement inst ) {
        R701_is_a_GenerateEventStatement_inst = inst;
    }
    @Override
    public GenerateEventStatement R701_is_a_GenerateEventStatement() throws XtumlException {
        return R701_is_a_GenerateEventStatement_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public EventSpecificationStatement self() {
        return this;
    }

    @Override
    public EventSpecificationStatement oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_EVENTSPECIFICATIONSTATEMENT;
    }

}

class EmptyEventSpecificationStatement extends ModelInstance<EventSpecificationStatement,Sql> implements EventSpecificationStatement {

    // attributes
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setParmListOK( boolean m_ParmListOK ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getParmListOK() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPEIndicated( boolean m_PEIndicated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getPEIndicated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setEventDerivedLabelLineNumber( int m_eventDerivedLabelLineNumber ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getEventDerivedLabelLineNumber() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setEventDerivedLabelColumn( int m_eventDerivedLabelColumn ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getEventDerivedLabelColumn() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setEventMeaningLineNumber( int m_eventMeaningLineNumber ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getEventMeaningLineNumber() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setEventMeaningColumn( int m_eventMeaningColumn ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getEventMeaningColumn() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public int getEventTargetKeyLettersLineNumber() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setEventTargetKeyLettersLineNumber( int m_eventTargetKeyLettersLineNumber ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getEventTargetKeyLettersColumn() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setEventTargetKeyLettersColumn( int m_eventTargetKeyLettersColumn ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getFirstEventDataItemNameLineNumber() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setFirstEventDataItemNameLineNumber( int m_firstEventDataItemNameLineNumber ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getFirstEventDataItemNameColumn() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setFirstEventDataItemNameColumn( int m_firstEventDataItemNameColumn ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setCurrentLaterEventDataItemNameLineNumber( int m_currentLaterEventDataItemNameLineNumber ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getCurrentLaterEventDataItemNameLineNumber() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public int getCurrentLaterEventDataItemNameColumn() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setCurrentLaterEventDataItemNameColumn( int m_currentLaterEventDataItemNameColumn ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() {
        return ACT_SMTImpl.EMPTY_ACT_SMT;
    }
    @Override
    public V_PARSet R700_V_PAR() {
        return (new V_PARSetImpl());
    }
    @Override
    public CreateEventStatement R701_is_a_CreateEventStatement() {
        return CreateEventStatementImpl.EMPTY_CREATEEVENTSTATEMENT;
    }
    @Override
    public GenerateEventStatement R701_is_a_GenerateEventStatement() {
        return GenerateEventStatementImpl.EMPTY_GENERATEEVENTSTATEMENT;
    }


    @Override
    public String getKeyLetters() {
        return EventSpecificationStatementImpl.KEY_LETTERS;
    }

    @Override
    public EventSpecificationStatement self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public EventSpecificationStatement oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return EventSpecificationStatementImpl.EMPTY_EVENTSPECIFICATIONSTATEMENT;
    }

}
