package io.ciera.tool.sql.ooaofooa.event.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.event.CreateEventStatement;
import io.ciera.tool.sql.ooaofooa.event.CreateEventToClass;
import io.ciera.tool.sql.ooaofooa.event.CreateEventToCreator;
import io.ciera.tool.sql.ooaofooa.event.CreateEventToInstance;
import io.ciera.tool.sql.ooaofooa.event.CreateSMEventStatement;
import io.ciera.tool.sql.ooaofooa.event.impl.CreateEventStatementImpl;
import io.ciera.tool.sql.ooaofooa.event.impl.CreateEventToClassImpl;
import io.ciera.tool.sql.ooaofooa.event.impl.CreateEventToCreatorImpl;
import io.ciera.tool.sql.ooaofooa.event.impl.CreateEventToInstanceImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.StateMachineEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.StateMachineEventImpl;


public class CreateSMEventStatementImpl extends ModelInstance<CreateSMEventStatement,Sql> implements CreateSMEventStatement {

    public static final String KEY_LETTERS = "E_CSME";
    public static final CreateSMEventStatement EMPTY_CREATESMEVENTSTATEMENT = new EmptyCreateSMEventStatement();

    private Sql context;

    // constructors
    private CreateSMEventStatementImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        ref_SMevt_ID = UniqueId.random();
        R702_is_a_CreateEventStatement_inst = CreateEventStatementImpl.EMPTY_CREATEEVENTSTATEMENT;
        R704_is_a_CreateEventToClass_inst = CreateEventToClassImpl.EMPTY_CREATEEVENTTOCLASS;
        R704_is_a_CreateEventToCreator_inst = CreateEventToCreatorImpl.EMPTY_CREATEEVENTTOCREATOR;
        R704_is_a_CreateEventToInstance_inst = CreateEventToInstanceImpl.EMPTY_CREATEEVENTTOINSTANCE;
        R706_creates_StateMachineEvent_inst = StateMachineEventImpl.EMPTY_STATEMACHINEEVENT;
    }

    private CreateSMEventStatementImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_SMevt_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        this.ref_SMevt_ID = ref_SMevt_ID;
        R702_is_a_CreateEventStatement_inst = CreateEventStatementImpl.EMPTY_CREATEEVENTSTATEMENT;
        R704_is_a_CreateEventToClass_inst = CreateEventToClassImpl.EMPTY_CREATEEVENTTOCLASS;
        R704_is_a_CreateEventToCreator_inst = CreateEventToCreatorImpl.EMPTY_CREATEEVENTTOCREATOR;
        R704_is_a_CreateEventToInstance_inst = CreateEventToInstanceImpl.EMPTY_CREATEEVENTTOINSTANCE;
        R706_creates_StateMachineEvent_inst = StateMachineEventImpl.EMPTY_STATEMACHINEEVENT;
    }

    public static CreateSMEventStatement create( Sql context ) throws XtumlException {
        CreateSMEventStatement newCreateSMEventStatement = new CreateSMEventStatementImpl( context );
        if ( context.addInstance( newCreateSMEventStatement ) ) {
            newCreateSMEventStatement.getRunContext().addChange(new InstanceCreatedDelta(newCreateSMEventStatement, KEY_LETTERS));
            return newCreateSMEventStatement;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static CreateSMEventStatement create( Sql context, UniqueId ref_Statement_ID, UniqueId ref_SMevt_ID ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Statement_ID, ref_SMevt_ID);
    }

    public static CreateSMEventStatement create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_SMevt_ID ) throws XtumlException {
        CreateSMEventStatement newCreateSMEventStatement = new CreateSMEventStatementImpl( context, instanceId, ref_Statement_ID, ref_SMevt_ID );
        if ( context.addInstance( newCreateSMEventStatement ) ) {
            return newCreateSMEventStatement;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public void setStatement_ID(UniqueId ref_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_Statement_ID.inequality( this.ref_Statement_ID)) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
            if ( !R704_is_a_CreateEventToClass().isEmpty() ) R704_is_a_CreateEventToClass().setStatement_ID( ref_Statement_ID );
            if ( !R704_is_a_CreateEventToCreator().isEmpty() ) R704_is_a_CreateEventToCreator().setStatement_ID( ref_Statement_ID );
            if ( !R704_is_a_CreateEventToInstance().isEmpty() ) R704_is_a_CreateEventToInstance().setStatement_ID( ref_Statement_ID );
        }
    }
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
        return ref_Statement_ID;
    }
    private UniqueId ref_SMevt_ID;
    @Override
    public UniqueId getSMevt_ID() throws XtumlException {
        checkLiving();
        return ref_SMevt_ID;
    }
    @Override
    public void setSMevt_ID(UniqueId ref_SMevt_ID) throws XtumlException {
        checkLiving();
        if (ref_SMevt_ID.inequality( this.ref_SMevt_ID)) {
            final UniqueId oldValue = this.ref_SMevt_ID;
            this.ref_SMevt_ID = ref_SMevt_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SMevt_ID", oldValue, this.ref_SMevt_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private CreateEventStatement R702_is_a_CreateEventStatement_inst;
    @Override
    public void setR702_is_a_CreateEventStatement( CreateEventStatement inst ) {
        R702_is_a_CreateEventStatement_inst = inst;
    }
    @Override
    public CreateEventStatement R702_is_a_CreateEventStatement() throws XtumlException {
        return R702_is_a_CreateEventStatement_inst;
    }
    private CreateEventToClass R704_is_a_CreateEventToClass_inst;
    @Override
    public void setR704_is_a_CreateEventToClass( CreateEventToClass inst ) {
        R704_is_a_CreateEventToClass_inst = inst;
    }
    @Override
    public CreateEventToClass R704_is_a_CreateEventToClass() throws XtumlException {
        return R704_is_a_CreateEventToClass_inst;
    }
    private CreateEventToCreator R704_is_a_CreateEventToCreator_inst;
    @Override
    public void setR704_is_a_CreateEventToCreator( CreateEventToCreator inst ) {
        R704_is_a_CreateEventToCreator_inst = inst;
    }
    @Override
    public CreateEventToCreator R704_is_a_CreateEventToCreator() throws XtumlException {
        return R704_is_a_CreateEventToCreator_inst;
    }
    private CreateEventToInstance R704_is_a_CreateEventToInstance_inst;
    @Override
    public void setR704_is_a_CreateEventToInstance( CreateEventToInstance inst ) {
        R704_is_a_CreateEventToInstance_inst = inst;
    }
    @Override
    public CreateEventToInstance R704_is_a_CreateEventToInstance() throws XtumlException {
        return R704_is_a_CreateEventToInstance_inst;
    }
    private StateMachineEvent R706_creates_StateMachineEvent_inst;
    @Override
    public void setR706_creates_StateMachineEvent( StateMachineEvent inst ) {
        R706_creates_StateMachineEvent_inst = inst;
    }
    @Override
    public StateMachineEvent R706_creates_StateMachineEvent() throws XtumlException {
        return R706_creates_StateMachineEvent_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public CreateSMEventStatement self() {
        return this;
    }

    @Override
    public CreateSMEventStatement oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_CREATESMEVENTSTATEMENT;
    }

}

class EmptyCreateSMEventStatement extends ModelInstance<CreateSMEventStatement,Sql> implements CreateSMEventStatement {

    // attributes
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getSMevt_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSMevt_ID( UniqueId ref_SMevt_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public CreateEventStatement R702_is_a_CreateEventStatement() {
        return CreateEventStatementImpl.EMPTY_CREATEEVENTSTATEMENT;
    }
    @Override
    public CreateEventToClass R704_is_a_CreateEventToClass() {
        return CreateEventToClassImpl.EMPTY_CREATEEVENTTOCLASS;
    }
    @Override
    public CreateEventToCreator R704_is_a_CreateEventToCreator() {
        return CreateEventToCreatorImpl.EMPTY_CREATEEVENTTOCREATOR;
    }
    @Override
    public CreateEventToInstance R704_is_a_CreateEventToInstance() {
        return CreateEventToInstanceImpl.EMPTY_CREATEEVENTTOINSTANCE;
    }
    @Override
    public StateMachineEvent R706_creates_StateMachineEvent() {
        return StateMachineEventImpl.EMPTY_STATEMACHINEEVENT;
    }


    @Override
    public String getKeyLetters() {
        return CreateSMEventStatementImpl.KEY_LETTERS;
    }

    @Override
    public CreateSMEventStatement self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public CreateSMEventStatement oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return CreateSMEventStatementImpl.EMPTY_CREATESMEVENTSTATEMENT;
    }

}
