package io.ciera.tool.sql.ooaofooa.event.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.event.CreateEventStatement;
import io.ciera.tool.sql.ooaofooa.event.CreateSMEventStatement;
import io.ciera.tool.sql.ooaofooa.event.EventSpecificationStatement;
import io.ciera.tool.sql.ooaofooa.event.impl.CreateSMEventStatementImpl;
import io.ciera.tool.sql.ooaofooa.event.impl.EventSpecificationStatementImpl;
import io.ciera.tool.sql.ooaofooa.value.V_VAR;
import io.ciera.tool.sql.ooaofooa.value.impl.V_VARImpl;


public class CreateEventStatementImpl extends ModelInstance<CreateEventStatement,Sql> implements CreateEventStatement {

    public static final String KEY_LETTERS = "E_CES";
    public static final CreateEventStatement EMPTY_CREATEEVENTSTATEMENT = new EmptyCreateEventStatement();

    private Sql context;

    // constructors
    private CreateEventStatementImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        m_is_implicit = false;
        ref_Var_ID = UniqueId.random();
        R701_is_a_EventSpecificationStatement_inst = EventSpecificationStatementImpl.EMPTY_EVENTSPECIFICATIONSTATEMENT;
        R702_is_a_CreateSMEventStatement_inst = CreateSMEventStatementImpl.EMPTY_CREATESMEVENTSTATEMENT;
        R710_result_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
    }

    private CreateEventStatementImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, boolean m_is_implicit, UniqueId ref_Var_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        this.m_is_implicit = m_is_implicit;
        this.ref_Var_ID = ref_Var_ID;
        R701_is_a_EventSpecificationStatement_inst = EventSpecificationStatementImpl.EMPTY_EVENTSPECIFICATIONSTATEMENT;
        R702_is_a_CreateSMEventStatement_inst = CreateSMEventStatementImpl.EMPTY_CREATESMEVENTSTATEMENT;
        R710_result_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
    }

    public static CreateEventStatement create( Sql context ) throws XtumlException {
        CreateEventStatement newCreateEventStatement = new CreateEventStatementImpl( context );
        if ( context.addInstance( newCreateEventStatement ) ) {
            newCreateEventStatement.getRunContext().addChange(new InstanceCreatedDelta(newCreateEventStatement, KEY_LETTERS));
            return newCreateEventStatement;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static CreateEventStatement create( Sql context, UniqueId ref_Statement_ID, boolean m_is_implicit, UniqueId ref_Var_ID ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Statement_ID, m_is_implicit, ref_Var_ID);
    }

    public static CreateEventStatement create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, boolean m_is_implicit, UniqueId ref_Var_ID ) throws XtumlException {
        CreateEventStatement newCreateEventStatement = new CreateEventStatementImpl( context, instanceId, ref_Statement_ID, m_is_implicit, ref_Var_ID );
        if ( context.addInstance( newCreateEventStatement ) ) {
            return newCreateEventStatement;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public void setStatement_ID(UniqueId ref_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_Statement_ID.inequality( this.ref_Statement_ID)) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
            if ( !R702_is_a_CreateSMEventStatement().isEmpty() ) R702_is_a_CreateSMEventStatement().setStatement_ID( ref_Statement_ID );
        }
    }
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
        return ref_Statement_ID;
    }
    private boolean m_is_implicit;
    @Override
    public void setIs_implicit(boolean m_is_implicit) throws XtumlException {
        checkLiving();
        if (m_is_implicit != this.m_is_implicit) {
            final boolean oldValue = this.m_is_implicit;
            this.m_is_implicit = m_is_implicit;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_is_implicit", oldValue, this.m_is_implicit));
        }
    }
    @Override
    public boolean getIs_implicit() throws XtumlException {
        checkLiving();
        return m_is_implicit;
    }
    private UniqueId ref_Var_ID;
    @Override
    public UniqueId getVar_ID() throws XtumlException {
        checkLiving();
        return ref_Var_ID;
    }
    @Override
    public void setVar_ID(UniqueId ref_Var_ID) throws XtumlException {
        checkLiving();
        if (ref_Var_ID.inequality( this.ref_Var_ID)) {
            final UniqueId oldValue = this.ref_Var_ID;
            this.ref_Var_ID = ref_Var_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Var_ID", oldValue, this.ref_Var_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private EventSpecificationStatement R701_is_a_EventSpecificationStatement_inst;
    @Override
    public void setR701_is_a_EventSpecificationStatement( EventSpecificationStatement inst ) {
        R701_is_a_EventSpecificationStatement_inst = inst;
    }
    @Override
    public EventSpecificationStatement R701_is_a_EventSpecificationStatement() throws XtumlException {
        return R701_is_a_EventSpecificationStatement_inst;
    }
    private CreateSMEventStatement R702_is_a_CreateSMEventStatement_inst;
    @Override
    public void setR702_is_a_CreateSMEventStatement( CreateSMEventStatement inst ) {
        R702_is_a_CreateSMEventStatement_inst = inst;
    }
    @Override
    public CreateSMEventStatement R702_is_a_CreateSMEventStatement() throws XtumlException {
        return R702_is_a_CreateSMEventStatement_inst;
    }
    private V_VAR R710_result_V_VAR_inst;
    @Override
    public void setR710_result_V_VAR( V_VAR inst ) {
        R710_result_V_VAR_inst = inst;
    }
    @Override
    public V_VAR R710_result_V_VAR() throws XtumlException {
        return R710_result_V_VAR_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public CreateEventStatement self() {
        return this;
    }

    @Override
    public CreateEventStatement oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_CREATEEVENTSTATEMENT;
    }

}

class EmptyCreateEventStatement extends ModelInstance<CreateEventStatement,Sql> implements CreateEventStatement {

    // attributes
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIs_implicit( boolean m_is_implicit ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getIs_implicit() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getVar_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setVar_ID( UniqueId ref_Var_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public EventSpecificationStatement R701_is_a_EventSpecificationStatement() {
        return EventSpecificationStatementImpl.EMPTY_EVENTSPECIFICATIONSTATEMENT;
    }
    @Override
    public CreateSMEventStatement R702_is_a_CreateSMEventStatement() {
        return CreateSMEventStatementImpl.EMPTY_CREATESMEVENTSTATEMENT;
    }
    @Override
    public V_VAR R710_result_V_VAR() {
        return V_VARImpl.EMPTY_V_VAR;
    }


    @Override
    public String getKeyLetters() {
        return CreateEventStatementImpl.KEY_LETTERS;
    }

    @Override
    public CreateEventStatement self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public CreateEventStatement oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return CreateEventStatementImpl.EMPTY_CREATEEVENTSTATEMENT;
    }

}
