package io.ciera.tool.sql.ooaofooa.domain.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.domain.DataType;
import io.ciera.tool.sql.ooaofooa.domain.Range;
import io.ciera.tool.sql.ooaofooa.domain.UserDataType;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.RangeImpl;


public class UserDataTypeImpl extends ModelInstance<UserDataType,Sql> implements UserDataType {

    public static final String KEY_LETTERS = "S_UDT";
    public static final UserDataType EMPTY_USERDATATYPE = new EmptyUserDataType();

    private Sql context;

    // constructors
    private UserDataTypeImpl( Sql context ) {
        this.context = context;
        ref_DT_ID = UniqueId.random();
        ref_CDT_DT_ID = UniqueId.random();
        m_Gen_Type = 0;
        m_Definition = "";
        R17_is_a_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R18_are_defined_within_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R57_has_span_of_Range_inst = RangeImpl.EMPTY_RANGE;
    }

    private UserDataTypeImpl( Sql context, UniqueId instanceId, UniqueId ref_DT_ID, UniqueId ref_CDT_DT_ID, int m_Gen_Type, String m_Definition ) {
        super(instanceId);
        this.context = context;
        this.ref_DT_ID = ref_DT_ID;
        this.ref_CDT_DT_ID = ref_CDT_DT_ID;
        this.m_Gen_Type = m_Gen_Type;
        this.m_Definition = m_Definition;
        R17_is_a_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R18_are_defined_within_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R57_has_span_of_Range_inst = RangeImpl.EMPTY_RANGE;
    }

    public static UserDataType create( Sql context ) throws XtumlException {
        UserDataType newUserDataType = new UserDataTypeImpl( context );
        if ( context.addInstance( newUserDataType ) ) {
            newUserDataType.getRunContext().addChange(new InstanceCreatedDelta(newUserDataType, KEY_LETTERS));
            return newUserDataType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static UserDataType create( Sql context, UniqueId ref_DT_ID, UniqueId ref_CDT_DT_ID, int m_Gen_Type, String m_Definition ) throws XtumlException {
        return create(context, UniqueId.random(), ref_DT_ID, ref_CDT_DT_ID, m_Gen_Type, m_Definition);
    }

    public static UserDataType create( Sql context, UniqueId instanceId, UniqueId ref_DT_ID, UniqueId ref_CDT_DT_ID, int m_Gen_Type, String m_Definition ) throws XtumlException {
        UserDataType newUserDataType = new UserDataTypeImpl( context, instanceId, ref_DT_ID, ref_CDT_DT_ID, m_Gen_Type, m_Definition );
        if ( context.addInstance( newUserDataType ) ) {
            return newUserDataType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_DT_ID;
    @Override
    public void setDT_ID(UniqueId ref_DT_ID) throws XtumlException {
        checkLiving();
        if (ref_DT_ID.inequality( this.ref_DT_ID)) {
            final UniqueId oldValue = this.ref_DT_ID;
            this.ref_DT_ID = ref_DT_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_DT_ID", oldValue, this.ref_DT_ID));
            if ( !R57_has_span_of_Range().isEmpty() ) R57_has_span_of_Range().setDT_ID( ref_DT_ID );
        }
    }
    @Override
    public UniqueId getDT_ID() throws XtumlException {
        checkLiving();
        return ref_DT_ID;
    }
    private UniqueId ref_CDT_DT_ID;
    @Override
    public UniqueId getCDT_DT_ID() throws XtumlException {
        checkLiving();
        return ref_CDT_DT_ID;
    }
    @Override
    public void setCDT_DT_ID(UniqueId ref_CDT_DT_ID) throws XtumlException {
        checkLiving();
        if (ref_CDT_DT_ID.inequality( this.ref_CDT_DT_ID)) {
            final UniqueId oldValue = this.ref_CDT_DT_ID;
            this.ref_CDT_DT_ID = ref_CDT_DT_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_CDT_DT_ID", oldValue, this.ref_CDT_DT_ID));
        }
    }
    private int m_Gen_Type;
    @Override
    public int getGen_Type() throws XtumlException {
        checkLiving();
        return m_Gen_Type;
    }
    @Override
    public void setGen_Type(int m_Gen_Type) throws XtumlException {
        checkLiving();
        if (m_Gen_Type != this.m_Gen_Type) {
            final int oldValue = this.m_Gen_Type;
            this.m_Gen_Type = m_Gen_Type;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Gen_Type", oldValue, this.m_Gen_Type));
        }
    }
    private String m_Definition;
    @Override
    public void setDefinition(String m_Definition) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Definition, this.m_Definition)) {
            final String oldValue = this.m_Definition;
            this.m_Definition = m_Definition;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Definition", oldValue, this.m_Definition));
        }
    }
    @Override
    public String getDefinition() throws XtumlException {
        checkLiving();
        return m_Definition;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getDT_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private DataType R17_is_a_DataType_inst;
    @Override
    public void setR17_is_a_DataType( DataType inst ) {
        R17_is_a_DataType_inst = inst;
    }
    @Override
    public DataType R17_is_a_DataType() throws XtumlException {
        return R17_is_a_DataType_inst;
    }
    private DataType R18_are_defined_within_DataType_inst;
    @Override
    public void setR18_are_defined_within_DataType( DataType inst ) {
        R18_are_defined_within_DataType_inst = inst;
    }
    @Override
    public DataType R18_are_defined_within_DataType() throws XtumlException {
        return R18_are_defined_within_DataType_inst;
    }
    private Range R57_has_span_of_Range_inst;
    @Override
    public void setR57_has_span_of_Range( Range inst ) {
        R57_has_span_of_Range_inst = inst;
    }
    @Override
    public Range R57_has_span_of_Range() throws XtumlException {
        return R57_has_span_of_Range_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public UserDataType self() {
        return this;
    }

    @Override
    public UserDataType oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_USERDATATYPE;
    }

}

class EmptyUserDataType extends ModelInstance<UserDataType,Sql> implements UserDataType {

    // attributes
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getDT_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getCDT_DT_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setCDT_DT_ID( UniqueId ref_CDT_DT_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getGen_Type() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setGen_Type( int m_Gen_Type ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDefinition( String m_Definition ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDefinition() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public DataType R17_is_a_DataType() {
        return DataTypeImpl.EMPTY_DATATYPE;
    }
    @Override
    public DataType R18_are_defined_within_DataType() {
        return DataTypeImpl.EMPTY_DATATYPE;
    }
    @Override
    public Range R57_has_span_of_Range() {
        return RangeImpl.EMPTY_RANGE;
    }


    @Override
    public String getKeyLetters() {
        return UserDataTypeImpl.KEY_LETTERS;
    }

    @Override
    public UserDataType self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public UserDataType oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return UserDataTypeImpl.EMPTY_USERDATATYPE;
    }

}
