package io.ciera.tool.sql.ooaofooa.domain.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.domain.Bridge;
import io.ciera.tool.sql.ooaofooa.domain.BridgeParameter;
import io.ciera.tool.sql.ooaofooa.domain.DataType;
import io.ciera.tool.sql.ooaofooa.domain.Dimensions;
import io.ciera.tool.sql.ooaofooa.domain.DimensionsSet;
import io.ciera.tool.sql.ooaofooa.domain.impl.BridgeImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.BridgeParameterImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.DimensionsSetImpl;
import io.ciera.tool.sql.ooaofooa.message.BridgeArgument;
import io.ciera.tool.sql.ooaofooa.message.BridgeArgumentSet;
import io.ciera.tool.sql.ooaofooa.message.impl.BridgeArgumentSetImpl;
import io.ciera.tool.sql.ooaofooa.value.ParameterValue;
import io.ciera.tool.sql.ooaofooa.value.ParameterValueSet;
import io.ciera.tool.sql.ooaofooa.value.impl.ParameterValueSetImpl;


public class BridgeParameterImpl extends ModelInstance<BridgeParameter,Sql> implements BridgeParameter {

    public static final String KEY_LETTERS = "S_BPARM";
    public static final BridgeParameter EMPTY_BRIDGEPARAMETER = new EmptyBridgeParameter();

    private Sql context;

    // constructors
    private BridgeParameterImpl( Sql context ) {
        this.context = context;
        m_BParm_ID = UniqueId.random();
        ref_Brg_ID = UniqueId.random();
        m_Name = "";
        ref_DT_ID = UniqueId.random();
        m_By_Ref = 0;
        m_Dimensions = "";
        ref_Previous_BParm_ID = UniqueId.random();
        m_Descrip = "";
        R1014_represents_BridgeArgument_set = new BridgeArgumentSetImpl();
        R21_contains_Bridge_inst = BridgeImpl.EMPTY_BRIDGE;
        R22_is_defined_by_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R49_may_have_Dimensions_set = new DimensionsSetImpl();
        R55_precedes_BridgeParameter_inst = BridgeParameterImpl.EMPTY_BRIDGEPARAMETER;
        R55_succeeds_BridgeParameter_inst = BridgeParameterImpl.EMPTY_BRIDGEPARAMETER;
        R831_ParameterValue_set = new ParameterValueSetImpl();
    }

    private BridgeParameterImpl( Sql context, UniqueId instanceId, UniqueId m_BParm_ID, UniqueId ref_Brg_ID, String m_Name, UniqueId ref_DT_ID, int m_By_Ref, String m_Dimensions, UniqueId ref_Previous_BParm_ID, String m_Descrip ) {
        super(instanceId);
        this.context = context;
        this.m_BParm_ID = m_BParm_ID;
        this.ref_Brg_ID = ref_Brg_ID;
        this.m_Name = m_Name;
        this.ref_DT_ID = ref_DT_ID;
        this.m_By_Ref = m_By_Ref;
        this.m_Dimensions = m_Dimensions;
        this.ref_Previous_BParm_ID = ref_Previous_BParm_ID;
        this.m_Descrip = m_Descrip;
        R1014_represents_BridgeArgument_set = new BridgeArgumentSetImpl();
        R21_contains_Bridge_inst = BridgeImpl.EMPTY_BRIDGE;
        R22_is_defined_by_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R49_may_have_Dimensions_set = new DimensionsSetImpl();
        R55_precedes_BridgeParameter_inst = BridgeParameterImpl.EMPTY_BRIDGEPARAMETER;
        R55_succeeds_BridgeParameter_inst = BridgeParameterImpl.EMPTY_BRIDGEPARAMETER;
        R831_ParameterValue_set = new ParameterValueSetImpl();
    }

    public static BridgeParameter create( Sql context ) throws XtumlException {
        BridgeParameter newBridgeParameter = new BridgeParameterImpl( context );
        if ( context.addInstance( newBridgeParameter ) ) {
            newBridgeParameter.getRunContext().addChange(new InstanceCreatedDelta(newBridgeParameter, KEY_LETTERS));
            return newBridgeParameter;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static BridgeParameter create( Sql context, UniqueId m_BParm_ID, UniqueId ref_Brg_ID, String m_Name, UniqueId ref_DT_ID, int m_By_Ref, String m_Dimensions, UniqueId ref_Previous_BParm_ID, String m_Descrip ) throws XtumlException {
        return create(context, UniqueId.random(), m_BParm_ID, ref_Brg_ID, m_Name, ref_DT_ID, m_By_Ref, m_Dimensions, ref_Previous_BParm_ID, m_Descrip);
    }

    public static BridgeParameter create( Sql context, UniqueId instanceId, UniqueId m_BParm_ID, UniqueId ref_Brg_ID, String m_Name, UniqueId ref_DT_ID, int m_By_Ref, String m_Dimensions, UniqueId ref_Previous_BParm_ID, String m_Descrip ) throws XtumlException {
        BridgeParameter newBridgeParameter = new BridgeParameterImpl( context, instanceId, m_BParm_ID, ref_Brg_ID, m_Name, ref_DT_ID, m_By_Ref, m_Dimensions, ref_Previous_BParm_ID, m_Descrip );
        if ( context.addInstance( newBridgeParameter ) ) {
            return newBridgeParameter;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_BParm_ID;
    @Override
    public void setBParm_ID(UniqueId m_BParm_ID) throws XtumlException {
        checkLiving();
        if (m_BParm_ID.inequality( this.m_BParm_ID)) {
            final UniqueId oldValue = this.m_BParm_ID;
            this.m_BParm_ID = m_BParm_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_BParm_ID", oldValue, this.m_BParm_ID));
            if ( !R49_may_have_Dimensions().isEmpty() ) R49_may_have_Dimensions().setBParm_ID( m_BParm_ID );
            if ( !R55_precedes_BridgeParameter().isEmpty() ) R55_precedes_BridgeParameter().setPrevious_BParm_ID( m_BParm_ID );
            if ( !R1014_represents_BridgeArgument().isEmpty() ) R1014_represents_BridgeArgument().setBParm_ID( m_BParm_ID );
            if ( !R831_ParameterValue().isEmpty() ) R831_ParameterValue().setBParm_ID( m_BParm_ID );
        }
    }
    @Override
    public UniqueId getBParm_ID() throws XtumlException {
        checkLiving();
        return m_BParm_ID;
    }
    private UniqueId ref_Brg_ID;
    @Override
    public void setBrg_ID(UniqueId ref_Brg_ID) throws XtumlException {
        checkLiving();
        if (ref_Brg_ID.inequality( this.ref_Brg_ID)) {
            final UniqueId oldValue = this.ref_Brg_ID;
            this.ref_Brg_ID = ref_Brg_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Brg_ID", oldValue, this.ref_Brg_ID));
        }
    }
    @Override
    public UniqueId getBrg_ID() throws XtumlException {
        checkLiving();
        return ref_Brg_ID;
    }
    private String m_Name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    private UniqueId ref_DT_ID;
    @Override
    public UniqueId getDT_ID() throws XtumlException {
        checkLiving();
        return ref_DT_ID;
    }
    @Override
    public void setDT_ID(UniqueId ref_DT_ID) throws XtumlException {
        checkLiving();
        if (ref_DT_ID.inequality( this.ref_DT_ID)) {
            final UniqueId oldValue = this.ref_DT_ID;
            this.ref_DT_ID = ref_DT_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_DT_ID", oldValue, this.ref_DT_ID));
        }
    }
    private int m_By_Ref;
    @Override
    public int getBy_Ref() throws XtumlException {
        checkLiving();
        return m_By_Ref;
    }
    @Override
    public void setBy_Ref(int m_By_Ref) throws XtumlException {
        checkLiving();
        if (m_By_Ref != this.m_By_Ref) {
            final int oldValue = this.m_By_Ref;
            this.m_By_Ref = m_By_Ref;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_By_Ref", oldValue, this.m_By_Ref));
        }
    }
    private String m_Dimensions;
    @Override
    public String getDimensions() throws XtumlException {
        checkLiving();
        return m_Dimensions;
    }
    @Override
    public void setDimensions(String m_Dimensions) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Dimensions, this.m_Dimensions)) {
            final String oldValue = this.m_Dimensions;
            this.m_Dimensions = m_Dimensions;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Dimensions", oldValue, this.m_Dimensions));
        }
    }
    private UniqueId ref_Previous_BParm_ID;
    @Override
    public void setPrevious_BParm_ID(UniqueId ref_Previous_BParm_ID) throws XtumlException {
        checkLiving();
        if (ref_Previous_BParm_ID.inequality( this.ref_Previous_BParm_ID)) {
            final UniqueId oldValue = this.ref_Previous_BParm_ID;
            this.ref_Previous_BParm_ID = ref_Previous_BParm_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Previous_BParm_ID", oldValue, this.ref_Previous_BParm_ID));
        }
    }
    @Override
    public UniqueId getPrevious_BParm_ID() throws XtumlException {
        checkLiving();
        return ref_Previous_BParm_ID;
    }
    private String m_Descrip;
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getBParm_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private BridgeArgumentSet R1014_represents_BridgeArgument_set;
    @Override
    public void addR1014_represents_BridgeArgument( BridgeArgument inst ) {
        R1014_represents_BridgeArgument_set.add(inst);
    }
    @Override
    public void removeR1014_represents_BridgeArgument( BridgeArgument inst ) {
        R1014_represents_BridgeArgument_set.remove(inst);
    }
    @Override
    public BridgeArgumentSet R1014_represents_BridgeArgument() throws XtumlException {
        return R1014_represents_BridgeArgument_set;
    }
    private Bridge R21_contains_Bridge_inst;
    @Override
    public void setR21_contains_Bridge( Bridge inst ) {
        R21_contains_Bridge_inst = inst;
    }
    @Override
    public Bridge R21_contains_Bridge() throws XtumlException {
        return R21_contains_Bridge_inst;
    }
    private DataType R22_is_defined_by_DataType_inst;
    @Override
    public void setR22_is_defined_by_DataType( DataType inst ) {
        R22_is_defined_by_DataType_inst = inst;
    }
    @Override
    public DataType R22_is_defined_by_DataType() throws XtumlException {
        return R22_is_defined_by_DataType_inst;
    }
    private DimensionsSet R49_may_have_Dimensions_set;
    @Override
    public void addR49_may_have_Dimensions( Dimensions inst ) {
        R49_may_have_Dimensions_set.add(inst);
    }
    @Override
    public void removeR49_may_have_Dimensions( Dimensions inst ) {
        R49_may_have_Dimensions_set.remove(inst);
    }
    @Override
    public DimensionsSet R49_may_have_Dimensions() throws XtumlException {
        return R49_may_have_Dimensions_set;
    }
    private BridgeParameter R55_precedes_BridgeParameter_inst;
    @Override
    public void setR55_precedes_BridgeParameter( BridgeParameter inst ) {
        R55_precedes_BridgeParameter_inst = inst;
    }
    @Override
    public BridgeParameter R55_precedes_BridgeParameter() throws XtumlException {
        return R55_precedes_BridgeParameter_inst;
    }
    private BridgeParameter R55_succeeds_BridgeParameter_inst;
    @Override
    public void setR55_succeeds_BridgeParameter( BridgeParameter inst ) {
        R55_succeeds_BridgeParameter_inst = inst;
    }
    @Override
    public BridgeParameter R55_succeeds_BridgeParameter() throws XtumlException {
        return R55_succeeds_BridgeParameter_inst;
    }
    private ParameterValueSet R831_ParameterValue_set;
    @Override
    public void addR831_ParameterValue( ParameterValue inst ) {
        R831_ParameterValue_set.add(inst);
    }
    @Override
    public void removeR831_ParameterValue( ParameterValue inst ) {
        R831_ParameterValue_set.remove(inst);
    }
    @Override
    public ParameterValueSet R831_ParameterValue() throws XtumlException {
        return R831_ParameterValue_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public BridgeParameter self() {
        return this;
    }

    @Override
    public BridgeParameter oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_BRIDGEPARAMETER;
    }

}

class EmptyBridgeParameter extends ModelInstance<BridgeParameter,Sql> implements BridgeParameter {

    // attributes
    public void setBParm_ID( UniqueId m_BParm_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getBParm_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBrg_ID( UniqueId ref_Brg_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getBrg_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getDT_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getBy_Ref() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBy_Ref( int m_By_Ref ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDimensions() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDimensions( String m_Dimensions ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setPrevious_BParm_ID( UniqueId ref_Previous_BParm_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getPrevious_BParm_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public BridgeArgumentSet R1014_represents_BridgeArgument() {
        return (new BridgeArgumentSetImpl());
    }
    @Override
    public Bridge R21_contains_Bridge() {
        return BridgeImpl.EMPTY_BRIDGE;
    }
    @Override
    public DataType R22_is_defined_by_DataType() {
        return DataTypeImpl.EMPTY_DATATYPE;
    }
    @Override
    public DimensionsSet R49_may_have_Dimensions() {
        return (new DimensionsSetImpl());
    }
    @Override
    public BridgeParameter R55_precedes_BridgeParameter() {
        return BridgeParameterImpl.EMPTY_BRIDGEPARAMETER;
    }
    @Override
    public BridgeParameter R55_succeeds_BridgeParameter() {
        return BridgeParameterImpl.EMPTY_BRIDGEPARAMETER;
    }
    @Override
    public ParameterValueSet R831_ParameterValue() {
        return (new ParameterValueSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return BridgeParameterImpl.KEY_LETTERS;
    }

    @Override
    public BridgeParameter self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public BridgeParameter oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return BridgeParameterImpl.EMPTY_BRIDGEPARAMETER;
    }

}
