package io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.ExecutableProperty;
import io.ciera.tool.sql.ooaofooa.component.Requirement;
import io.ciera.tool.sql.ooaofooa.component.impl.ExecutablePropertyImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.RequirementImpl;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.RequiredExecutableProperty;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.RequiredOperation;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.RequiredSignal;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.impl.RequiredOperationImpl;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.impl.RequiredSignalImpl;
import io.ciera.tool.sql.ooaofooa.value.MessageValue;
import io.ciera.tool.sql.ooaofooa.value.MessageValueSet;
import io.ciera.tool.sql.ooaofooa.value.impl.MessageValueSetImpl;


public class RequiredExecutablePropertyImpl extends ModelInstance<RequiredExecutableProperty,Sql> implements RequiredExecutableProperty {

    public static final String KEY_LETTERS = "SPR_REP";
    public static final RequiredExecutableProperty EMPTY_REQUIREDEXECUTABLEPROPERTY = new EmptyRequiredExecutableProperty();

    private Sql context;

    // constructors
    private RequiredExecutablePropertyImpl( Sql context ) {
        this.context = context;
        m_Id = UniqueId.random();
        ref_ExecutableProperty_Id = UniqueId.random();
        ref_Requirement_Id = UniqueId.random();
        R4500_implements_ExecutableProperty_inst = ExecutablePropertyImpl.EMPTY_EXECUTABLEPROPERTY;
        R4500_is_implemented_by_Requirement_inst = RequirementImpl.EMPTY_REQUIREMENT;
        R4502_is_a_RequiredOperation_inst = RequiredOperationImpl.EMPTY_REQUIREDOPERATION;
        R4502_is_a_RequiredSignal_inst = RequiredSignalImpl.EMPTY_REQUIREDSIGNAL;
        R845_MessageValue_set = new MessageValueSetImpl();
    }

    private RequiredExecutablePropertyImpl( Sql context, UniqueId instanceId, UniqueId m_Id, UniqueId ref_ExecutableProperty_Id, UniqueId ref_Requirement_Id ) {
        super(instanceId);
        this.context = context;
        this.m_Id = m_Id;
        this.ref_ExecutableProperty_Id = ref_ExecutableProperty_Id;
        this.ref_Requirement_Id = ref_Requirement_Id;
        R4500_implements_ExecutableProperty_inst = ExecutablePropertyImpl.EMPTY_EXECUTABLEPROPERTY;
        R4500_is_implemented_by_Requirement_inst = RequirementImpl.EMPTY_REQUIREMENT;
        R4502_is_a_RequiredOperation_inst = RequiredOperationImpl.EMPTY_REQUIREDOPERATION;
        R4502_is_a_RequiredSignal_inst = RequiredSignalImpl.EMPTY_REQUIREDSIGNAL;
        R845_MessageValue_set = new MessageValueSetImpl();
    }

    public static RequiredExecutableProperty create( Sql context ) throws XtumlException {
        RequiredExecutableProperty newRequiredExecutableProperty = new RequiredExecutablePropertyImpl( context );
        if ( context.addInstance( newRequiredExecutableProperty ) ) {
            newRequiredExecutableProperty.getRunContext().addChange(new InstanceCreatedDelta(newRequiredExecutableProperty, KEY_LETTERS));
            return newRequiredExecutableProperty;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static RequiredExecutableProperty create( Sql context, UniqueId m_Id, UniqueId ref_ExecutableProperty_Id, UniqueId ref_Requirement_Id ) throws XtumlException {
        return create(context, UniqueId.random(), m_Id, ref_ExecutableProperty_Id, ref_Requirement_Id);
    }

    public static RequiredExecutableProperty create( Sql context, UniqueId instanceId, UniqueId m_Id, UniqueId ref_ExecutableProperty_Id, UniqueId ref_Requirement_Id ) throws XtumlException {
        RequiredExecutableProperty newRequiredExecutableProperty = new RequiredExecutablePropertyImpl( context, instanceId, m_Id, ref_ExecutableProperty_Id, ref_Requirement_Id );
        if ( context.addInstance( newRequiredExecutableProperty ) ) {
            return newRequiredExecutableProperty;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Id;
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return m_Id;
    }
    @Override
    public void setId(UniqueId m_Id) throws XtumlException {
        checkLiving();
        if (m_Id.inequality( this.m_Id)) {
            final UniqueId oldValue = this.m_Id;
            this.m_Id = m_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Id", oldValue, this.m_Id));
            if ( !R4502_is_a_RequiredSignal().isEmpty() ) R4502_is_a_RequiredSignal().setId( m_Id );
            if ( !R4502_is_a_RequiredOperation().isEmpty() ) R4502_is_a_RequiredOperation().setId( m_Id );
            if ( !R845_MessageValue().isEmpty() ) R845_MessageValue().setREP_Id( m_Id );
        }
    }
    private UniqueId ref_ExecutableProperty_Id;
    @Override
    public void setExecutableProperty_Id(UniqueId ref_ExecutableProperty_Id) throws XtumlException {
        checkLiving();
        if (ref_ExecutableProperty_Id.inequality( this.ref_ExecutableProperty_Id)) {
            final UniqueId oldValue = this.ref_ExecutableProperty_Id;
            this.ref_ExecutableProperty_Id = ref_ExecutableProperty_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_ExecutableProperty_Id", oldValue, this.ref_ExecutableProperty_Id));
        }
    }
    @Override
    public UniqueId getExecutableProperty_Id() throws XtumlException {
        checkLiving();
        return ref_ExecutableProperty_Id;
    }
    private UniqueId ref_Requirement_Id;
    @Override
    public UniqueId getRequirement_Id() throws XtumlException {
        checkLiving();
        return ref_Requirement_Id;
    }
    @Override
    public void setRequirement_Id(UniqueId ref_Requirement_Id) throws XtumlException {
        checkLiving();
        if (ref_Requirement_Id.inequality( this.ref_Requirement_Id)) {
            final UniqueId oldValue = this.ref_Requirement_Id;
            this.ref_Requirement_Id = ref_Requirement_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Requirement_Id", oldValue, this.ref_Requirement_Id));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ExecutableProperty R4500_implements_ExecutableProperty_inst;
    @Override
    public void setR4500_implements_ExecutableProperty( ExecutableProperty inst ) {
        R4500_implements_ExecutableProperty_inst = inst;
    }
    @Override
    public ExecutableProperty R4500_implements_ExecutableProperty() throws XtumlException {
        return R4500_implements_ExecutableProperty_inst;
    }
    private Requirement R4500_is_implemented_by_Requirement_inst;
    @Override
    public void setR4500_is_implemented_by_Requirement( Requirement inst ) {
        R4500_is_implemented_by_Requirement_inst = inst;
    }
    @Override
    public Requirement R4500_is_implemented_by_Requirement() throws XtumlException {
        return R4500_is_implemented_by_Requirement_inst;
    }
    private RequiredOperation R4502_is_a_RequiredOperation_inst;
    @Override
    public void setR4502_is_a_RequiredOperation( RequiredOperation inst ) {
        R4502_is_a_RequiredOperation_inst = inst;
    }
    @Override
    public RequiredOperation R4502_is_a_RequiredOperation() throws XtumlException {
        return R4502_is_a_RequiredOperation_inst;
    }
    private RequiredSignal R4502_is_a_RequiredSignal_inst;
    @Override
    public void setR4502_is_a_RequiredSignal( RequiredSignal inst ) {
        R4502_is_a_RequiredSignal_inst = inst;
    }
    @Override
    public RequiredSignal R4502_is_a_RequiredSignal() throws XtumlException {
        return R4502_is_a_RequiredSignal_inst;
    }
    private MessageValueSet R845_MessageValue_set;
    @Override
    public void addR845_MessageValue( MessageValue inst ) {
        R845_MessageValue_set.add(inst);
    }
    @Override
    public void removeR845_MessageValue( MessageValue inst ) {
        R845_MessageValue_set.remove(inst);
    }
    @Override
    public MessageValueSet R845_MessageValue() throws XtumlException {
        return R845_MessageValue_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public RequiredExecutableProperty self() {
        return this;
    }

    @Override
    public RequiredExecutableProperty oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_REQUIREDEXECUTABLEPROPERTY;
    }

}

class EmptyRequiredExecutableProperty extends ModelInstance<RequiredExecutableProperty,Sql> implements RequiredExecutableProperty {

    // attributes
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId( UniqueId m_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setExecutableProperty_Id( UniqueId ref_ExecutableProperty_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getExecutableProperty_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getRequirement_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRequirement_Id( UniqueId ref_Requirement_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ExecutableProperty R4500_implements_ExecutableProperty() {
        return ExecutablePropertyImpl.EMPTY_EXECUTABLEPROPERTY;
    }
    @Override
    public Requirement R4500_is_implemented_by_Requirement() {
        return RequirementImpl.EMPTY_REQUIREMENT;
    }
    @Override
    public RequiredOperation R4502_is_a_RequiredOperation() {
        return RequiredOperationImpl.EMPTY_REQUIREDOPERATION;
    }
    @Override
    public RequiredSignal R4502_is_a_RequiredSignal() {
        return RequiredSignalImpl.EMPTY_REQUIREDSIGNAL;
    }
    @Override
    public MessageValueSet R845_MessageValue() {
        return (new MessageValueSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return RequiredExecutablePropertyImpl.KEY_LETTERS;
    }

    @Override
    public RequiredExecutableProperty self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public RequiredExecutableProperty oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return RequiredExecutablePropertyImpl.EMPTY_REQUIREDEXECUTABLEPROPERTY;
    }

}
