package io.ciera.tool.sql.ooaofooa.component.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.C_I;
import io.ciera.tool.sql.ooaofooa.component.C_PO;
import io.ciera.tool.sql.ooaofooa.component.Delegation;
import io.ciera.tool.sql.ooaofooa.component.InterfaceReference;
import io.ciera.tool.sql.ooaofooa.component.InterfaceReferenceInDelegation;
import io.ciera.tool.sql.ooaofooa.component.InterfaceReferenceInDelegationSet;
import io.ciera.tool.sql.ooaofooa.component.Provision;
import io.ciera.tool.sql.ooaofooa.component.Requirement;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedReference;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedReferenceSet;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl.ImportedReferenceSetImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.C_IImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.C_POImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.DelegationImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.InterfaceReferenceInDelegationSetImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.ProvisionImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.RequirementImpl;


public class InterfaceReferenceImpl extends ModelInstance<InterfaceReference,Sql> implements InterfaceReference {

    public static final String KEY_LETTERS = "C_IR";
    public static final InterfaceReference EMPTY_INTERFACEREFERENCE = new EmptyInterfaceReference();

    private Sql context;

    // constructors
    private InterfaceReferenceImpl( Sql context ) {
        this.context = context;
        m_Id = UniqueId.random();
        ref_Formal_Interface_Id = UniqueId.random();
        ref_Delegation_Id = UniqueId.random();
        ref_Port_Id = UniqueId.random();
        R4009_is_a_Provision_inst = ProvisionImpl.EMPTY_PROVISION;
        R4009_is_a_Requirement_inst = RequirementImpl.EMPTY_REQUIREMENT;
        R4012_may_be_defined_by_C_I_inst = C_IImpl.EMPTY_C_I;
        R4013_may_delegate_through_InterfaceReferenceInDelegation_set = new InterfaceReferenceInDelegationSetImpl();
        R4014_receives_delegation_via_Delegation_inst = DelegationImpl.EMPTY_DELEGATION;
        R4016_originates_from_C_PO_inst = C_POImpl.EMPTY_C_PO;
        R4701_is_imported_ImportedReference_set = new ImportedReferenceSetImpl();
    }

    private InterfaceReferenceImpl( Sql context, UniqueId instanceId, UniqueId m_Id, UniqueId ref_Formal_Interface_Id, UniqueId ref_Delegation_Id, UniqueId ref_Port_Id ) {
        super(instanceId);
        this.context = context;
        this.m_Id = m_Id;
        this.ref_Formal_Interface_Id = ref_Formal_Interface_Id;
        this.ref_Delegation_Id = ref_Delegation_Id;
        this.ref_Port_Id = ref_Port_Id;
        R4009_is_a_Provision_inst = ProvisionImpl.EMPTY_PROVISION;
        R4009_is_a_Requirement_inst = RequirementImpl.EMPTY_REQUIREMENT;
        R4012_may_be_defined_by_C_I_inst = C_IImpl.EMPTY_C_I;
        R4013_may_delegate_through_InterfaceReferenceInDelegation_set = new InterfaceReferenceInDelegationSetImpl();
        R4014_receives_delegation_via_Delegation_inst = DelegationImpl.EMPTY_DELEGATION;
        R4016_originates_from_C_PO_inst = C_POImpl.EMPTY_C_PO;
        R4701_is_imported_ImportedReference_set = new ImportedReferenceSetImpl();
    }

    public static InterfaceReference create( Sql context ) throws XtumlException {
        InterfaceReference newInterfaceReference = new InterfaceReferenceImpl( context );
        if ( context.addInstance( newInterfaceReference ) ) {
            newInterfaceReference.getRunContext().addChange(new InstanceCreatedDelta(newInterfaceReference, KEY_LETTERS));
            return newInterfaceReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static InterfaceReference create( Sql context, UniqueId m_Id, UniqueId ref_Formal_Interface_Id, UniqueId ref_Delegation_Id, UniqueId ref_Port_Id ) throws XtumlException {
        return create(context, UniqueId.random(), m_Id, ref_Formal_Interface_Id, ref_Delegation_Id, ref_Port_Id);
    }

    public static InterfaceReference create( Sql context, UniqueId instanceId, UniqueId m_Id, UniqueId ref_Formal_Interface_Id, UniqueId ref_Delegation_Id, UniqueId ref_Port_Id ) throws XtumlException {
        InterfaceReference newInterfaceReference = new InterfaceReferenceImpl( context, instanceId, m_Id, ref_Formal_Interface_Id, ref_Delegation_Id, ref_Port_Id );
        if ( context.addInstance( newInterfaceReference ) ) {
            return newInterfaceReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Id;
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return m_Id;
    }
    @Override
    public void setId(UniqueId m_Id) throws XtumlException {
        checkLiving();
        if (m_Id.inequality( this.m_Id)) {
            final UniqueId oldValue = this.m_Id;
            this.m_Id = m_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Id", oldValue, this.m_Id));
            if ( !R4009_is_a_Requirement().isEmpty() ) R4009_is_a_Requirement().setRequirement_Id( m_Id );
            if ( !R4013_may_delegate_through_InterfaceReferenceInDelegation().isEmpty() ) R4013_may_delegate_through_InterfaceReferenceInDelegation().setReference_Id( m_Id );
            if ( !R4009_is_a_Provision().isEmpty() ) R4009_is_a_Provision().setProvision_Id( m_Id );
            if ( !R4701_is_imported_ImportedReference().isEmpty() ) R4701_is_imported_ImportedReference().setRef_Id( m_Id );
        }
    }
    private UniqueId ref_Formal_Interface_Id;
    @Override
    public UniqueId getFormal_Interface_Id() throws XtumlException {
        checkLiving();
        return ref_Formal_Interface_Id;
    }
    @Override
    public void setFormal_Interface_Id(UniqueId ref_Formal_Interface_Id) throws XtumlException {
        checkLiving();
        if (ref_Formal_Interface_Id.inequality( this.ref_Formal_Interface_Id)) {
            final UniqueId oldValue = this.ref_Formal_Interface_Id;
            this.ref_Formal_Interface_Id = ref_Formal_Interface_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Formal_Interface_Id", oldValue, this.ref_Formal_Interface_Id));
        }
    }
    private UniqueId ref_Delegation_Id;
    @Override
    public UniqueId getDelegation_Id() throws XtumlException {
        checkLiving();
        return ref_Delegation_Id;
    }
    @Override
    public void setDelegation_Id(UniqueId ref_Delegation_Id) throws XtumlException {
        checkLiving();
        if (ref_Delegation_Id.inequality( this.ref_Delegation_Id)) {
            final UniqueId oldValue = this.ref_Delegation_Id;
            this.ref_Delegation_Id = ref_Delegation_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Delegation_Id", oldValue, this.ref_Delegation_Id));
        }
    }
    private UniqueId ref_Port_Id;
    @Override
    public void setPort_Id(UniqueId ref_Port_Id) throws XtumlException {
        checkLiving();
        if (ref_Port_Id.inequality( this.ref_Port_Id)) {
            final UniqueId oldValue = this.ref_Port_Id;
            this.ref_Port_Id = ref_Port_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Port_Id", oldValue, this.ref_Port_Id));
        }
    }
    @Override
    public UniqueId getPort_Id() throws XtumlException {
        checkLiving();
        return ref_Port_Id;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Provision R4009_is_a_Provision_inst;
    @Override
    public void setR4009_is_a_Provision( Provision inst ) {
        R4009_is_a_Provision_inst = inst;
    }
    @Override
    public Provision R4009_is_a_Provision() throws XtumlException {
        return R4009_is_a_Provision_inst;
    }
    private Requirement R4009_is_a_Requirement_inst;
    @Override
    public void setR4009_is_a_Requirement( Requirement inst ) {
        R4009_is_a_Requirement_inst = inst;
    }
    @Override
    public Requirement R4009_is_a_Requirement() throws XtumlException {
        return R4009_is_a_Requirement_inst;
    }
    private C_I R4012_may_be_defined_by_C_I_inst;
    @Override
    public void setR4012_may_be_defined_by_C_I( C_I inst ) {
        R4012_may_be_defined_by_C_I_inst = inst;
    }
    @Override
    public C_I R4012_may_be_defined_by_C_I() throws XtumlException {
        return R4012_may_be_defined_by_C_I_inst;
    }
    private InterfaceReferenceInDelegationSet R4013_may_delegate_through_InterfaceReferenceInDelegation_set;
    @Override
    public void addR4013_may_delegate_through_InterfaceReferenceInDelegation( InterfaceReferenceInDelegation inst ) {
        R4013_may_delegate_through_InterfaceReferenceInDelegation_set.add(inst);
    }
    @Override
    public void removeR4013_may_delegate_through_InterfaceReferenceInDelegation( InterfaceReferenceInDelegation inst ) {
        R4013_may_delegate_through_InterfaceReferenceInDelegation_set.remove(inst);
    }
    @Override
    public InterfaceReferenceInDelegationSet R4013_may_delegate_through_InterfaceReferenceInDelegation() throws XtumlException {
        return R4013_may_delegate_through_InterfaceReferenceInDelegation_set;
    }
    private Delegation R4014_receives_delegation_via_Delegation_inst;
    @Override
    public void setR4014_receives_delegation_via_Delegation( Delegation inst ) {
        R4014_receives_delegation_via_Delegation_inst = inst;
    }
    @Override
    public Delegation R4014_receives_delegation_via_Delegation() throws XtumlException {
        return R4014_receives_delegation_via_Delegation_inst;
    }
    private C_PO R4016_originates_from_C_PO_inst;
    @Override
    public void setR4016_originates_from_C_PO( C_PO inst ) {
        R4016_originates_from_C_PO_inst = inst;
    }
    @Override
    public C_PO R4016_originates_from_C_PO() throws XtumlException {
        return R4016_originates_from_C_PO_inst;
    }
    private ImportedReferenceSet R4701_is_imported_ImportedReference_set;
    @Override
    public void addR4701_is_imported_ImportedReference( ImportedReference inst ) {
        R4701_is_imported_ImportedReference_set.add(inst);
    }
    @Override
    public void removeR4701_is_imported_ImportedReference( ImportedReference inst ) {
        R4701_is_imported_ImportedReference_set.remove(inst);
    }
    @Override
    public ImportedReferenceSet R4701_is_imported_ImportedReference() throws XtumlException {
        return R4701_is_imported_ImportedReference_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public InterfaceReference self() {
        return this;
    }

    @Override
    public InterfaceReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_INTERFACEREFERENCE;
    }

}

class EmptyInterfaceReference extends ModelInstance<InterfaceReference,Sql> implements InterfaceReference {

    // attributes
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId( UniqueId m_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getFormal_Interface_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setFormal_Interface_Id( UniqueId ref_Formal_Interface_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getDelegation_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDelegation_Id( UniqueId ref_Delegation_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setPort_Id( UniqueId ref_Port_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getPort_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Provision R4009_is_a_Provision() {
        return ProvisionImpl.EMPTY_PROVISION;
    }
    @Override
    public Requirement R4009_is_a_Requirement() {
        return RequirementImpl.EMPTY_REQUIREMENT;
    }
    @Override
    public C_I R4012_may_be_defined_by_C_I() {
        return C_IImpl.EMPTY_C_I;
    }
    @Override
    public InterfaceReferenceInDelegationSet R4013_may_delegate_through_InterfaceReferenceInDelegation() {
        return (new InterfaceReferenceInDelegationSetImpl());
    }
    @Override
    public Delegation R4014_receives_delegation_via_Delegation() {
        return DelegationImpl.EMPTY_DELEGATION;
    }
    @Override
    public C_PO R4016_originates_from_C_PO() {
        return C_POImpl.EMPTY_C_PO;
    }
    @Override
    public ImportedReferenceSet R4701_is_imported_ImportedReference() {
        return (new ImportedReferenceSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return InterfaceReferenceImpl.KEY_LETTERS;
    }

    @Override
    public InterfaceReference self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public InterfaceReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return InterfaceReferenceImpl.EMPTY_INTERFACEREFERENCE;
    }

}
