package io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.C_PO;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ComponentReference;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedReference;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedReferenceSet;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.PortReference;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl.ComponentReferenceImpl;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl.ImportedReferenceSetImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.C_POImpl;


public class PortReferenceImpl extends ModelInstance<PortReference,Sql> implements PortReference {

    public static final String KEY_LETTERS = "CL_POR";
    public static final PortReference EMPTY_PORTREFERENCE = new EmptyPortReference();

    private Sql context;

    // constructors
    private PortReferenceImpl( Sql context ) {
        this.context = context;
        ref_CL_IC_Id = UniqueId.random();
        ref_C_PO_Id = UniqueId.random();
        m_Name = "";
        m_Id = UniqueId.random();
        R4707_orginates_from_ComponentReference_inst = ComponentReferenceImpl.EMPTY_COMPONENTREFERENCE;
        R4708_exposes_ImportedReference_set = new ImportedReferenceSetImpl();
        R4709_references_C_PO_inst = C_POImpl.EMPTY_C_PO;
    }

    private PortReferenceImpl( Sql context, UniqueId instanceId, UniqueId ref_CL_IC_Id, UniqueId ref_C_PO_Id, String m_Name, UniqueId m_Id ) {
        super(instanceId);
        this.context = context;
        this.ref_CL_IC_Id = ref_CL_IC_Id;
        this.ref_C_PO_Id = ref_C_PO_Id;
        this.m_Name = m_Name;
        this.m_Id = m_Id;
        R4707_orginates_from_ComponentReference_inst = ComponentReferenceImpl.EMPTY_COMPONENTREFERENCE;
        R4708_exposes_ImportedReference_set = new ImportedReferenceSetImpl();
        R4709_references_C_PO_inst = C_POImpl.EMPTY_C_PO;
    }

    public static PortReference create( Sql context ) throws XtumlException {
        PortReference newPortReference = new PortReferenceImpl( context );
        if ( context.addInstance( newPortReference ) ) {
            newPortReference.getRunContext().addChange(new InstanceCreatedDelta(newPortReference, KEY_LETTERS));
            return newPortReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static PortReference create( Sql context, UniqueId ref_CL_IC_Id, UniqueId ref_C_PO_Id, String m_Name, UniqueId m_Id ) throws XtumlException {
        return create(context, UniqueId.random(), ref_CL_IC_Id, ref_C_PO_Id, m_Name, m_Id);
    }

    public static PortReference create( Sql context, UniqueId instanceId, UniqueId ref_CL_IC_Id, UniqueId ref_C_PO_Id, String m_Name, UniqueId m_Id ) throws XtumlException {
        PortReference newPortReference = new PortReferenceImpl( context, instanceId, ref_CL_IC_Id, ref_C_PO_Id, m_Name, m_Id );
        if ( context.addInstance( newPortReference ) ) {
            return newPortReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_CL_IC_Id;
    @Override
    public void setCL_IC_Id(UniqueId ref_CL_IC_Id) throws XtumlException {
        checkLiving();
        if (ref_CL_IC_Id.inequality( this.ref_CL_IC_Id)) {
            final UniqueId oldValue = this.ref_CL_IC_Id;
            this.ref_CL_IC_Id = ref_CL_IC_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_CL_IC_Id", oldValue, this.ref_CL_IC_Id));
        }
    }
    @Override
    public UniqueId getCL_IC_Id() throws XtumlException {
        checkLiving();
        return ref_CL_IC_Id;
    }
    private UniqueId ref_C_PO_Id;
    @Override
    public void setC_PO_Id(UniqueId ref_C_PO_Id) throws XtumlException {
        checkLiving();
        if (ref_C_PO_Id.inequality( this.ref_C_PO_Id)) {
            final UniqueId oldValue = this.ref_C_PO_Id;
            this.ref_C_PO_Id = ref_C_PO_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_C_PO_Id", oldValue, this.ref_C_PO_Id));
        }
    }
    @Override
    public UniqueId getC_PO_Id() throws XtumlException {
        checkLiving();
        return ref_C_PO_Id;
    }
    private String m_Name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    private UniqueId m_Id;
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return m_Id;
    }
    @Override
    public void setId(UniqueId m_Id) throws XtumlException {
        checkLiving();
        if (m_Id.inequality( this.m_Id)) {
            final UniqueId oldValue = this.m_Id;
            this.m_Id = m_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Id", oldValue, this.m_Id));
            if ( !R4708_exposes_ImportedReference().isEmpty() ) R4708_exposes_ImportedReference().setCL_POR_Id( m_Id );
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ComponentReference R4707_orginates_from_ComponentReference_inst;
    @Override
    public void setR4707_orginates_from_ComponentReference( ComponentReference inst ) {
        R4707_orginates_from_ComponentReference_inst = inst;
    }
    @Override
    public ComponentReference R4707_orginates_from_ComponentReference() throws XtumlException {
        return R4707_orginates_from_ComponentReference_inst;
    }
    private ImportedReferenceSet R4708_exposes_ImportedReference_set;
    @Override
    public void addR4708_exposes_ImportedReference( ImportedReference inst ) {
        R4708_exposes_ImportedReference_set.add(inst);
    }
    @Override
    public void removeR4708_exposes_ImportedReference( ImportedReference inst ) {
        R4708_exposes_ImportedReference_set.remove(inst);
    }
    @Override
    public ImportedReferenceSet R4708_exposes_ImportedReference() throws XtumlException {
        return R4708_exposes_ImportedReference_set;
    }
    private C_PO R4709_references_C_PO_inst;
    @Override
    public void setR4709_references_C_PO( C_PO inst ) {
        R4709_references_C_PO_inst = inst;
    }
    @Override
    public C_PO R4709_references_C_PO() throws XtumlException {
        return R4709_references_C_PO_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public PortReference self() {
        return this;
    }

    @Override
    public PortReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_PORTREFERENCE;
    }

}

class EmptyPortReference extends ModelInstance<PortReference,Sql> implements PortReference {

    // attributes
    public void setCL_IC_Id( UniqueId ref_CL_IC_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getCL_IC_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setC_PO_Id( UniqueId ref_C_PO_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getC_PO_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId( UniqueId m_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ComponentReference R4707_orginates_from_ComponentReference() {
        return ComponentReferenceImpl.EMPTY_COMPONENTREFERENCE;
    }
    @Override
    public ImportedReferenceSet R4708_exposes_ImportedReference() {
        return (new ImportedReferenceSetImpl());
    }
    @Override
    public C_PO R4709_references_C_PO() {
        return C_POImpl.EMPTY_C_PO;
    }


    @Override
    public String getKeyLetters() {
        return PortReferenceImpl.KEY_LETTERS;
    }

    @Override
    public PortReference self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public PortReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return PortReferenceImpl.EMPTY_PORTREFERENCE;
    }

}
