package io.ciera.tool.sql.ooaofooa.body.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.Body;
import io.ciera.tool.sql.ooaofooa.body.BodyInElement;
import io.ciera.tool.sql.ooaofooa.body.impl.BodyImpl;
import io.ciera.tool.sql.ooaofooa.packageableelement.PackageableElement;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.PackageableElementImpl;


public class BodyInElementImpl extends ModelInstance<BodyInElement,Sql> implements BodyInElement {

    public static final String KEY_LETTERS = "ACT_BIE";
    public static final BodyInElement EMPTY_BODYINELEMENT = new EmptyBodyInElement();

    private Sql context;

    // constructors
    private BodyInElementImpl( Sql context ) {
        this.context = context;
        ref_Element_ID = UniqueId.random();
        ref_Action_ID = UniqueId.random();
        R640_has_declared_Body_inst = BodyImpl.EMPTY_BODY;
        R640_is_declared_in_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }

    private BodyInElementImpl( Sql context, UniqueId instanceId, UniqueId ref_Element_ID, UniqueId ref_Action_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Element_ID = ref_Element_ID;
        this.ref_Action_ID = ref_Action_ID;
        R640_has_declared_Body_inst = BodyImpl.EMPTY_BODY;
        R640_is_declared_in_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }

    public static BodyInElement create( Sql context ) throws XtumlException {
        BodyInElement newBodyInElement = new BodyInElementImpl( context );
        if ( context.addInstance( newBodyInElement ) ) {
            newBodyInElement.getRunContext().addChange(new InstanceCreatedDelta(newBodyInElement, KEY_LETTERS));
            return newBodyInElement;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static BodyInElement create( Sql context, UniqueId ref_Element_ID, UniqueId ref_Action_ID ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Element_ID, ref_Action_ID);
    }

    public static BodyInElement create( Sql context, UniqueId instanceId, UniqueId ref_Element_ID, UniqueId ref_Action_ID ) throws XtumlException {
        BodyInElement newBodyInElement = new BodyInElementImpl( context, instanceId, ref_Element_ID, ref_Action_ID );
        if ( context.addInstance( newBodyInElement ) ) {
            return newBodyInElement;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Element_ID;
    @Override
    public void setElement_ID(UniqueId ref_Element_ID) throws XtumlException {
        checkLiving();
        if (ref_Element_ID.inequality( this.ref_Element_ID)) {
            final UniqueId oldValue = this.ref_Element_ID;
            this.ref_Element_ID = ref_Element_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Element_ID", oldValue, this.ref_Element_ID));
        }
    }
    @Override
    public UniqueId getElement_ID() throws XtumlException {
        checkLiving();
        return ref_Element_ID;
    }
    private UniqueId ref_Action_ID;
    @Override
    public void setAction_ID(UniqueId ref_Action_ID) throws XtumlException {
        checkLiving();
        if (ref_Action_ID.inequality( this.ref_Action_ID)) {
            final UniqueId oldValue = this.ref_Action_ID;
            this.ref_Action_ID = ref_Action_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Action_ID", oldValue, this.ref_Action_ID));
        }
    }
    @Override
    public UniqueId getAction_ID() throws XtumlException {
        checkLiving();
        return ref_Action_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getElement_ID(), getAction_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Body R640_has_declared_Body_inst;
    @Override
    public void setR640_has_declared_Body( Body inst ) {
        R640_has_declared_Body_inst = inst;
    }
    @Override
    public Body R640_has_declared_Body() throws XtumlException {
        return R640_has_declared_Body_inst;
    }
    private PackageableElement R640_is_declared_in_PackageableElement_inst;
    @Override
    public void setR640_is_declared_in_PackageableElement( PackageableElement inst ) {
        R640_is_declared_in_PackageableElement_inst = inst;
    }
    @Override
    public PackageableElement R640_is_declared_in_PackageableElement() throws XtumlException {
        return R640_is_declared_in_PackageableElement_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public BodyInElement self() {
        return this;
    }

    @Override
    public BodyInElement oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_BODYINELEMENT;
    }

}

class EmptyBodyInElement extends ModelInstance<BodyInElement,Sql> implements BodyInElement {

    // attributes
    public void setElement_ID( UniqueId ref_Element_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getElement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAction_ID( UniqueId ref_Action_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getAction_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Body R640_has_declared_Body() {
        return BodyImpl.EMPTY_BODY;
    }
    @Override
    public PackageableElement R640_is_declared_in_PackageableElement() {
        return PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }


    @Override
    public String getKeyLetters() {
        return BodyInElementImpl.KEY_LETTERS;
    }

    @Override
    public BodyInElement self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public BodyInElement oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return BodyInElementImpl.EMPTY_BODYINELEMENT;
    }

}
