package io.ciera.tool.sql.ooaofooa.association.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.association.Association;
import io.ciera.tool.sql.ooaofooa.association.ClassAsDerivedOneSide;
import io.ciera.tool.sql.ooaofooa.association.ClassAsDerivedOtherSide;
import io.ciera.tool.sql.ooaofooa.association.DerivedAssociation;
import io.ciera.tool.sql.ooaofooa.association.impl.AssociationImpl;
import io.ciera.tool.sql.ooaofooa.association.impl.ClassAsDerivedOneSideImpl;
import io.ciera.tool.sql.ooaofooa.association.impl.ClassAsDerivedOtherSideImpl;


public class DerivedAssociationImpl extends ModelInstance<DerivedAssociation,Sql> implements DerivedAssociation {

    public static final String KEY_LETTERS = "R_COMP";
    public static final DerivedAssociation EMPTY_DERIVEDASSOCIATION = new EmptyDerivedAssociation();

    private Sql context;

    // constructors
    private DerivedAssociationImpl( Sql context ) {
        this.context = context;
        ref_Rel_ID = UniqueId.random();
        m_Rel_Chn = "";
        R206_is_a_Association_inst = AssociationImpl.EMPTY_ASSOCIATION;
        R214_relates_ClassAsDerivedOneSide_inst = ClassAsDerivedOneSideImpl.EMPTY_CLASSASDERIVEDONESIDE;
        R215_relates_ClassAsDerivedOtherSide_inst = ClassAsDerivedOtherSideImpl.EMPTY_CLASSASDERIVEDOTHERSIDE;
    }

    private DerivedAssociationImpl( Sql context, UniqueId instanceId, UniqueId ref_Rel_ID, String m_Rel_Chn ) {
        super(instanceId);
        this.context = context;
        this.ref_Rel_ID = ref_Rel_ID;
        this.m_Rel_Chn = m_Rel_Chn;
        R206_is_a_Association_inst = AssociationImpl.EMPTY_ASSOCIATION;
        R214_relates_ClassAsDerivedOneSide_inst = ClassAsDerivedOneSideImpl.EMPTY_CLASSASDERIVEDONESIDE;
        R215_relates_ClassAsDerivedOtherSide_inst = ClassAsDerivedOtherSideImpl.EMPTY_CLASSASDERIVEDOTHERSIDE;
    }

    public static DerivedAssociation create( Sql context ) throws XtumlException {
        DerivedAssociation newDerivedAssociation = new DerivedAssociationImpl( context );
        if ( context.addInstance( newDerivedAssociation ) ) {
            newDerivedAssociation.getRunContext().addChange(new InstanceCreatedDelta(newDerivedAssociation, KEY_LETTERS));
            return newDerivedAssociation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static DerivedAssociation create( Sql context, UniqueId ref_Rel_ID, String m_Rel_Chn ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Rel_ID, m_Rel_Chn);
    }

    public static DerivedAssociation create( Sql context, UniqueId instanceId, UniqueId ref_Rel_ID, String m_Rel_Chn ) throws XtumlException {
        DerivedAssociation newDerivedAssociation = new DerivedAssociationImpl( context, instanceId, ref_Rel_ID, m_Rel_Chn );
        if ( context.addInstance( newDerivedAssociation ) ) {
            return newDerivedAssociation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Rel_ID;
    @Override
    public void setRel_ID(UniqueId ref_Rel_ID) throws XtumlException {
        checkLiving();
        if (ref_Rel_ID.inequality( this.ref_Rel_ID)) {
            final UniqueId oldValue = this.ref_Rel_ID;
            this.ref_Rel_ID = ref_Rel_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Rel_ID", oldValue, this.ref_Rel_ID));
            if ( !R214_relates_ClassAsDerivedOneSide().isEmpty() ) R214_relates_ClassAsDerivedOneSide().setRel_ID( ref_Rel_ID );
            if ( !R215_relates_ClassAsDerivedOtherSide().isEmpty() ) R215_relates_ClassAsDerivedOtherSide().setRel_ID( ref_Rel_ID );
        }
    }
    @Override
    public UniqueId getRel_ID() throws XtumlException {
        checkLiving();
        return ref_Rel_ID;
    }
    private String m_Rel_Chn;
    @Override
    public void setRel_Chn(String m_Rel_Chn) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Rel_Chn, this.m_Rel_Chn)) {
            final String oldValue = this.m_Rel_Chn;
            this.m_Rel_Chn = m_Rel_Chn;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Rel_Chn", oldValue, this.m_Rel_Chn));
        }
    }
    @Override
    public String getRel_Chn() throws XtumlException {
        checkLiving();
        return m_Rel_Chn;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getRel_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Association R206_is_a_Association_inst;
    @Override
    public void setR206_is_a_Association( Association inst ) {
        R206_is_a_Association_inst = inst;
    }
    @Override
    public Association R206_is_a_Association() throws XtumlException {
        return R206_is_a_Association_inst;
    }
    private ClassAsDerivedOneSide R214_relates_ClassAsDerivedOneSide_inst;
    @Override
    public void setR214_relates_ClassAsDerivedOneSide( ClassAsDerivedOneSide inst ) {
        R214_relates_ClassAsDerivedOneSide_inst = inst;
    }
    @Override
    public ClassAsDerivedOneSide R214_relates_ClassAsDerivedOneSide() throws XtumlException {
        return R214_relates_ClassAsDerivedOneSide_inst;
    }
    private ClassAsDerivedOtherSide R215_relates_ClassAsDerivedOtherSide_inst;
    @Override
    public void setR215_relates_ClassAsDerivedOtherSide( ClassAsDerivedOtherSide inst ) {
        R215_relates_ClassAsDerivedOtherSide_inst = inst;
    }
    @Override
    public ClassAsDerivedOtherSide R215_relates_ClassAsDerivedOtherSide() throws XtumlException {
        return R215_relates_ClassAsDerivedOtherSide_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public DerivedAssociation self() {
        return this;
    }

    @Override
    public DerivedAssociation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_DERIVEDASSOCIATION;
    }

}

class EmptyDerivedAssociation extends ModelInstance<DerivedAssociation,Sql> implements DerivedAssociation {

    // attributes
    public void setRel_ID( UniqueId ref_Rel_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getRel_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRel_Chn( String m_Rel_Chn ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getRel_Chn() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Association R206_is_a_Association() {
        return AssociationImpl.EMPTY_ASSOCIATION;
    }
    @Override
    public ClassAsDerivedOneSide R214_relates_ClassAsDerivedOneSide() {
        return ClassAsDerivedOneSideImpl.EMPTY_CLASSASDERIVEDONESIDE;
    }
    @Override
    public ClassAsDerivedOtherSide R215_relates_ClassAsDerivedOtherSide() {
        return ClassAsDerivedOtherSideImpl.EMPTY_CLASSASDERIVEDOTHERSIDE;
    }


    @Override
    public String getKeyLetters() {
        return DerivedAssociationImpl.KEY_LETTERS;
    }

    @Override
    public DerivedAssociation self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public DerivedAssociation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return DerivedAssociationImpl.EMPTY_DERIVEDASSOCIATION;
    }

}
