package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.loader.AttributeSerializerSet;
import io.ciera.tool.sql.loader.RealSerializer;
import io.ciera.tool.sql.loader.RealSerializerSet;
import io.ciera.tool.sql.loader.impl.AttributeSerializerSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class RealSerializerSetImpl extends InstanceSet<RealSerializerSet,RealSerializer> implements RealSerializerSet {

    public RealSerializerSetImpl() {
    }

    public RealSerializerSetImpl(Comparator<? super RealSerializer> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setValue( String m_value ) throws XtumlException {
        for ( RealSerializer realserializer : this ) realserializer.setValue( m_value );
    }
    @Override
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        for ( RealSerializer realserializer : this ) realserializer.setLoader_package( ref_loader_package );
    }
    @Override
    public void setClass_name( String ref_class_name ) throws XtumlException {
        for ( RealSerializer realserializer : this ) realserializer.setClass_name( ref_class_name );
    }
    @Override
    public void setAttr_name( String ref_attr_name ) throws XtumlException {
        for ( RealSerializer realserializer : this ) realserializer.setAttr_name( ref_attr_name );
    }
    @Override
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        for ( RealSerializer realserializer : this ) realserializer.setLoader_name( ref_loader_name );
    }


    // selections
    @Override
    public AttributeSerializerSet R3004_is_a_AttributeSerializer() throws XtumlException {
        AttributeSerializerSet attributeserializerset = new AttributeSerializerSetImpl();
        for ( RealSerializer realserializer : this ) attributeserializerset.add( realserializer.R3004_is_a_AttributeSerializer() );
        return attributeserializerset;
    }


    @Override
    public RealSerializer nullElement() {
        return RealSerializerImpl.EMPTY_REALSERIALIZER;
    }

    @Override
    public RealSerializerSet emptySet() {
      return new RealSerializerSetImpl();
    }

    @Override
    public RealSerializerSet emptySet(Comparator<? super RealSerializer> comp) {
      return new RealSerializerSetImpl(comp);
    }

    @Override
    public List<RealSerializer> elements() {
        return Arrays.asList(toArray(new RealSerializer[0]));
    }

}
