package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.type.TypeSet;
import io.ciera.tool.sql.architecture.type.impl.TypeSetImpl;
import io.ciera.tool.sql.loader.AttributeSerializerSet;
import io.ciera.tool.sql.loader.GeneralSerializer;
import io.ciera.tool.sql.loader.GeneralSerializerSet;
import io.ciera.tool.sql.loader.impl.AttributeSerializerSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class GeneralSerializerSetImpl extends InstanceSet<GeneralSerializerSet,GeneralSerializer> implements GeneralSerializerSet {

    public GeneralSerializerSetImpl() {
    }

    public GeneralSerializerSetImpl(Comparator<? super GeneralSerializer> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setType_name( String ref_type_name ) throws XtumlException {
        for ( GeneralSerializer generalserializer : this ) generalserializer.setType_name( ref_type_name );
    }
    @Override
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        for ( GeneralSerializer generalserializer : this ) generalserializer.setLoader_package( ref_loader_package );
    }
    @Override
    public void setAttr_name( String ref_attr_name ) throws XtumlException {
        for ( GeneralSerializer generalserializer : this ) generalserializer.setAttr_name( ref_attr_name );
    }
    @Override
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        for ( GeneralSerializer generalserializer : this ) generalserializer.setLoader_name( ref_loader_name );
    }
    @Override
    public void setValue( String m_value ) throws XtumlException {
        for ( GeneralSerializer generalserializer : this ) generalserializer.setValue( m_value );
    }
    @Override
    public void setClass_name( String ref_class_name ) throws XtumlException {
        for ( GeneralSerializer generalserializer : this ) generalserializer.setClass_name( ref_class_name );
    }
    @Override
    public void setType_package( String ref_type_package ) throws XtumlException {
        for ( GeneralSerializer generalserializer : this ) generalserializer.setType_package( ref_type_package );
    }


    // selections
    @Override
    public AttributeSerializerSet R3004_is_a_AttributeSerializer() throws XtumlException {
        AttributeSerializerSet attributeserializerset = new AttributeSerializerSetImpl();
        for ( GeneralSerializer generalserializer : this ) attributeserializerset.add( generalserializer.R3004_is_a_AttributeSerializer() );
        return attributeserializerset;
    }
    @Override
    public TypeSet R3014_Type() throws XtumlException {
        TypeSet typeset = new TypeSetImpl();
        for ( GeneralSerializer generalserializer : this ) typeset.add( generalserializer.R3014_Type() );
        return typeset;
    }


    @Override
    public GeneralSerializer nullElement() {
        return GeneralSerializerImpl.EMPTY_GENERALSERIALIZER;
    }

    @Override
    public GeneralSerializerSet emptySet() {
      return new GeneralSerializerSetImpl();
    }

    @Override
    public GeneralSerializerSet emptySet(Comparator<? super GeneralSerializer> comp) {
      return new GeneralSerializerSetImpl(comp);
    }

    @Override
    public List<GeneralSerializer> elements() {
        return Arrays.asList(toArray(new GeneralSerializer[0]));
    }

}
