package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.type.TypeSet;
import io.ciera.tool.sql.architecture.type.impl.TypeSetImpl;
import io.ciera.tool.sql.loader.AttributeLoaderSet;
import io.ciera.tool.sql.loader.GeneralLoader;
import io.ciera.tool.sql.loader.GeneralLoaderSet;
import io.ciera.tool.sql.loader.impl.AttributeLoaderSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class GeneralLoaderSetImpl extends InstanceSet<GeneralLoaderSet,GeneralLoader> implements GeneralLoaderSet {

    public GeneralLoaderSetImpl() {
    }

    public GeneralLoaderSetImpl(Comparator<? super GeneralLoader> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setType_name( String ref_type_name ) throws XtumlException {
        for ( GeneralLoader generalloader : this ) generalloader.setType_name( ref_type_name );
    }
    @Override
    public void setType_package( String ref_type_package ) throws XtumlException {
        for ( GeneralLoader generalloader : this ) generalloader.setType_package( ref_type_package );
    }
    @Override
    public void setLoad_value( boolean m_load_value ) throws XtumlException {
        for ( GeneralLoader generalloader : this ) generalloader.setLoad_value( m_load_value );
    }
    @Override
    public void setIndex( int ref_index ) throws XtumlException {
        for ( GeneralLoader generalloader : this ) generalloader.setIndex( ref_index );
    }
    @Override
    public void setClass_name( String ref_class_name ) throws XtumlException {
        for ( GeneralLoader generalloader : this ) generalloader.setClass_name( ref_class_name );
    }
    @Override
    public void setAttr_name( String ref_attr_name ) throws XtumlException {
        for ( GeneralLoader generalloader : this ) generalloader.setAttr_name( ref_attr_name );
    }
    @Override
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        for ( GeneralLoader generalloader : this ) generalloader.setLoader_name( ref_loader_name );
    }
    @Override
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        for ( GeneralLoader generalloader : this ) generalloader.setLoader_package( ref_loader_package );
    }


    // selections
    @Override
    public AttributeLoaderSet R3008_is_a_AttributeLoader() throws XtumlException {
        AttributeLoaderSet attributeloaderset = new AttributeLoaderSetImpl();
        for ( GeneralLoader generalloader : this ) attributeloaderset.add( generalloader.R3008_is_a_AttributeLoader() );
        return attributeloaderset;
    }
    @Override
    public TypeSet R3013_Type() throws XtumlException {
        TypeSet typeset = new TypeSetImpl();
        for ( GeneralLoader generalloader : this ) typeset.add( generalloader.R3013_Type() );
        return typeset;
    }


    @Override
    public GeneralLoader nullElement() {
        return GeneralLoaderImpl.EMPTY_GENERALLOADER;
    }

    @Override
    public GeneralLoaderSet emptySet() {
      return new GeneralLoaderSetImpl();
    }

    @Override
    public GeneralLoaderSet emptySet(Comparator<? super GeneralLoader> comp) {
      return new GeneralLoaderSetImpl(comp);
    }

    @Override
    public List<GeneralLoader> elements() {
        return Arrays.asList(toArray(new GeneralLoader[0]));
    }

}
