package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.type.Type;
import io.ciera.tool.sql.architecture.type.impl.TypeImpl;
import io.ciera.tool.sql.loader.AttributeLoader;
import io.ciera.tool.sql.loader.GeneralLoader;
import io.ciera.tool.sql.loader.impl.AttributeLoaderImpl;


public class GeneralLoaderImpl extends ModelInstance<GeneralLoader,Sql> implements GeneralLoader {

    public static final String KEY_LETTERS = "Z_GeneralLoader";
    public static final GeneralLoader EMPTY_GENERALLOADER = new EmptyGeneralLoader();

    private Sql context;

    // constructors
    private GeneralLoaderImpl( Sql context ) {
        this.context = context;
        ref_loader_name = "";
        ref_loader_package = "";
        ref_class_name = "";
        ref_index = 0;
        m_load_value = false;
        ref_attr_name = "";
        ref_type_name = "";
        ref_type_package = "";
        R3008_is_a_AttributeLoader_inst = AttributeLoaderImpl.EMPTY_ATTRIBUTELOADER;
        R3013_Type_inst = TypeImpl.EMPTY_TYPE;
    }

    private GeneralLoaderImpl( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String ref_class_name, int ref_index, boolean m_load_value, String ref_attr_name, String ref_type_name, String ref_type_package ) {
        super(instanceId);
        this.context = context;
        this.ref_loader_name = ref_loader_name;
        this.ref_loader_package = ref_loader_package;
        this.ref_class_name = ref_class_name;
        this.ref_index = ref_index;
        this.m_load_value = m_load_value;
        this.ref_attr_name = ref_attr_name;
        this.ref_type_name = ref_type_name;
        this.ref_type_package = ref_type_package;
        R3008_is_a_AttributeLoader_inst = AttributeLoaderImpl.EMPTY_ATTRIBUTELOADER;
        R3013_Type_inst = TypeImpl.EMPTY_TYPE;
    }

    public static GeneralLoader create( Sql context ) throws XtumlException {
        GeneralLoader newGeneralLoader = new GeneralLoaderImpl( context );
        if ( context.addInstance( newGeneralLoader ) ) {
            newGeneralLoader.getRunContext().addChange(new InstanceCreatedDelta(newGeneralLoader, KEY_LETTERS));
            return newGeneralLoader;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static GeneralLoader create( Sql context, String ref_loader_name, String ref_loader_package, String ref_class_name, int ref_index, boolean m_load_value, String ref_attr_name, String ref_type_name, String ref_type_package ) throws XtumlException {
        return create(context, UniqueId.random(), ref_loader_name, ref_loader_package, ref_class_name, ref_index, m_load_value, ref_attr_name, ref_type_name, ref_type_package);
    }

    public static GeneralLoader create( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String ref_class_name, int ref_index, boolean m_load_value, String ref_attr_name, String ref_type_name, String ref_type_package ) throws XtumlException {
        GeneralLoader newGeneralLoader = new GeneralLoaderImpl( context, instanceId, ref_loader_name, ref_loader_package, ref_class_name, ref_index, m_load_value, ref_attr_name, ref_type_name, ref_type_package );
        if ( context.addInstance( newGeneralLoader ) ) {
            return newGeneralLoader;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_loader_name;
    @Override
    public String getLoader_name() throws XtumlException {
        checkLiving();
        return ref_loader_name;
    }
    @Override
    public void setLoader_name(String ref_loader_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_loader_name, this.ref_loader_name)) {
            final String oldValue = this.ref_loader_name;
            this.ref_loader_name = ref_loader_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_name", oldValue, this.ref_loader_name));
        }
    }
    private String ref_loader_package;
    @Override
    public String getLoader_package() throws XtumlException {
        checkLiving();
        return ref_loader_package;
    }
    @Override
    public void setLoader_package(String ref_loader_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_loader_package, this.ref_loader_package)) {
            final String oldValue = this.ref_loader_package;
            this.ref_loader_package = ref_loader_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_package", oldValue, this.ref_loader_package));
        }
    }
    private String ref_class_name;
    @Override
    public void setClass_name(String ref_class_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_class_name, this.ref_class_name)) {
            final String oldValue = this.ref_class_name;
            this.ref_class_name = ref_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_name", oldValue, this.ref_class_name));
        }
    }
    @Override
    public String getClass_name() throws XtumlException {
        checkLiving();
        return ref_class_name;
    }
    private int ref_index;
    @Override
    public int getIndex() throws XtumlException {
        checkLiving();
        return ref_index;
    }
    @Override
    public void setIndex(int ref_index) throws XtumlException {
        checkLiving();
        if (ref_index != this.ref_index) {
            final int oldValue = this.ref_index;
            this.ref_index = ref_index;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_index", oldValue, this.ref_index));
        }
    }
    private boolean m_load_value;
    @Override
    public void setLoad_value(boolean m_load_value) throws XtumlException {
        checkLiving();
        if (m_load_value != this.m_load_value) {
            final boolean oldValue = this.m_load_value;
            this.m_load_value = m_load_value;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_load_value", oldValue, this.m_load_value));
        }
    }
    @Override
    public boolean getLoad_value() throws XtumlException {
        checkLiving();
        return m_load_value;
    }
    private String ref_attr_name;
    @Override
    public String getAttr_name() throws XtumlException {
        checkLiving();
        return ref_attr_name;
    }
    @Override
    public void setAttr_name(String ref_attr_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_attr_name, this.ref_attr_name)) {
            final String oldValue = this.ref_attr_name;
            this.ref_attr_name = ref_attr_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_attr_name", oldValue, this.ref_attr_name));
        }
    }
    private String ref_type_name;
    @Override
    public void setType_name(String ref_type_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_type_name, this.ref_type_name)) {
            final String oldValue = this.ref_type_name;
            this.ref_type_name = ref_type_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_type_name", oldValue, this.ref_type_name));
        }
    }
    @Override
    public String getType_name() throws XtumlException {
        checkLiving();
        return ref_type_name;
    }
    private String ref_type_package;
    @Override
    public void setType_package(String ref_type_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_type_package, this.ref_type_package)) {
            final String oldValue = this.ref_type_package;
            this.ref_type_package = ref_type_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_type_package", oldValue, this.ref_type_package));
        }
    }
    @Override
    public String getType_package() throws XtumlException {
        checkLiving();
        return ref_type_package;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getLoader_name(), getLoader_package(), getClass_name(), getIndex(), getAttr_name());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        AttributeLoader attr_loader = self().R3008_is_a_AttributeLoader();
        int value_index = attr_loader.getValue_index();
        context().T().include( "loader/t.generalloader.java", self(), value_index );
    }



    // static operations


    // events


    // selections
    private AttributeLoader R3008_is_a_AttributeLoader_inst;
    @Override
    public void setR3008_is_a_AttributeLoader( AttributeLoader inst ) {
        R3008_is_a_AttributeLoader_inst = inst;
    }
    @Override
    public AttributeLoader R3008_is_a_AttributeLoader() throws XtumlException {
        return R3008_is_a_AttributeLoader_inst;
    }
    private Type R3013_Type_inst;
    @Override
    public void setR3013_Type( Type inst ) {
        R3013_Type_inst = inst;
    }
    @Override
    public Type R3013_Type() throws XtumlException {
        return R3013_Type_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public GeneralLoader self() {
        return this;
    }

    @Override
    public GeneralLoader oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_GENERALLOADER;
    }

}

class EmptyGeneralLoader extends ModelInstance<GeneralLoader,Sql> implements GeneralLoader {

    // attributes
    public String getLoader_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLoader_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setClass_name( String ref_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getClass_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public int getIndex() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIndex( int ref_index ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setLoad_value( boolean m_load_value ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getLoad_value() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getAttr_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAttr_name( String ref_attr_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setType_name( String ref_type_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getType_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setType_package( String ref_type_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getType_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public AttributeLoader R3008_is_a_AttributeLoader() {
        return AttributeLoaderImpl.EMPTY_ATTRIBUTELOADER;
    }
    @Override
    public Type R3013_Type() {
        return TypeImpl.EMPTY_TYPE;
    }


    @Override
    public String getKeyLetters() {
        return GeneralLoaderImpl.KEY_LETTERS;
    }

    @Override
    public GeneralLoader self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public GeneralLoader oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return GeneralLoaderImpl.EMPTY_GENERALLOADER;
    }

}
