package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.loader.AttributeComparison;
import io.ciera.tool.sql.loader.AttributeComparisonSet;
import io.ciera.tool.sql.loader.BatchRelator;
import io.ciera.tool.sql.loader.PopulationLoader;
import io.ciera.tool.sql.loader.impl.AttributeComparisonSetImpl;
import io.ciera.tool.sql.loader.impl.PopulationLoaderImpl;


public class BatchRelatorImpl extends ModelInstance<BatchRelator,Sql> implements BatchRelator {

    public static final String KEY_LETTERS = "Z_BatchRelator";
    public static final BatchRelator EMPTY_BATCHRELATOR = new EmptyBatchRelator();

    private Sql context;

    // constructors
    private BatchRelatorImpl( Sql context ) {
        this.context = context;
        ref_loader_name = "";
        ref_loader_package = "";
        m_rel_name = "";
        m_form_name = "";
        m_part_name = "";
        m_unconditional = false;
        m_id_num = 0;
        R3011_invoked_by_PopulationLoader_inst = PopulationLoaderImpl.EMPTY_POPULATIONLOADER;
        R3012_selects_participant_by_evaluating_AttributeComparison_set = new AttributeComparisonSetImpl();
    }

    private BatchRelatorImpl( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String m_rel_name, String m_form_name, String m_part_name, boolean m_unconditional, int m_id_num ) {
        super(instanceId);
        this.context = context;
        this.ref_loader_name = ref_loader_name;
        this.ref_loader_package = ref_loader_package;
        this.m_rel_name = m_rel_name;
        this.m_form_name = m_form_name;
        this.m_part_name = m_part_name;
        this.m_unconditional = m_unconditional;
        this.m_id_num = m_id_num;
        R3011_invoked_by_PopulationLoader_inst = PopulationLoaderImpl.EMPTY_POPULATIONLOADER;
        R3012_selects_participant_by_evaluating_AttributeComparison_set = new AttributeComparisonSetImpl();
    }

    public static BatchRelator create( Sql context ) throws XtumlException {
        BatchRelator newBatchRelator = new BatchRelatorImpl( context );
        if ( context.addInstance( newBatchRelator ) ) {
            newBatchRelator.getRunContext().addChange(new InstanceCreatedDelta(newBatchRelator, KEY_LETTERS));
            return newBatchRelator;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static BatchRelator create( Sql context, String ref_loader_name, String ref_loader_package, String m_rel_name, String m_form_name, String m_part_name, boolean m_unconditional, int m_id_num ) throws XtumlException {
        return create(context, UniqueId.random(), ref_loader_name, ref_loader_package, m_rel_name, m_form_name, m_part_name, m_unconditional, m_id_num);
    }

    public static BatchRelator create( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String m_rel_name, String m_form_name, String m_part_name, boolean m_unconditional, int m_id_num ) throws XtumlException {
        BatchRelator newBatchRelator = new BatchRelatorImpl( context, instanceId, ref_loader_name, ref_loader_package, m_rel_name, m_form_name, m_part_name, m_unconditional, m_id_num );
        if ( context.addInstance( newBatchRelator ) ) {
            return newBatchRelator;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_loader_name;
    @Override
    public String getLoader_name() throws XtumlException {
        checkLiving();
        return ref_loader_name;
    }
    @Override
    public void setLoader_name(String ref_loader_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_loader_name, this.ref_loader_name)) {
            final String oldValue = this.ref_loader_name;
            this.ref_loader_name = ref_loader_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_name", oldValue, this.ref_loader_name));
            if ( !R3012_selects_participant_by_evaluating_AttributeComparison().isEmpty() ) R3012_selects_participant_by_evaluating_AttributeComparison().setLoader_name( ref_loader_name );
        }
    }
    private String ref_loader_package;
    @Override
    public String getLoader_package() throws XtumlException {
        checkLiving();
        return ref_loader_package;
    }
    @Override
    public void setLoader_package(String ref_loader_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_loader_package, this.ref_loader_package)) {
            final String oldValue = this.ref_loader_package;
            this.ref_loader_package = ref_loader_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_package", oldValue, this.ref_loader_package));
            if ( !R3012_selects_participant_by_evaluating_AttributeComparison().isEmpty() ) R3012_selects_participant_by_evaluating_AttributeComparison().setLoader_package( ref_loader_package );
        }
    }
    private String m_rel_name;
    @Override
    public void setRel_name(String m_rel_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_rel_name, this.m_rel_name)) {
            final String oldValue = this.m_rel_name;
            this.m_rel_name = m_rel_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_rel_name", oldValue, this.m_rel_name));
            if ( !R3012_selects_participant_by_evaluating_AttributeComparison().isEmpty() ) R3012_selects_participant_by_evaluating_AttributeComparison().setRel_name( m_rel_name );
        }
    }
    @Override
    public String getRel_name() throws XtumlException {
        checkLiving();
        return m_rel_name;
    }
    private String m_form_name;
    @Override
    public void setForm_name(String m_form_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_form_name, this.m_form_name)) {
            final String oldValue = this.m_form_name;
            this.m_form_name = m_form_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_form_name", oldValue, this.m_form_name));
        }
    }
    @Override
    public String getForm_name() throws XtumlException {
        checkLiving();
        return m_form_name;
    }
    private String m_part_name;
    @Override
    public String getPart_name() throws XtumlException {
        checkLiving();
        return m_part_name;
    }
    @Override
    public void setPart_name(String m_part_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_part_name, this.m_part_name)) {
            final String oldValue = this.m_part_name;
            this.m_part_name = m_part_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_part_name", oldValue, this.m_part_name));
        }
    }
    private boolean m_unconditional;
    @Override
    public boolean getUnconditional() throws XtumlException {
        checkLiving();
        return m_unconditional;
    }
    @Override
    public void setUnconditional(boolean m_unconditional) throws XtumlException {
        checkLiving();
        if (m_unconditional != this.m_unconditional) {
            final boolean oldValue = this.m_unconditional;
            this.m_unconditional = m_unconditional;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_unconditional", oldValue, this.m_unconditional));
        }
    }
    private int m_id_num;
    @Override
    public void setId_num(int m_id_num) throws XtumlException {
        checkLiving();
        if (m_id_num != this.m_id_num) {
            final int oldValue = this.m_id_num;
            this.m_id_num = m_id_num;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_id_num", oldValue, this.m_id_num));
        }
    }
    @Override
    public int getId_num() throws XtumlException {
        checkLiving();
        return m_id_num;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getLoader_name(), getLoader_package(), getRel_name());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().push_buffer();
        AttributeComparison attr_comp = self().R3012_selects_participant_by_evaluating_AttributeComparison().any();
        AttributeComparison prev_attr_comp = attr_comp.R3018_succeeds_AttributeComparison();
        while ( !prev_attr_comp.isEmpty() ) {
            attr_comp = prev_attr_comp;
            prev_attr_comp = attr_comp.R3018_succeeds_AttributeComparison();
        }
        String separator = "";
        while ( !attr_comp.isEmpty() ) {
            context().T().append( separator );
            attr_comp.render();
            if ( 0 == self().getId_num() ) {
                separator = " && ";
            }
            else {
                separator = ", ";
            }
            attr_comp = attr_comp.R3018_precedes_AttributeComparison();
        }
        String attribute_comparisons = context().T().body();
        context().T().pop_buffer();
        context().T().include( "loader/t.batchrelator.java", attribute_comparisons, self() );
    }



    // static operations


    // events


    // selections
    private PopulationLoader R3011_invoked_by_PopulationLoader_inst;
    @Override
    public void setR3011_invoked_by_PopulationLoader( PopulationLoader inst ) {
        R3011_invoked_by_PopulationLoader_inst = inst;
    }
    @Override
    public PopulationLoader R3011_invoked_by_PopulationLoader() throws XtumlException {
        return R3011_invoked_by_PopulationLoader_inst;
    }
    private AttributeComparisonSet R3012_selects_participant_by_evaluating_AttributeComparison_set;
    @Override
    public void addR3012_selects_participant_by_evaluating_AttributeComparison( AttributeComparison inst ) {
        R3012_selects_participant_by_evaluating_AttributeComparison_set.add(inst);
    }
    @Override
    public void removeR3012_selects_participant_by_evaluating_AttributeComparison( AttributeComparison inst ) {
        R3012_selects_participant_by_evaluating_AttributeComparison_set.remove(inst);
    }
    @Override
    public AttributeComparisonSet R3012_selects_participant_by_evaluating_AttributeComparison() throws XtumlException {
        return R3012_selects_participant_by_evaluating_AttributeComparison_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public BatchRelator self() {
        return this;
    }

    @Override
    public BatchRelator oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_BATCHRELATOR;
    }

}

class EmptyBatchRelator extends ModelInstance<BatchRelator,Sql> implements BatchRelator {

    // attributes
    public String getLoader_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLoader_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setRel_name( String m_rel_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getRel_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setForm_name( String m_form_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getForm_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getPart_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPart_name( String m_part_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getUnconditional() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setUnconditional( boolean m_unconditional ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setId_num( int m_id_num ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getId_num() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public PopulationLoader R3011_invoked_by_PopulationLoader() {
        return PopulationLoaderImpl.EMPTY_POPULATIONLOADER;
    }
    @Override
    public AttributeComparisonSet R3012_selects_participant_by_evaluating_AttributeComparison() {
        return (new AttributeComparisonSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return BatchRelatorImpl.KEY_LETTERS;
    }

    @Override
    public BatchRelator self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public BatchRelator oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return BatchRelatorImpl.EMPTY_BATCHRELATOR;
    }

}
