package io.ciera.tool.sql.loader.associationserializerloader.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.loader.associationserializerloader.AssociationSerializerLoader;
import io.ciera.tool.sql.loader.associationserializerloader.ReferredToClassProxy;
import io.ciera.tool.sql.loader.associationserializerloader.SingleInstanceRef;
import io.ciera.tool.sql.loader.associationserializerloader.impl.ReferredToClassProxyImpl;
import io.ciera.tool.sql.loader.impl.UniqueIDSerializerImpl;


public class SingleInstanceRefImpl extends ModelInstance<SingleInstanceRef,Sql> implements SingleInstanceRef {

    public static final String KEY_LETTERS = "SingleInstanceRef";
    public static final SingleInstanceRef EMPTY_SINGLEINSTANCEREF = new EmptySingleInstanceRef();

    private Sql context;

    // constructors
    private SingleInstanceRefImpl( Sql context ) {
        this.context = context;
        ref_id = UniqueId.random();
        R3028_is_a_ReferredToClassProxy_inst = ReferredToClassProxyImpl.EMPTY_REFERREDTOCLASSPROXY;
    }

    private SingleInstanceRefImpl( Sql context, UniqueId instanceId, UniqueId ref_id ) {
        super(instanceId);
        this.context = context;
        this.ref_id = ref_id;
        R3028_is_a_ReferredToClassProxy_inst = ReferredToClassProxyImpl.EMPTY_REFERREDTOCLASSPROXY;
    }

    public static SingleInstanceRef create( Sql context ) throws XtumlException {
        SingleInstanceRef newSingleInstanceRef = new SingleInstanceRefImpl( context );
        if ( context.addInstance( newSingleInstanceRef ) ) {
            newSingleInstanceRef.getRunContext().addChange(new InstanceCreatedDelta(newSingleInstanceRef, KEY_LETTERS));
            return newSingleInstanceRef;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static SingleInstanceRef create( Sql context, UniqueId ref_id ) throws XtumlException {
        return create(context, UniqueId.random(), ref_id);
    }

    public static SingleInstanceRef create( Sql context, UniqueId instanceId, UniqueId ref_id ) throws XtumlException {
        SingleInstanceRef newSingleInstanceRef = new SingleInstanceRefImpl( context, instanceId, ref_id );
        if ( context.addInstance( newSingleInstanceRef ) ) {
            return newSingleInstanceRef;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_id;
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return ref_id;
    }
    @Override
    public void setId(UniqueId ref_id) throws XtumlException {
        checkLiving();
        if (ref_id.inequality( this.ref_id)) {
            final UniqueId oldValue = this.ref_id;
            this.ref_id = ref_id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_id", oldValue, this.ref_id));
        }
    }


    // instance identifiers

    // operations
    @Override
    public void render_init( final String p_link_type ) throws XtumlException {
        ReferredToClassProxy ref = self().R3028_is_a_ReferredToClassProxy();
        AssociationSerializerLoader serializer = ref.get_serializer();
        String class_name = ref.get_referring_class();
        String selector_name = ref.getReference_name();
        String link_type = p_link_type;
        String rnum_str = context().STRING().itoa( serializer.getRel_num() );
        context().T().include( "loader/t.singlelinkserializer.init.java", class_name, link_type, rnum_str, selector_name );
    }

    @Override
    public void render_serialization() throws XtumlException {
        ReferredToClassProxy ref = self().R3028_is_a_ReferredToClassProxy();
        AssociationSerializerLoader serializer = ref.get_serializer();
        String referring_class = ref.get_referring_class();
        context().T().push_buffer();
        String selector = ref.getReference_name() + "().";
        new UniqueIDSerializerImpl.CLASS(context()).do_render( referring_class, selector + "getInstanceId()" );
        String ref_out = context().T().body();
        context().T().pop_buffer();
        context().T().include( "loader/t.linkserializer.reference.java", ref_out );
    }



    // static operations


    // events


    // selections
    private ReferredToClassProxy R3028_is_a_ReferredToClassProxy_inst;
    @Override
    public void setR3028_is_a_ReferredToClassProxy( ReferredToClassProxy inst ) {
        R3028_is_a_ReferredToClassProxy_inst = inst;
    }
    @Override
    public ReferredToClassProxy R3028_is_a_ReferredToClassProxy() throws XtumlException {
        return R3028_is_a_ReferredToClassProxy_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public SingleInstanceRef self() {
        return this;
    }

    @Override
    public SingleInstanceRef oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_SINGLEINSTANCEREF;
    }

}

class EmptySingleInstanceRef extends ModelInstance<SingleInstanceRef,Sql> implements SingleInstanceRef {

    // attributes
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId( UniqueId ref_id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render_init( final String p_link_type ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_serialization() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public ReferredToClassProxy R3028_is_a_ReferredToClassProxy() {
        return ReferredToClassProxyImpl.EMPTY_REFERREDTOCLASSPROXY;
    }


    @Override
    public String getKeyLetters() {
        return SingleInstanceRefImpl.KEY_LETTERS;
    }

    @Override
    public SingleInstanceRef self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public SingleInstanceRef oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return SingleInstanceRefImpl.EMPTY_SINGLEINSTANCEREF;
    }

}
