package io.ciera.tool.sql.loader.associationserializerloader.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.ActionHome;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.loader.associationserializerloader.AssociationSerializerLoader;
import io.ciera.tool.sql.loader.associationserializerloader.MultiInstanceRef;
import io.ciera.tool.sql.loader.associationserializerloader.ReferredToClassProxy;
import io.ciera.tool.sql.loader.associationserializerloader.SingleInstanceRef;
import io.ciera.tool.sql.loader.associationserializerloader.SingleReferrerAssoc;
import io.ciera.tool.sql.loader.associationserializerloader.impl.MultiInstanceRefImpl;
import io.ciera.tool.sql.loader.associationserializerloader.impl.ReferredToClassProxyImpl;
import io.ciera.tool.sql.loader.associationserializerloader.impl.SingleInstanceRefImpl;
import io.ciera.tool.sql.loader.associationserializerloader.impl.SingleReferrerAssocImpl;


public class ReferredToClassProxyImpl extends ModelInstance<ReferredToClassProxy,Sql> implements ReferredToClassProxy {

    public static final String KEY_LETTERS = "ReferredToClassProxy";
    public static final ReferredToClassProxy EMPTY_REFERREDTOCLASSPROXY = new EmptyReferredToClassProxy();

    private Sql context;

    // constructors
    private ReferredToClassProxyImpl( Sql context ) {
        this.context = context;
        m_id = UniqueId.random();
        m_referred_to_class_name = "";
        m_reference_name = "";
        m_rel_name = "";
        ref_rel_num = 0;
        R3028_is_a_MultiInstanceRef_inst = MultiInstanceRefImpl.EMPTY_MULTIINSTANCEREF;
        R3028_is_a_SingleInstanceRef_inst = SingleInstanceRefImpl.EMPTY_SINGLEINSTANCEREF;
        R3030_supplies_2nd_ID_code_for_SingleReferrerAssoc_inst = SingleReferrerAssocImpl.EMPTY_SINGLEREFERRERASSOC;
        R3035_supplies_3rd_ID_code_for_SingleReferrerAssoc_inst = SingleReferrerAssocImpl.EMPTY_SINGLEREFERRERASSOC;
    }

    private ReferredToClassProxyImpl( Sql context, UniqueId instanceId, UniqueId m_id, String m_referred_to_class_name, String m_reference_name, String m_rel_name, int ref_rel_num ) {
        super(instanceId);
        this.context = context;
        this.m_id = m_id;
        this.m_referred_to_class_name = m_referred_to_class_name;
        this.m_reference_name = m_reference_name;
        this.m_rel_name = m_rel_name;
        this.ref_rel_num = ref_rel_num;
        R3028_is_a_MultiInstanceRef_inst = MultiInstanceRefImpl.EMPTY_MULTIINSTANCEREF;
        R3028_is_a_SingleInstanceRef_inst = SingleInstanceRefImpl.EMPTY_SINGLEINSTANCEREF;
        R3030_supplies_2nd_ID_code_for_SingleReferrerAssoc_inst = SingleReferrerAssocImpl.EMPTY_SINGLEREFERRERASSOC;
        R3035_supplies_3rd_ID_code_for_SingleReferrerAssoc_inst = SingleReferrerAssocImpl.EMPTY_SINGLEREFERRERASSOC;
    }

    public static ReferredToClassProxy create( Sql context ) throws XtumlException {
        ReferredToClassProxy newReferredToClassProxy = new ReferredToClassProxyImpl( context );
        if ( context.addInstance( newReferredToClassProxy ) ) {
            newReferredToClassProxy.getRunContext().addChange(new InstanceCreatedDelta(newReferredToClassProxy, KEY_LETTERS));
            return newReferredToClassProxy;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ReferredToClassProxy create( Sql context, UniqueId m_id, String m_referred_to_class_name, String m_reference_name, String m_rel_name, int ref_rel_num ) throws XtumlException {
        return create(context, UniqueId.random(), m_id, m_referred_to_class_name, m_reference_name, m_rel_name, ref_rel_num);
    }

    public static ReferredToClassProxy create( Sql context, UniqueId instanceId, UniqueId m_id, String m_referred_to_class_name, String m_reference_name, String m_rel_name, int ref_rel_num ) throws XtumlException {
        ReferredToClassProxy newReferredToClassProxy = new ReferredToClassProxyImpl( context, instanceId, m_id, m_referred_to_class_name, m_reference_name, m_rel_name, ref_rel_num );
        if ( context.addInstance( newReferredToClassProxy ) ) {
            return newReferredToClassProxy;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_id;
    @Override
    public void setId(UniqueId m_id) throws XtumlException {
        checkLiving();
        if (m_id.inequality( this.m_id)) {
            final UniqueId oldValue = this.m_id;
            this.m_id = m_id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_id", oldValue, this.m_id));
            if ( !R3028_is_a_SingleInstanceRef().isEmpty() ) R3028_is_a_SingleInstanceRef().setId( m_id );
            if ( !R3028_is_a_MultiInstanceRef().isEmpty() ) R3028_is_a_MultiInstanceRef().setId( m_id );
        }
    }
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return m_id;
    }
    private String m_referred_to_class_name;
    @Override
    public void setReferred_to_class_name(String m_referred_to_class_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_referred_to_class_name, this.m_referred_to_class_name)) {
            final String oldValue = this.m_referred_to_class_name;
            this.m_referred_to_class_name = m_referred_to_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_referred_to_class_name", oldValue, this.m_referred_to_class_name));
        }
    }
    @Override
    public String getReferred_to_class_name() throws XtumlException {
        checkLiving();
        return m_referred_to_class_name;
    }
    private String m_reference_name;
    @Override
    public String getReference_name() throws XtumlException {
        checkLiving();
        return m_reference_name;
    }
    @Override
    public void setReference_name(String m_reference_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_reference_name, this.m_reference_name)) {
            final String oldValue = this.m_reference_name;
            this.m_reference_name = m_reference_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_reference_name", oldValue, this.m_reference_name));
        }
    }
    private String m_rel_name;
    @Override
    public String getRel_name() throws XtumlException {
        checkLiving();
        return m_rel_name;
    }
    @Override
    public void setRel_name(String m_rel_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_rel_name, this.m_rel_name)) {
            final String oldValue = this.m_rel_name;
            this.m_rel_name = m_rel_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_rel_name", oldValue, this.m_rel_name));
        }
    }
    private int ref_rel_num;
    @Override
    public int getRel_num() throws XtumlException {
        checkLiving();
        return ref_rel_num;
    }
    @Override
    public void setRel_num(int ref_rel_num) throws XtumlException {
        checkLiving();
        if (ref_rel_num != this.ref_rel_num) {
            final int oldValue = this.ref_rel_num;
            this.ref_rel_num = ref_rel_num;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_rel_num", oldValue, this.ref_rel_num));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public String get_referring_class() throws XtumlException {
        SingleReferrerAssoc referrer = self().R3030_supplies_2nd_ID_code_for_SingleReferrerAssoc();
        if ( referrer.isEmpty() ) {
            referrer = self().R3035_supplies_3rd_ID_code_for_SingleReferrerAssoc();
        }
        return referrer.getReferring_class_name();
    }

    @Override
    public AssociationSerializerLoader get_serializer() throws XtumlException {
        AssociationSerializerLoader serializer = self().R3030_supplies_2nd_ID_code_for_SingleReferrerAssoc().R3029_is_a_AssociationSerializerLoader();
        if ( serializer.isEmpty() ) {
            serializer = self().R3035_supplies_3rd_ID_code_for_SingleReferrerAssoc().R3029_is_a_AssociationSerializerLoader();
        }
        return serializer;
    }

    @Override
    public void render_init( final String p_link_type ) throws XtumlException {
        SingleInstanceRef sref = self().R3028_is_a_SingleInstanceRef();
        if ( !sref.isEmpty() ) {
            sref.render_init( p_link_type );
        }
        else {
            MultiInstanceRef mref = self().R3028_is_a_MultiInstanceRef();
            mref.render_init( p_link_type );
        }
    }

    @Override
    public void render_relate( final int p_index,  final boolean p_declare_type ) throws XtumlException {
        AssociationSerializerLoader serializer = self().get_serializer();
        String form_class = self().get_referring_class();
        String formvar = form_class + context().STRING().itoa( serializer.getRel_num() );
        String part_class = self().getReferred_to_class_name();
        String partvar = ( part_class + context().STRING().itoa( serializer.getRel_num() ) ) + "_p";
        String vtyp = part_class + " ";
        if ( !p_declare_type ) {
            vtyp = "";
        }
        int index = p_index;
        String rel_name = self().getRel_name();
        context().T().include( "loader/t.linkloader.ref.relate.java", form_class, formvar, index, part_class, partvar, rel_name, vtyp );
    }

    @Override
    public void render_serialization() throws XtumlException {
        SingleInstanceRef sref = self().R3028_is_a_SingleInstanceRef();
        if ( !sref.isEmpty() ) {
            sref.render_serialization();
        }
        else {
            MultiInstanceRef mref = self().R3028_is_a_MultiInstanceRef();
            mref.render_serialization();
        }
    }



    // static operations
    public static class CLASS extends ActionHome<Sql> {

        public CLASS( Sql context ) {
            super( context );
        }

        public ReferredToClassProxy create( final String p_refname,  final String p_class,  final String p_rel_name ) throws XtumlException {
            ReferredToClassProxy ref = ReferredToClassProxyImpl.create( context() );
            ref.setReference_name(p_refname);
            ref.setReferred_to_class_name(p_class);
            ref.setRel_name(p_rel_name);
            return ref;
        }



    }


    // events


    // selections
    private MultiInstanceRef R3028_is_a_MultiInstanceRef_inst;
    @Override
    public void setR3028_is_a_MultiInstanceRef( MultiInstanceRef inst ) {
        R3028_is_a_MultiInstanceRef_inst = inst;
    }
    @Override
    public MultiInstanceRef R3028_is_a_MultiInstanceRef() throws XtumlException {
        return R3028_is_a_MultiInstanceRef_inst;
    }
    private SingleInstanceRef R3028_is_a_SingleInstanceRef_inst;
    @Override
    public void setR3028_is_a_SingleInstanceRef( SingleInstanceRef inst ) {
        R3028_is_a_SingleInstanceRef_inst = inst;
    }
    @Override
    public SingleInstanceRef R3028_is_a_SingleInstanceRef() throws XtumlException {
        return R3028_is_a_SingleInstanceRef_inst;
    }
    private SingleReferrerAssoc R3030_supplies_2nd_ID_code_for_SingleReferrerAssoc_inst;
    @Override
    public void setR3030_supplies_2nd_ID_code_for_SingleReferrerAssoc( SingleReferrerAssoc inst ) {
        R3030_supplies_2nd_ID_code_for_SingleReferrerAssoc_inst = inst;
    }
    @Override
    public SingleReferrerAssoc R3030_supplies_2nd_ID_code_for_SingleReferrerAssoc() throws XtumlException {
        return R3030_supplies_2nd_ID_code_for_SingleReferrerAssoc_inst;
    }
    private SingleReferrerAssoc R3035_supplies_3rd_ID_code_for_SingleReferrerAssoc_inst;
    @Override
    public void setR3035_supplies_3rd_ID_code_for_SingleReferrerAssoc( SingleReferrerAssoc inst ) {
        R3035_supplies_3rd_ID_code_for_SingleReferrerAssoc_inst = inst;
    }
    @Override
    public SingleReferrerAssoc R3035_supplies_3rd_ID_code_for_SingleReferrerAssoc() throws XtumlException {
        return R3035_supplies_3rd_ID_code_for_SingleReferrerAssoc_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ReferredToClassProxy self() {
        return this;
    }

    @Override
    public ReferredToClassProxy oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_REFERREDTOCLASSPROXY;
    }

}

class EmptyReferredToClassProxy extends ModelInstance<ReferredToClassProxy,Sql> implements ReferredToClassProxy {

    // attributes
    public void setId( UniqueId m_id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setReferred_to_class_name( String m_referred_to_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getReferred_to_class_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getReference_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setReference_name( String m_reference_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getRel_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRel_name( String m_rel_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getRel_num() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRel_num( int ref_rel_num ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public String get_referring_class() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public AssociationSerializerLoader get_serializer() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_init( final String p_link_type ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_relate( final int p_index,  final boolean p_declare_type ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_serialization() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public MultiInstanceRef R3028_is_a_MultiInstanceRef() {
        return MultiInstanceRefImpl.EMPTY_MULTIINSTANCEREF;
    }
    @Override
    public SingleInstanceRef R3028_is_a_SingleInstanceRef() {
        return SingleInstanceRefImpl.EMPTY_SINGLEINSTANCEREF;
    }
    @Override
    public SingleReferrerAssoc R3030_supplies_2nd_ID_code_for_SingleReferrerAssoc() {
        return SingleReferrerAssocImpl.EMPTY_SINGLEREFERRERASSOC;
    }
    @Override
    public SingleReferrerAssoc R3035_supplies_3rd_ID_code_for_SingleReferrerAssoc() {
        return SingleReferrerAssocImpl.EMPTY_SINGLEREFERRERASSOC;
    }


    @Override
    public String getKeyLetters() {
        return ReferredToClassProxyImpl.KEY_LETTERS;
    }

    @Override
    public ReferredToClassProxy self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ReferredToClassProxy oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ReferredToClassProxyImpl.EMPTY_REFERREDTOCLASSPROXY;
    }

}
