package io.ciera.tool.sql.loader.associationserializerloader.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.loader.associationserializerloader.AssociationSerializerLoader;
import io.ciera.tool.sql.loader.associationserializerloader.MultiInstanceRef;
import io.ciera.tool.sql.loader.associationserializerloader.ReferredToClassProxy;
import io.ciera.tool.sql.loader.associationserializerloader.impl.ReferredToClassProxyImpl;
import io.ciera.tool.sql.loader.impl.UniqueIDSerializerImpl;


public class MultiInstanceRefImpl extends ModelInstance<MultiInstanceRef,Sql> implements MultiInstanceRef {

    public static final String KEY_LETTERS = "MultiInstanceRef";
    public static final MultiInstanceRef EMPTY_MULTIINSTANCEREF = new EmptyMultiInstanceRef();

    private Sql context;

    // constructors
    private MultiInstanceRefImpl( Sql context ) {
        this.context = context;
        ref_id = UniqueId.random();
        m_set_type_name = "";
        R3028_is_a_ReferredToClassProxy_inst = ReferredToClassProxyImpl.EMPTY_REFERREDTOCLASSPROXY;
    }

    private MultiInstanceRefImpl( Sql context, UniqueId instanceId, UniqueId ref_id, String m_set_type_name ) {
        super(instanceId);
        this.context = context;
        this.ref_id = ref_id;
        this.m_set_type_name = m_set_type_name;
        R3028_is_a_ReferredToClassProxy_inst = ReferredToClassProxyImpl.EMPTY_REFERREDTOCLASSPROXY;
    }

    public static MultiInstanceRef create( Sql context ) throws XtumlException {
        MultiInstanceRef newMultiInstanceRef = new MultiInstanceRefImpl( context );
        if ( context.addInstance( newMultiInstanceRef ) ) {
            newMultiInstanceRef.getRunContext().addChange(new InstanceCreatedDelta(newMultiInstanceRef, KEY_LETTERS));
            return newMultiInstanceRef;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static MultiInstanceRef create( Sql context, UniqueId ref_id, String m_set_type_name ) throws XtumlException {
        return create(context, UniqueId.random(), ref_id, m_set_type_name);
    }

    public static MultiInstanceRef create( Sql context, UniqueId instanceId, UniqueId ref_id, String m_set_type_name ) throws XtumlException {
        MultiInstanceRef newMultiInstanceRef = new MultiInstanceRefImpl( context, instanceId, ref_id, m_set_type_name );
        if ( context.addInstance( newMultiInstanceRef ) ) {
            return newMultiInstanceRef;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_id;
    @Override
    public void setId(UniqueId ref_id) throws XtumlException {
        checkLiving();
        if (ref_id.inequality( this.ref_id)) {
            final UniqueId oldValue = this.ref_id;
            this.ref_id = ref_id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_id", oldValue, this.ref_id));
        }
    }
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return ref_id;
    }
    private String m_set_type_name;
    @Override
    public String getSet_type_name() throws XtumlException {
        checkLiving();
        return m_set_type_name;
    }
    @Override
    public void setSet_type_name(String m_set_type_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_set_type_name, this.m_set_type_name)) {
            final String oldValue = this.m_set_type_name;
            this.m_set_type_name = m_set_type_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_set_type_name", oldValue, this.m_set_type_name));
        }
    }


    // instance identifiers

    // operations
    @Override
    public void render_init( final String p_link_type ) throws XtumlException {
        ReferredToClassProxy ref = self().R3028_is_a_ReferredToClassProxy();
        AssociationSerializerLoader serializer = ref.get_serializer();
        String referring_class = ref.get_referring_class();
        String referred_name = ref.getReferred_to_class_name();
        String selector_name = ref.getReference_name();
        String set_type_name = self().getSet_type_name();
        String iterator = "link";
        String link_type = p_link_type;
        String rnum_str = context().STRING().itoa( serializer.getRel_num() );
        context().T().include( "loader/t.multilinkserializer.init.java", iterator, link_type, referred_name, referring_class, rnum_str, selector_name, set_type_name );
    }

    @Override
    public void render_serialization() throws XtumlException {
        ReferredToClassProxy ref = self().R3028_is_a_ReferredToClassProxy();
        AssociationSerializerLoader serializer = ref.get_serializer();
        String referred_name = ref.getReferred_to_class_name();
        String selector_name = ref.getReference_name();
        String iterator = "link";
        context().T().push_buffer();
        new UniqueIDSerializerImpl.CLASS(context()).do_render( iterator, "getInstanceId()" );
        String ref_out = context().T().body();
        context().T().pop_buffer();
        context().T().include( "loader/t.linkserializer.reference.java", ref_out );
    }



    // static operations


    // events


    // selections
    private ReferredToClassProxy R3028_is_a_ReferredToClassProxy_inst;
    @Override
    public void setR3028_is_a_ReferredToClassProxy( ReferredToClassProxy inst ) {
        R3028_is_a_ReferredToClassProxy_inst = inst;
    }
    @Override
    public ReferredToClassProxy R3028_is_a_ReferredToClassProxy() throws XtumlException {
        return R3028_is_a_ReferredToClassProxy_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public MultiInstanceRef self() {
        return this;
    }

    @Override
    public MultiInstanceRef oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_MULTIINSTANCEREF;
    }

}

class EmptyMultiInstanceRef extends ModelInstance<MultiInstanceRef,Sql> implements MultiInstanceRef {

    // attributes
    public void setId( UniqueId ref_id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getSet_type_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSet_type_name( String m_set_type_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render_init( final String p_link_type ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_serialization() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public ReferredToClassProxy R3028_is_a_ReferredToClassProxy() {
        return ReferredToClassProxyImpl.EMPTY_REFERREDTOCLASSPROXY;
    }


    @Override
    public String getKeyLetters() {
        return MultiInstanceRefImpl.KEY_LETTERS;
    }

    @Override
    public MultiInstanceRef self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public MultiInstanceRef oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return MultiInstanceRefImpl.EMPTY_MULTIINSTANCEREF;
    }

}
