package io.ciera.tool.sql.architecture.type.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.file.FileSet;
import io.ciera.tool.sql.architecture.file.impl.FileSetImpl;
import io.ciera.tool.sql.architecture.type.TypeSet;
import io.ciera.tool.sql.architecture.type.UserDefinedType;
import io.ciera.tool.sql.architecture.type.UserDefinedTypeSet;
import io.ciera.tool.sql.architecture.type.impl.TypeSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class UserDefinedTypeSetImpl extends InstanceSet<UserDefinedTypeSet,UserDefinedType> implements UserDefinedTypeSet {

    public UserDefinedTypeSetImpl() {
    }

    public UserDefinedTypeSetImpl(Comparator<? super UserDefinedType> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setName( String ref_name ) throws XtumlException {
        for ( UserDefinedType userdefinedtype : this ) userdefinedtype.setName( ref_name );
    }
    @Override
    public void setBase_type_name( String ref_base_type_name ) throws XtumlException {
        for ( UserDefinedType userdefinedtype : this ) userdefinedtype.setBase_type_name( ref_base_type_name );
    }
    @Override
    public void setPackage( String ref_package ) throws XtumlException {
        for ( UserDefinedType userdefinedtype : this ) userdefinedtype.setPackage( ref_package );
    }
    @Override
    public void setBase_type_package( String ref_base_type_package ) throws XtumlException {
        for ( UserDefinedType userdefinedtype : this ) userdefinedtype.setBase_type_package( ref_base_type_package );
    }


    // selections
    @Override
    public TypeSet R3802_based_on_Type() throws XtumlException {
        TypeSet typeset = new TypeSetImpl();
        for ( UserDefinedType userdefinedtype : this ) typeset.add( userdefinedtype.R3802_based_on_Type() );
        return typeset;
    }
    @Override
    public FileSet R401_is_a_File() throws XtumlException {
        FileSet fileset = new FileSetImpl();
        for ( UserDefinedType userdefinedtype : this ) fileset.add( userdefinedtype.R401_is_a_File() );
        return fileset;
    }
    @Override
    public TypeSet R407_is_a_Type() throws XtumlException {
        TypeSet typeset = new TypeSetImpl();
        for ( UserDefinedType userdefinedtype : this ) typeset.add( userdefinedtype.R407_is_a_Type() );
        return typeset;
    }


    @Override
    public UserDefinedType nullElement() {
        return UserDefinedTypeImpl.EMPTY_USERDEFINEDTYPE;
    }

    @Override
    public UserDefinedTypeSet emptySet() {
      return new UserDefinedTypeSetImpl();
    }

    @Override
    public UserDefinedTypeSet emptySet(Comparator<? super UserDefinedType> comp) {
      return new UserDefinedTypeSetImpl(comp);
    }

    @Override
    public List<UserDefinedType> elements() {
        UserDefinedType[] elements = toArray(new UserDefinedType[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
