package io.ciera.tool.sql.architecture.type.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.classes.AttributeSet;
import io.ciera.tool.sql.architecture.classes.SelectorSet;
import io.ciera.tool.sql.architecture.classes.impl.AttributeSetImpl;
import io.ciera.tool.sql.architecture.classes.impl.SelectorSetImpl;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionSetImpl;
import io.ciera.tool.sql.architecture.invocable.FormalParameterSet;
import io.ciera.tool.sql.architecture.invocable.InvocableObjectSet;
import io.ciera.tool.sql.architecture.invocable.impl.FormalParameterSetImpl;
import io.ciera.tool.sql.architecture.invocable.impl.InvocableObjectSetImpl;
import io.ciera.tool.sql.architecture.statement.VariableSet;
import io.ciera.tool.sql.architecture.statement.impl.VariableSetImpl;
import io.ciera.tool.sql.architecture.type.ArrayTypeReferenceSet;
import io.ciera.tool.sql.architecture.type.BasicTypeReferenceSet;
import io.ciera.tool.sql.architecture.type.TypeReference;
import io.ciera.tool.sql.architecture.type.TypeReferenceSet;
import io.ciera.tool.sql.architecture.type.TypeSet;
import io.ciera.tool.sql.architecture.type.impl.ArrayTypeReferenceSetImpl;
import io.ciera.tool.sql.architecture.type.impl.BasicTypeReferenceSetImpl;
import io.ciera.tool.sql.architecture.type.impl.TypeSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class TypeReferenceSetImpl extends InstanceSet<TypeReferenceSet,TypeReference> implements TypeReferenceSet {

    public TypeReferenceSetImpl() {
    }

    public TypeReferenceSetImpl(Comparator<? super TypeReference> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setType_package( String ref_type_package ) throws XtumlException {
        for ( TypeReference typereference : this ) typereference.setType_package( ref_type_package );
    }
    @Override
    public void setType_reference_name( String m_type_reference_name ) throws XtumlException {
        for ( TypeReference typereference : this ) typereference.setType_reference_name( m_type_reference_name );
    }
    @Override
    public void setType_name( String ref_type_name ) throws XtumlException {
        for ( TypeReference typereference : this ) typereference.setType_name( ref_type_name );
    }


    // selections
    @Override
    public TypeSet R3800_based_on_Type() throws XtumlException {
        TypeSet typeset = new TypeSetImpl();
        for ( TypeReference typereference : this ) typeset.add( typereference.R3800_based_on_Type() );
        return typeset;
    }
    @Override
    public ArrayTypeReferenceSet R3801_is_a_ArrayTypeReference() throws XtumlException {
        ArrayTypeReferenceSet arraytypereferenceset = new ArrayTypeReferenceSetImpl();
        for ( TypeReference typereference : this ) arraytypereferenceset.add( typereference.R3801_is_a_ArrayTypeReference() );
        return arraytypereferenceset;
    }
    @Override
    public BasicTypeReferenceSet R3801_is_a_BasicTypeReference() throws XtumlException {
        BasicTypeReferenceSet basictypereferenceset = new BasicTypeReferenceSetImpl();
        for ( TypeReference typereference : this ) basictypereferenceset.add( typereference.R3801_is_a_BasicTypeReference() );
        return basictypereferenceset;
    }
    @Override
    public AttributeSet R424_defines_type_for_Attribute() throws XtumlException {
        AttributeSet attributeset = new AttributeSetImpl();
        for ( TypeReference typereference : this ) attributeset.addAll( typereference.R424_defines_type_for_Attribute() );
        return attributeset;
    }
    @Override
    public InvocableObjectSet R428_defines_return_type_for_InvocableObject() throws XtumlException {
        InvocableObjectSet invocableobjectset = new InvocableObjectSetImpl();
        for ( TypeReference typereference : this ) invocableobjectset.addAll( typereference.R428_defines_return_type_for_InvocableObject() );
        return invocableobjectset;
    }
    @Override
    public FormalParameterSet R431_defines_type_for_FormalParameter() throws XtumlException {
        FormalParameterSet formalparameterset = new FormalParameterSetImpl();
        for ( TypeReference typereference : this ) formalparameterset.addAll( typereference.R431_defines_type_for_FormalParameter() );
        return formalparameterset;
    }
    @Override
    public SelectorSet R446_shapes_return_of_Selector() throws XtumlException {
        SelectorSet selectorset = new SelectorSetImpl();
        for ( TypeReference typereference : this ) selectorset.addAll( typereference.R446_shapes_return_of_Selector() );
        return selectorset;
    }
    @Override
    public VariableSet R461_defines_declared_type_of_Variable() throws XtumlException {
        VariableSet variableset = new VariableSetImpl();
        for ( TypeReference typereference : this ) variableset.addAll( typereference.R461_defines_declared_type_of_Variable() );
        return variableset;
    }
    @Override
    public ExpressionSet R795_defines_type_of_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( TypeReference typereference : this ) expressionset.addAll( typereference.R795_defines_type_of_Expression() );
        return expressionset;
    }


    @Override
    public TypeReference nullElement() {
        return TypeReferenceImpl.EMPTY_TYPEREFERENCE;
    }

    @Override
    public TypeReferenceSet emptySet() {
      return new TypeReferenceSetImpl();
    }

    @Override
    public TypeReferenceSet emptySet(Comparator<? super TypeReference> comp) {
      return new TypeReferenceSetImpl(comp);
    }

    @Override
    public List<TypeReference> elements() {
        return Arrays.asList(toArray(new TypeReference[0]));
    }

}
