package io.ciera.tool.sql.architecture.type.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.classes.Attribute;
import io.ciera.tool.sql.architecture.classes.AttributeSet;
import io.ciera.tool.sql.architecture.classes.Selector;
import io.ciera.tool.sql.architecture.classes.SelectorSet;
import io.ciera.tool.sql.architecture.classes.impl.AttributeSetImpl;
import io.ciera.tool.sql.architecture.classes.impl.SelectorSetImpl;
import io.ciera.tool.sql.architecture.expression.Expression;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionSetImpl;
import io.ciera.tool.sql.architecture.invocable.FormalParameter;
import io.ciera.tool.sql.architecture.invocable.FormalParameterSet;
import io.ciera.tool.sql.architecture.invocable.InvocableObject;
import io.ciera.tool.sql.architecture.invocable.InvocableObjectSet;
import io.ciera.tool.sql.architecture.invocable.impl.FormalParameterSetImpl;
import io.ciera.tool.sql.architecture.invocable.impl.InvocableObjectSetImpl;
import io.ciera.tool.sql.architecture.statement.Variable;
import io.ciera.tool.sql.architecture.statement.VariableSet;
import io.ciera.tool.sql.architecture.statement.impl.VariableSetImpl;
import io.ciera.tool.sql.architecture.type.ArrayTypeReference;
import io.ciera.tool.sql.architecture.type.BasicTypeReference;
import io.ciera.tool.sql.architecture.type.Type;
import io.ciera.tool.sql.architecture.type.TypeReference;
import io.ciera.tool.sql.architecture.type.impl.ArrayTypeReferenceImpl;
import io.ciera.tool.sql.architecture.type.impl.BasicTypeReferenceImpl;
import io.ciera.tool.sql.architecture.type.impl.TypeImpl;


public class TypeReferenceImpl extends ModelInstance<TypeReference,Sql> implements TypeReference {

    public static final String KEY_LETTERS = "TypeReference";
    public static final TypeReference EMPTY_TYPEREFERENCE = new EmptyTypeReference();

    private Sql context;

    // constructors
    private TypeReferenceImpl( Sql context ) {
        this.context = context;
        ref_type_name = "";
        ref_type_package = "";
        m_type_reference_name = "";
        R3800_based_on_Type_inst = TypeImpl.EMPTY_TYPE;
        R3801_is_a_ArrayTypeReference_inst = ArrayTypeReferenceImpl.EMPTY_ARRAYTYPEREFERENCE;
        R3801_is_a_BasicTypeReference_inst = BasicTypeReferenceImpl.EMPTY_BASICTYPEREFERENCE;
        R424_defines_type_for_Attribute_set = new AttributeSetImpl();
        R428_defines_return_type_for_InvocableObject_set = new InvocableObjectSetImpl();
        R431_defines_type_for_FormalParameter_set = new FormalParameterSetImpl();
        R446_shapes_return_of_Selector_set = new SelectorSetImpl();
        R461_defines_declared_type_of_Variable_set = new VariableSetImpl();
        R795_defines_type_of_Expression_set = new ExpressionSetImpl();
    }

    private TypeReferenceImpl( Sql context, UniqueId instanceId, String ref_type_name, String ref_type_package, String m_type_reference_name ) {
        super(instanceId);
        this.context = context;
        this.ref_type_name = ref_type_name;
        this.ref_type_package = ref_type_package;
        this.m_type_reference_name = m_type_reference_name;
        R3800_based_on_Type_inst = TypeImpl.EMPTY_TYPE;
        R3801_is_a_ArrayTypeReference_inst = ArrayTypeReferenceImpl.EMPTY_ARRAYTYPEREFERENCE;
        R3801_is_a_BasicTypeReference_inst = BasicTypeReferenceImpl.EMPTY_BASICTYPEREFERENCE;
        R424_defines_type_for_Attribute_set = new AttributeSetImpl();
        R428_defines_return_type_for_InvocableObject_set = new InvocableObjectSetImpl();
        R431_defines_type_for_FormalParameter_set = new FormalParameterSetImpl();
        R446_shapes_return_of_Selector_set = new SelectorSetImpl();
        R461_defines_declared_type_of_Variable_set = new VariableSetImpl();
        R795_defines_type_of_Expression_set = new ExpressionSetImpl();
    }

    public static TypeReference create( Sql context ) throws XtumlException {
        TypeReference newTypeReference = new TypeReferenceImpl( context );
        if ( context.addInstance( newTypeReference ) ) {
            newTypeReference.getRunContext().addChange(new InstanceCreatedDelta(newTypeReference, KEY_LETTERS));
            return newTypeReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static TypeReference create( Sql context, String ref_type_name, String ref_type_package, String m_type_reference_name ) throws XtumlException {
        return create(context, UniqueId.random(), ref_type_name, ref_type_package, m_type_reference_name);
    }

    public static TypeReference create( Sql context, UniqueId instanceId, String ref_type_name, String ref_type_package, String m_type_reference_name ) throws XtumlException {
        TypeReference newTypeReference = new TypeReferenceImpl( context, instanceId, ref_type_name, ref_type_package, m_type_reference_name );
        if ( context.addInstance( newTypeReference ) ) {
            return newTypeReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_type_name;
    @Override
    public String getType_name() throws XtumlException {
        checkLiving();
        return ref_type_name;
    }
    @Override
    public void setType_name(String ref_type_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_type_name, this.ref_type_name)) {
            final String oldValue = this.ref_type_name;
            this.ref_type_name = ref_type_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_type_name", oldValue, this.ref_type_name));
            if ( !R3801_is_a_ArrayTypeReference().isEmpty() ) R3801_is_a_ArrayTypeReference().setName( ref_type_name );
            if ( !R446_shapes_return_of_Selector().isEmpty() ) R446_shapes_return_of_Selector().setType_name( ref_type_name );
            if ( !R3801_is_a_BasicTypeReference().isEmpty() ) R3801_is_a_BasicTypeReference().setName( ref_type_name );
            if ( !R795_defines_type_of_Expression().isEmpty() ) R795_defines_type_of_Expression().setType_name( ref_type_name );
            if ( !R424_defines_type_for_Attribute().isEmpty() ) R424_defines_type_for_Attribute().setType_name( ref_type_name );
            if ( !R428_defines_return_type_for_InvocableObject().isEmpty() ) R428_defines_return_type_for_InvocableObject().setType_name( ref_type_name );
            if ( !R431_defines_type_for_FormalParameter().isEmpty() ) R431_defines_type_for_FormalParameter().setType_name( ref_type_name );
            if ( !R461_defines_declared_type_of_Variable().isEmpty() ) R461_defines_declared_type_of_Variable().setType_name( ref_type_name );
        }
    }
    private String ref_type_package;
    @Override
    public void setType_package(String ref_type_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_type_package, this.ref_type_package)) {
            final String oldValue = this.ref_type_package;
            this.ref_type_package = ref_type_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_type_package", oldValue, this.ref_type_package));
            if ( !R424_defines_type_for_Attribute().isEmpty() ) R424_defines_type_for_Attribute().setType_package( ref_type_package );
            if ( !R3801_is_a_BasicTypeReference().isEmpty() ) R3801_is_a_BasicTypeReference().setPackage( ref_type_package );
            if ( !R428_defines_return_type_for_InvocableObject().isEmpty() ) R428_defines_return_type_for_InvocableObject().setType_package( ref_type_package );
            if ( !R795_defines_type_of_Expression().isEmpty() ) R795_defines_type_of_Expression().setType_package( ref_type_package );
            if ( !R446_shapes_return_of_Selector().isEmpty() ) R446_shapes_return_of_Selector().setType_package( ref_type_package );
            if ( !R461_defines_declared_type_of_Variable().isEmpty() ) R461_defines_declared_type_of_Variable().setType_package( ref_type_package );
            if ( !R3801_is_a_ArrayTypeReference().isEmpty() ) R3801_is_a_ArrayTypeReference().setPackage( ref_type_package );
            if ( !R431_defines_type_for_FormalParameter().isEmpty() ) R431_defines_type_for_FormalParameter().setType_package( ref_type_package );
        }
    }
    @Override
    public String getType_package() throws XtumlException {
        checkLiving();
        return ref_type_package;
    }
    private String m_type_reference_name;
    @Override
    public void setType_reference_name(String m_type_reference_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_type_reference_name, this.m_type_reference_name)) {
            final String oldValue = this.m_type_reference_name;
            this.m_type_reference_name = m_type_reference_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_type_reference_name", oldValue, this.m_type_reference_name));
            if ( !R428_defines_return_type_for_InvocableObject().isEmpty() ) R428_defines_return_type_for_InvocableObject().setType_reference_name( m_type_reference_name );
            if ( !R795_defines_type_of_Expression().isEmpty() ) R795_defines_type_of_Expression().setType_reference_name( m_type_reference_name );
            if ( !R446_shapes_return_of_Selector().isEmpty() ) R446_shapes_return_of_Selector().setType_reference_name( m_type_reference_name );
            if ( !R461_defines_declared_type_of_Variable().isEmpty() ) R461_defines_declared_type_of_Variable().setType_reference_name( m_type_reference_name );
            if ( !R3801_is_a_BasicTypeReference().isEmpty() ) R3801_is_a_BasicTypeReference().setType_reference_name( m_type_reference_name );
            if ( !R431_defines_type_for_FormalParameter().isEmpty() ) R431_defines_type_for_FormalParameter().setType_reference_name( m_type_reference_name );
            if ( !R3801_is_a_ArrayTypeReference().isEmpty() ) R3801_is_a_ArrayTypeReference().setType_reference_name( m_type_reference_name );
            if ( !R424_defines_type_for_Attribute().isEmpty() ) R424_defines_type_for_Attribute().setType_reference_name( m_type_reference_name );
        }
    }
    @Override
    public String getType_reference_name() throws XtumlException {
        checkLiving();
        return m_type_reference_name;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getType_name(), getType_package(), getType_reference_name());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Type R3800_based_on_Type_inst;
    @Override
    public void setR3800_based_on_Type( Type inst ) {
        R3800_based_on_Type_inst = inst;
    }
    @Override
    public Type R3800_based_on_Type() throws XtumlException {
        return R3800_based_on_Type_inst;
    }
    private ArrayTypeReference R3801_is_a_ArrayTypeReference_inst;
    @Override
    public void setR3801_is_a_ArrayTypeReference( ArrayTypeReference inst ) {
        R3801_is_a_ArrayTypeReference_inst = inst;
    }
    @Override
    public ArrayTypeReference R3801_is_a_ArrayTypeReference() throws XtumlException {
        return R3801_is_a_ArrayTypeReference_inst;
    }
    private BasicTypeReference R3801_is_a_BasicTypeReference_inst;
    @Override
    public void setR3801_is_a_BasicTypeReference( BasicTypeReference inst ) {
        R3801_is_a_BasicTypeReference_inst = inst;
    }
    @Override
    public BasicTypeReference R3801_is_a_BasicTypeReference() throws XtumlException {
        return R3801_is_a_BasicTypeReference_inst;
    }
    private AttributeSet R424_defines_type_for_Attribute_set;
    @Override
    public void addR424_defines_type_for_Attribute( Attribute inst ) {
        R424_defines_type_for_Attribute_set.add(inst);
    }
    @Override
    public void removeR424_defines_type_for_Attribute( Attribute inst ) {
        R424_defines_type_for_Attribute_set.remove(inst);
    }
    @Override
    public AttributeSet R424_defines_type_for_Attribute() throws XtumlException {
        return R424_defines_type_for_Attribute_set;
    }
    private InvocableObjectSet R428_defines_return_type_for_InvocableObject_set;
    @Override
    public void addR428_defines_return_type_for_InvocableObject( InvocableObject inst ) {
        R428_defines_return_type_for_InvocableObject_set.add(inst);
    }
    @Override
    public void removeR428_defines_return_type_for_InvocableObject( InvocableObject inst ) {
        R428_defines_return_type_for_InvocableObject_set.remove(inst);
    }
    @Override
    public InvocableObjectSet R428_defines_return_type_for_InvocableObject() throws XtumlException {
        return R428_defines_return_type_for_InvocableObject_set;
    }
    private FormalParameterSet R431_defines_type_for_FormalParameter_set;
    @Override
    public void addR431_defines_type_for_FormalParameter( FormalParameter inst ) {
        R431_defines_type_for_FormalParameter_set.add(inst);
    }
    @Override
    public void removeR431_defines_type_for_FormalParameter( FormalParameter inst ) {
        R431_defines_type_for_FormalParameter_set.remove(inst);
    }
    @Override
    public FormalParameterSet R431_defines_type_for_FormalParameter() throws XtumlException {
        return R431_defines_type_for_FormalParameter_set;
    }
    private SelectorSet R446_shapes_return_of_Selector_set;
    @Override
    public void addR446_shapes_return_of_Selector( Selector inst ) {
        R446_shapes_return_of_Selector_set.add(inst);
    }
    @Override
    public void removeR446_shapes_return_of_Selector( Selector inst ) {
        R446_shapes_return_of_Selector_set.remove(inst);
    }
    @Override
    public SelectorSet R446_shapes_return_of_Selector() throws XtumlException {
        return R446_shapes_return_of_Selector_set;
    }
    private VariableSet R461_defines_declared_type_of_Variable_set;
    @Override
    public void addR461_defines_declared_type_of_Variable( Variable inst ) {
        R461_defines_declared_type_of_Variable_set.add(inst);
    }
    @Override
    public void removeR461_defines_declared_type_of_Variable( Variable inst ) {
        R461_defines_declared_type_of_Variable_set.remove(inst);
    }
    @Override
    public VariableSet R461_defines_declared_type_of_Variable() throws XtumlException {
        return R461_defines_declared_type_of_Variable_set;
    }
    private ExpressionSet R795_defines_type_of_Expression_set;
    @Override
    public void addR795_defines_type_of_Expression( Expression inst ) {
        R795_defines_type_of_Expression_set.add(inst);
    }
    @Override
    public void removeR795_defines_type_of_Expression( Expression inst ) {
        R795_defines_type_of_Expression_set.remove(inst);
    }
    @Override
    public ExpressionSet R795_defines_type_of_Expression() throws XtumlException {
        return R795_defines_type_of_Expression_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public TypeReference self() {
        return this;
    }

    @Override
    public TypeReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_TYPEREFERENCE;
    }

}

class EmptyTypeReference extends ModelInstance<TypeReference,Sql> implements TypeReference {

    // attributes
    public String getType_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setType_name( String ref_type_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setType_package( String ref_type_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getType_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setType_reference_name( String m_type_reference_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getType_reference_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Type R3800_based_on_Type() {
        return TypeImpl.EMPTY_TYPE;
    }
    @Override
    public ArrayTypeReference R3801_is_a_ArrayTypeReference() {
        return ArrayTypeReferenceImpl.EMPTY_ARRAYTYPEREFERENCE;
    }
    @Override
    public BasicTypeReference R3801_is_a_BasicTypeReference() {
        return BasicTypeReferenceImpl.EMPTY_BASICTYPEREFERENCE;
    }
    @Override
    public AttributeSet R424_defines_type_for_Attribute() {
        return (new AttributeSetImpl());
    }
    @Override
    public InvocableObjectSet R428_defines_return_type_for_InvocableObject() {
        return (new InvocableObjectSetImpl());
    }
    @Override
    public FormalParameterSet R431_defines_type_for_FormalParameter() {
        return (new FormalParameterSetImpl());
    }
    @Override
    public SelectorSet R446_shapes_return_of_Selector() {
        return (new SelectorSetImpl());
    }
    @Override
    public VariableSet R461_defines_declared_type_of_Variable() {
        return (new VariableSetImpl());
    }
    @Override
    public ExpressionSet R795_defines_type_of_Expression() {
        return (new ExpressionSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return TypeReferenceImpl.KEY_LETTERS;
    }

    @Override
    public TypeReference self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public TypeReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return TypeReferenceImpl.EMPTY_TYPEREFERENCE;
    }

}
