package io.ciera.tool.sql.architecture.statement.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.expression.Expression;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionImpl;
import io.ciera.tool.sql.architecture.invocable.CodeBlock;
import io.ciera.tool.sql.architecture.invocable.impl.CodeBlockImpl;
import io.ciera.tool.sql.architecture.statement.Statement;
import io.ciera.tool.sql.architecture.statement.WhileSmt;
import io.ciera.tool.sql.architecture.statement.impl.StatementImpl;


public class WhileSmtImpl extends ModelInstance<WhileSmt,Sql> implements WhileSmt {

    public static final String KEY_LETTERS = "WhileSmt";
    public static final WhileSmt EMPTY_WHILESMT = new EmptyWhileSmt();

    private Sql context;

    // constructors
    private WhileSmtImpl( Sql context ) {
        this.context = context;
        ref_parent_name = "";
        ref_parent_package = "";
        ref_body_name = "";
        ref_block_number = "";
        ref_statement_number = "";
        ref_control_block_number = "";
        ref_cond_expression_number = "";
        R451_is_a_Statement_inst = StatementImpl.EMPTY_STATEMENT;
        R456_has_control_CodeBlock_inst = CodeBlockImpl.EMPTY_CODEBLOCK;
        R472_executes_block_while_true_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
    }

    private WhileSmtImpl( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_control_block_number, String ref_cond_expression_number ) {
        super(instanceId);
        this.context = context;
        this.ref_parent_name = ref_parent_name;
        this.ref_parent_package = ref_parent_package;
        this.ref_body_name = ref_body_name;
        this.ref_block_number = ref_block_number;
        this.ref_statement_number = ref_statement_number;
        this.ref_control_block_number = ref_control_block_number;
        this.ref_cond_expression_number = ref_cond_expression_number;
        R451_is_a_Statement_inst = StatementImpl.EMPTY_STATEMENT;
        R456_has_control_CodeBlock_inst = CodeBlockImpl.EMPTY_CODEBLOCK;
        R472_executes_block_while_true_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
    }

    public static WhileSmt create( Sql context ) throws XtumlException {
        WhileSmt newWhileSmt = new WhileSmtImpl( context );
        if ( context.addInstance( newWhileSmt ) ) {
            newWhileSmt.getRunContext().addChange(new InstanceCreatedDelta(newWhileSmt, KEY_LETTERS));
            return newWhileSmt;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static WhileSmt create( Sql context, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_control_block_number, String ref_cond_expression_number ) throws XtumlException {
        return create(context, UniqueId.random(), ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, ref_statement_number, ref_control_block_number, ref_cond_expression_number);
    }

    public static WhileSmt create( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_control_block_number, String ref_cond_expression_number ) throws XtumlException {
        WhileSmt newWhileSmt = new WhileSmtImpl( context, instanceId, ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, ref_statement_number, ref_control_block_number, ref_cond_expression_number );
        if ( context.addInstance( newWhileSmt ) ) {
            return newWhileSmt;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_parent_name;
    @Override
    public String getParent_name() throws XtumlException {
        checkLiving();
        return ref_parent_name;
    }
    @Override
    public void setParent_name(String ref_parent_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_name, this.ref_parent_name)) {
            final String oldValue = this.ref_parent_name;
            this.ref_parent_name = ref_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_name", oldValue, this.ref_parent_name));
        }
    }
    private String ref_parent_package;
    @Override
    public String getParent_package() throws XtumlException {
        checkLiving();
        return ref_parent_package;
    }
    @Override
    public void setParent_package(String ref_parent_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_package, this.ref_parent_package)) {
            final String oldValue = this.ref_parent_package;
            this.ref_parent_package = ref_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_package", oldValue, this.ref_parent_package));
        }
    }
    private String ref_body_name;
    @Override
    public String getBody_name() throws XtumlException {
        checkLiving();
        return ref_body_name;
    }
    @Override
    public void setBody_name(String ref_body_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_body_name, this.ref_body_name)) {
            final String oldValue = this.ref_body_name;
            this.ref_body_name = ref_body_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_body_name", oldValue, this.ref_body_name));
        }
    }
    private String ref_block_number;
    @Override
    public void setBlock_number(String ref_block_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_block_number, this.ref_block_number)) {
            final String oldValue = this.ref_block_number;
            this.ref_block_number = ref_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_block_number", oldValue, this.ref_block_number));
        }
    }
    @Override
    public String getBlock_number() throws XtumlException {
        checkLiving();
        return ref_block_number;
    }
    private String ref_statement_number;
    @Override
    public void setStatement_number(String ref_statement_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_statement_number, this.ref_statement_number)) {
            final String oldValue = this.ref_statement_number;
            this.ref_statement_number = ref_statement_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_statement_number", oldValue, this.ref_statement_number));
        }
    }
    @Override
    public String getStatement_number() throws XtumlException {
        checkLiving();
        return ref_statement_number;
    }
    private String ref_control_block_number;
    @Override
    public void setControl_block_number(String ref_control_block_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_control_block_number, this.ref_control_block_number)) {
            final String oldValue = this.ref_control_block_number;
            this.ref_control_block_number = ref_control_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_control_block_number", oldValue, this.ref_control_block_number));
        }
    }
    @Override
    public String getControl_block_number() throws XtumlException {
        checkLiving();
        return ref_control_block_number;
    }
    private String ref_cond_expression_number;
    @Override
    public void setCond_expression_number(String ref_cond_expression_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_cond_expression_number, this.ref_cond_expression_number)) {
            final String oldValue = this.ref_cond_expression_number;
            this.ref_cond_expression_number = ref_cond_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_cond_expression_number", oldValue, this.ref_cond_expression_number));
        }
    }
    @Override
    public String getCond_expression_number() throws XtumlException {
        checkLiving();
        return ref_cond_expression_number;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getParent_name(), getParent_package(), getBody_name(), getBlock_number(), getStatement_number());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().push_buffer();
        Statement smt = self().R451_is_a_Statement();
        String actions = smt.getActions();
        String prefix = smt.getPrefix();
        Expression cond_expression = self().R472_executes_block_while_true_Expression();
        cond_expression.render();
        String cond_expr = context().T().body();
        context().T().clear();
        CodeBlock control_blk = self().R456_has_control_CodeBlock();
        control_blk.render();
        String control_block = context().T().body();
        context().T().clear();
        CodeBlock enclosing_block = smt.R450_is_contained_by_CodeBlock();
        String indent = context().getIndent( enclosing_block.getTab_depth() + 1 );
        context().T().pop_buffer();
        context().T().include( "statement/t.while.java", actions, cond_expr, control_block, indent, prefix );
    }



    // static operations


    // events


    // selections
    private Statement R451_is_a_Statement_inst;
    @Override
    public void setR451_is_a_Statement( Statement inst ) {
        R451_is_a_Statement_inst = inst;
    }
    @Override
    public Statement R451_is_a_Statement() throws XtumlException {
        return R451_is_a_Statement_inst;
    }
    private CodeBlock R456_has_control_CodeBlock_inst;
    @Override
    public void setR456_has_control_CodeBlock( CodeBlock inst ) {
        R456_has_control_CodeBlock_inst = inst;
    }
    @Override
    public CodeBlock R456_has_control_CodeBlock() throws XtumlException {
        return R456_has_control_CodeBlock_inst;
    }
    private Expression R472_executes_block_while_true_Expression_inst;
    @Override
    public void setR472_executes_block_while_true_Expression( Expression inst ) {
        R472_executes_block_while_true_Expression_inst = inst;
    }
    @Override
    public Expression R472_executes_block_while_true_Expression() throws XtumlException {
        return R472_executes_block_while_true_Expression_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public WhileSmt self() {
        return this;
    }

    @Override
    public WhileSmt oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_WHILESMT;
    }

}

class EmptyWhileSmt extends ModelInstance<WhileSmt,Sql> implements WhileSmt {

    // attributes
    public String getParent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBody_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBody_name( String ref_body_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBlock_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getStatement_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setControl_block_number( String ref_control_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getControl_block_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setCond_expression_number( String ref_cond_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getCond_expression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public Statement R451_is_a_Statement() {
        return StatementImpl.EMPTY_STATEMENT;
    }
    @Override
    public CodeBlock R456_has_control_CodeBlock() {
        return CodeBlockImpl.EMPTY_CODEBLOCK;
    }
    @Override
    public Expression R472_executes_block_while_true_Expression() {
        return ExpressionImpl.EMPTY_EXPRESSION;
    }


    @Override
    public String getKeyLetters() {
        return WhileSmtImpl.KEY_LETTERS;
    }

    @Override
    public WhileSmt self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public WhileSmt oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return WhileSmtImpl.EMPTY_WHILESMT;
    }

}
