package io.ciera.tool.sql.architecture.statement.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.expression.VariableReference;
import io.ciera.tool.sql.architecture.expression.VariableReferenceSet;
import io.ciera.tool.sql.architecture.expression.impl.VariableReferenceSetImpl;
import io.ciera.tool.sql.architecture.statement.Finalization;
import io.ciera.tool.sql.architecture.statement.FinalizationSet;
import io.ciera.tool.sql.architecture.statement.ForSmt;
import io.ciera.tool.sql.architecture.statement.Statement;
import io.ciera.tool.sql.architecture.statement.Variable;
import io.ciera.tool.sql.architecture.statement.VariableInScope;
import io.ciera.tool.sql.architecture.statement.VariableInScopeSet;
import io.ciera.tool.sql.architecture.statement.impl.FinalizationSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.ForSmtImpl;
import io.ciera.tool.sql.architecture.statement.impl.StatementImpl;
import io.ciera.tool.sql.architecture.statement.impl.VariableInScopeSetImpl;
import io.ciera.tool.sql.architecture.type.TypeReference;
import io.ciera.tool.sql.architecture.type.impl.TypeReferenceImpl;


public class VariableImpl extends ModelInstance<Variable,Sql> implements Variable {

    public static final String KEY_LETTERS = "Variable";
    public static final Variable EMPTY_VARIABLE = new EmptyVariable();

    private Sql context;

    // constructors
    private VariableImpl( Sql context ) {
        this.context = context;
        ref_parent_name = "";
        ref_parent_package = "";
        ref_body_name = "";
        ref_block_number = "";
        m_name = "";
        ref_statement_number = "";
        ref_type_name = "";
        ref_type_package = "";
        ref_type_reference_name = "";
        m_readonly = false;
        R457_is_declared_by_Statement_inst = StatementImpl.EMPTY_STATEMENT;
        R458_is_in_scope_for_VariableInScope_set = new VariableInScopeSetImpl();
        R459_is_iterator_for_ForSmt_inst = ForSmtImpl.EMPTY_FORSMT;
        R461_is_typed_by_TypeReference_inst = TypeReferenceImpl.EMPTY_TYPEREFERENCE;
        R485_finalized_by_Finalization_set = new FinalizationSetImpl();
        R782_referenced_through_VariableReference_set = new VariableReferenceSetImpl();
    }

    private VariableImpl( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String m_name, String ref_statement_number, String ref_type_name, String ref_type_package, String ref_type_reference_name, boolean m_readonly ) {
        super(instanceId);
        this.context = context;
        this.ref_parent_name = ref_parent_name;
        this.ref_parent_package = ref_parent_package;
        this.ref_body_name = ref_body_name;
        this.ref_block_number = ref_block_number;
        this.m_name = m_name;
        this.ref_statement_number = ref_statement_number;
        this.ref_type_name = ref_type_name;
        this.ref_type_package = ref_type_package;
        this.ref_type_reference_name = ref_type_reference_name;
        this.m_readonly = m_readonly;
        R457_is_declared_by_Statement_inst = StatementImpl.EMPTY_STATEMENT;
        R458_is_in_scope_for_VariableInScope_set = new VariableInScopeSetImpl();
        R459_is_iterator_for_ForSmt_inst = ForSmtImpl.EMPTY_FORSMT;
        R461_is_typed_by_TypeReference_inst = TypeReferenceImpl.EMPTY_TYPEREFERENCE;
        R485_finalized_by_Finalization_set = new FinalizationSetImpl();
        R782_referenced_through_VariableReference_set = new VariableReferenceSetImpl();
    }

    public static Variable create( Sql context ) throws XtumlException {
        Variable newVariable = new VariableImpl( context );
        if ( context.addInstance( newVariable ) ) {
            newVariable.getRunContext().addChange(new InstanceCreatedDelta(newVariable, KEY_LETTERS));
            return newVariable;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Variable create( Sql context, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String m_name, String ref_statement_number, String ref_type_name, String ref_type_package, String ref_type_reference_name, boolean m_readonly ) throws XtumlException {
        return create(context, UniqueId.random(), ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, m_name, ref_statement_number, ref_type_name, ref_type_package, ref_type_reference_name, m_readonly);
    }

    public static Variable create( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String m_name, String ref_statement_number, String ref_type_name, String ref_type_package, String ref_type_reference_name, boolean m_readonly ) throws XtumlException {
        Variable newVariable = new VariableImpl( context, instanceId, ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, m_name, ref_statement_number, ref_type_name, ref_type_package, ref_type_reference_name, m_readonly );
        if ( context.addInstance( newVariable ) ) {
            return newVariable;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_parent_name;
    @Override
    public void setParent_name(String ref_parent_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_name, this.ref_parent_name)) {
            final String oldValue = this.ref_parent_name;
            this.ref_parent_name = ref_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_name", oldValue, this.ref_parent_name));
            if ( !R458_is_in_scope_for_VariableInScope().isEmpty() ) R458_is_in_scope_for_VariableInScope().setParent_name( ref_parent_name );
            if ( !R459_is_iterator_for_ForSmt().isEmpty() ) R459_is_iterator_for_ForSmt().setParent_name( ref_parent_name );
            if ( !R782_referenced_through_VariableReference().isEmpty() ) R782_referenced_through_VariableReference().setParent_name( ref_parent_name );
            if ( !R485_finalized_by_Finalization().isEmpty() ) R485_finalized_by_Finalization().setParent_name( ref_parent_name );
        }
    }
    @Override
    public String getParent_name() throws XtumlException {
        checkLiving();
        return ref_parent_name;
    }
    private String ref_parent_package;
    @Override
    public void setParent_package(String ref_parent_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_package, this.ref_parent_package)) {
            final String oldValue = this.ref_parent_package;
            this.ref_parent_package = ref_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_package", oldValue, this.ref_parent_package));
            if ( !R782_referenced_through_VariableReference().isEmpty() ) R782_referenced_through_VariableReference().setParent_package( ref_parent_package );
            if ( !R485_finalized_by_Finalization().isEmpty() ) R485_finalized_by_Finalization().setParent_package( ref_parent_package );
            if ( !R459_is_iterator_for_ForSmt().isEmpty() ) R459_is_iterator_for_ForSmt().setParent_package( ref_parent_package );
            if ( !R458_is_in_scope_for_VariableInScope().isEmpty() ) R458_is_in_scope_for_VariableInScope().setParent_package( ref_parent_package );
        }
    }
    @Override
    public String getParent_package() throws XtumlException {
        checkLiving();
        return ref_parent_package;
    }
    private String ref_body_name;
    @Override
    public void setBody_name(String ref_body_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_body_name, this.ref_body_name)) {
            final String oldValue = this.ref_body_name;
            this.ref_body_name = ref_body_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_body_name", oldValue, this.ref_body_name));
            if ( !R485_finalized_by_Finalization().isEmpty() ) R485_finalized_by_Finalization().setBody_name( ref_body_name );
            if ( !R782_referenced_through_VariableReference().isEmpty() ) R782_referenced_through_VariableReference().setBody_name( ref_body_name );
            if ( !R459_is_iterator_for_ForSmt().isEmpty() ) R459_is_iterator_for_ForSmt().setBody_name( ref_body_name );
            if ( !R458_is_in_scope_for_VariableInScope().isEmpty() ) R458_is_in_scope_for_VariableInScope().setBody_name( ref_body_name );
        }
    }
    @Override
    public String getBody_name() throws XtumlException {
        checkLiving();
        return ref_body_name;
    }
    private String ref_block_number;
    @Override
    public void setBlock_number(String ref_block_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_block_number, this.ref_block_number)) {
            final String oldValue = this.ref_block_number;
            this.ref_block_number = ref_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_block_number", oldValue, this.ref_block_number));
            if ( !R458_is_in_scope_for_VariableInScope().isEmpty() ) R458_is_in_scope_for_VariableInScope().setVar_block_number( ref_block_number );
            if ( !R782_referenced_through_VariableReference().isEmpty() ) R782_referenced_through_VariableReference().setVar_block_number( ref_block_number );
            if ( !R459_is_iterator_for_ForSmt().isEmpty() ) R459_is_iterator_for_ForSmt().setIterator_block_number( ref_block_number );
            if ( !R485_finalized_by_Finalization().isEmpty() ) R485_finalized_by_Finalization().setVar_block_number( ref_block_number );
        }
    }
    @Override
    public String getBlock_number() throws XtumlException {
        checkLiving();
        return ref_block_number;
    }
    private String m_name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_name;
    }
    @Override
    public void setName(String m_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_name, this.m_name)) {
            final String oldValue = this.m_name;
            this.m_name = m_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_name", oldValue, this.m_name));
            if ( !R459_is_iterator_for_ForSmt().isEmpty() ) R459_is_iterator_for_ForSmt().setIterator_name( m_name );
            if ( !R782_referenced_through_VariableReference().isEmpty() ) R782_referenced_through_VariableReference().setVar_name( m_name );
            if ( !R458_is_in_scope_for_VariableInScope().isEmpty() ) R458_is_in_scope_for_VariableInScope().setVar_name( m_name );
            if ( !R485_finalized_by_Finalization().isEmpty() ) R485_finalized_by_Finalization().setVar_name( m_name );
        }
    }
    private String ref_statement_number;
    @Override
    public String getStatement_number() throws XtumlException {
        checkLiving();
        return ref_statement_number;
    }
    @Override
    public void setStatement_number(String ref_statement_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_statement_number, this.ref_statement_number)) {
            final String oldValue = this.ref_statement_number;
            this.ref_statement_number = ref_statement_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_statement_number", oldValue, this.ref_statement_number));
        }
    }
    private String ref_type_name;
    @Override
    public void setType_name(String ref_type_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_type_name, this.ref_type_name)) {
            final String oldValue = this.ref_type_name;
            this.ref_type_name = ref_type_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_type_name", oldValue, this.ref_type_name));
        }
    }
    @Override
    public String getType_name() throws XtumlException {
        checkLiving();
        return ref_type_name;
    }
    private String ref_type_package;
    @Override
    public void setType_package(String ref_type_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_type_package, this.ref_type_package)) {
            final String oldValue = this.ref_type_package;
            this.ref_type_package = ref_type_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_type_package", oldValue, this.ref_type_package));
        }
    }
    @Override
    public String getType_package() throws XtumlException {
        checkLiving();
        return ref_type_package;
    }
    private String ref_type_reference_name;
    @Override
    public String getType_reference_name() throws XtumlException {
        checkLiving();
        return ref_type_reference_name;
    }
    @Override
    public void setType_reference_name(String ref_type_reference_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_type_reference_name, this.ref_type_reference_name)) {
            final String oldValue = this.ref_type_reference_name;
            this.ref_type_reference_name = ref_type_reference_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_type_reference_name", oldValue, this.ref_type_reference_name));
        }
    }
    private boolean m_readonly;
    @Override
    public boolean getReadonly() throws XtumlException {
        checkLiving();
        return m_readonly;
    }
    @Override
    public void setReadonly(boolean m_readonly) throws XtumlException {
        checkLiving();
        if (m_readonly != this.m_readonly) {
            final boolean oldValue = this.m_readonly;
            this.m_readonly = m_readonly;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_readonly", oldValue, this.m_readonly));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getParent_name(), getParent_package(), getBody_name(), getBlock_number(), getName());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Statement R457_is_declared_by_Statement_inst;
    @Override
    public void setR457_is_declared_by_Statement( Statement inst ) {
        R457_is_declared_by_Statement_inst = inst;
    }
    @Override
    public Statement R457_is_declared_by_Statement() throws XtumlException {
        return R457_is_declared_by_Statement_inst;
    }
    private VariableInScopeSet R458_is_in_scope_for_VariableInScope_set;
    @Override
    public void addR458_is_in_scope_for_VariableInScope( VariableInScope inst ) {
        R458_is_in_scope_for_VariableInScope_set.add(inst);
    }
    @Override
    public void removeR458_is_in_scope_for_VariableInScope( VariableInScope inst ) {
        R458_is_in_scope_for_VariableInScope_set.remove(inst);
    }
    @Override
    public VariableInScopeSet R458_is_in_scope_for_VariableInScope() throws XtumlException {
        return R458_is_in_scope_for_VariableInScope_set;
    }
    private ForSmt R459_is_iterator_for_ForSmt_inst;
    @Override
    public void setR459_is_iterator_for_ForSmt( ForSmt inst ) {
        R459_is_iterator_for_ForSmt_inst = inst;
    }
    @Override
    public ForSmt R459_is_iterator_for_ForSmt() throws XtumlException {
        return R459_is_iterator_for_ForSmt_inst;
    }
    private TypeReference R461_is_typed_by_TypeReference_inst;
    @Override
    public void setR461_is_typed_by_TypeReference( TypeReference inst ) {
        R461_is_typed_by_TypeReference_inst = inst;
    }
    @Override
    public TypeReference R461_is_typed_by_TypeReference() throws XtumlException {
        return R461_is_typed_by_TypeReference_inst;
    }
    private FinalizationSet R485_finalized_by_Finalization_set;
    @Override
    public void addR485_finalized_by_Finalization( Finalization inst ) {
        R485_finalized_by_Finalization_set.add(inst);
    }
    @Override
    public void removeR485_finalized_by_Finalization( Finalization inst ) {
        R485_finalized_by_Finalization_set.remove(inst);
    }
    @Override
    public FinalizationSet R485_finalized_by_Finalization() throws XtumlException {
        return R485_finalized_by_Finalization_set;
    }
    private VariableReferenceSet R782_referenced_through_VariableReference_set;
    @Override
    public void addR782_referenced_through_VariableReference( VariableReference inst ) {
        R782_referenced_through_VariableReference_set.add(inst);
    }
    @Override
    public void removeR782_referenced_through_VariableReference( VariableReference inst ) {
        R782_referenced_through_VariableReference_set.remove(inst);
    }
    @Override
    public VariableReferenceSet R782_referenced_through_VariableReference() throws XtumlException {
        return R782_referenced_through_VariableReference_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Variable self() {
        return this;
    }

    @Override
    public Variable oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_VARIABLE;
    }

}

class EmptyVariable extends ModelInstance<Variable,Sql> implements Variable {

    // attributes
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBody_name( String ref_body_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBody_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBlock_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getStatement_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setType_name( String ref_type_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getType_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setType_package( String ref_type_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getType_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getType_reference_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setType_reference_name( String ref_type_reference_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getReadonly() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setReadonly( boolean m_readonly ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Statement R457_is_declared_by_Statement() {
        return StatementImpl.EMPTY_STATEMENT;
    }
    @Override
    public VariableInScopeSet R458_is_in_scope_for_VariableInScope() {
        return (new VariableInScopeSetImpl());
    }
    @Override
    public ForSmt R459_is_iterator_for_ForSmt() {
        return ForSmtImpl.EMPTY_FORSMT;
    }
    @Override
    public TypeReference R461_is_typed_by_TypeReference() {
        return TypeReferenceImpl.EMPTY_TYPEREFERENCE;
    }
    @Override
    public FinalizationSet R485_finalized_by_Finalization() {
        return (new FinalizationSetImpl());
    }
    @Override
    public VariableReferenceSet R782_referenced_through_VariableReference() {
        return (new VariableReferenceSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return VariableImpl.KEY_LETTERS;
    }

    @Override
    public Variable self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Variable oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return VariableImpl.EMPTY_VARIABLE;
    }

}
