package io.ciera.tool.sql.architecture.statement.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.statement.Finalization;
import io.ciera.tool.sql.architecture.statement.FinalizationSet;
import io.ciera.tool.sql.architecture.statement.StatementSet;
import io.ciera.tool.sql.architecture.statement.VariableSet;
import io.ciera.tool.sql.architecture.statement.impl.StatementSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.VariableSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class FinalizationSetImpl extends InstanceSet<FinalizationSet,Finalization> implements FinalizationSet {

    public FinalizationSetImpl() {
    }

    public FinalizationSetImpl(Comparator<? super Finalization> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( Finalization finalization : this ) finalization.setStatement_number( ref_statement_number );
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( Finalization finalization : this ) finalization.setBlock_number( ref_block_number );
    }
    @Override
    public void setVar_name( String ref_var_name ) throws XtumlException {
        for ( Finalization finalization : this ) finalization.setVar_name( ref_var_name );
    }
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( Finalization finalization : this ) finalization.setBody_name( ref_body_name );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( Finalization finalization : this ) finalization.setParent_name( ref_parent_name );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( Finalization finalization : this ) finalization.setParent_package( ref_parent_package );
    }
    @Override
    public void setVar_block_number( String ref_var_block_number ) throws XtumlException {
        for ( Finalization finalization : this ) finalization.setVar_block_number( ref_var_block_number );
    }


    // selections
    @Override
    public StatementSet R485_finalized_by_Statement() throws XtumlException {
        StatementSet statementset = new StatementSetImpl();
        for ( Finalization finalization : this ) statementset.add( finalization.R485_finalized_by_Statement() );
        return statementset;
    }
    @Override
    public VariableSet R485_finalizes_Variable() throws XtumlException {
        VariableSet variableset = new VariableSetImpl();
        for ( Finalization finalization : this ) variableset.add( finalization.R485_finalizes_Variable() );
        return variableset;
    }


    @Override
    public Finalization nullElement() {
        return FinalizationImpl.EMPTY_FINALIZATION;
    }

    @Override
    public FinalizationSet emptySet() {
      return new FinalizationSetImpl();
    }

    @Override
    public FinalizationSet emptySet(Comparator<? super Finalization> comp) {
      return new FinalizationSetImpl(comp);
    }

    @Override
    public List<Finalization> elements() {
        return Arrays.asList(toArray(new Finalization[0]));
    }

}
