package io.ciera.tool.sql.architecture.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.invocable.InvocableObject;
import io.ciera.tool.sql.architecture.invocable.impl.InvocableObjectImpl;
import io.ciera.tool.sql.architecture.statemachine.State;
import io.ciera.tool.sql.architecture.statemachine.StateTransition;
import io.ciera.tool.sql.architecture.statemachine.TransitionTableCell;
import io.ciera.tool.sql.architecture.statemachine.impl.StateImpl;
import io.ciera.tool.sql.architecture.statemachine.impl.TransitionTableCellImpl;


public class StateTransitionImpl extends ModelInstance<StateTransition,Sql> implements StateTransition {

    public static final String KEY_LETTERS = "Transition";
    public static final StateTransition EMPTY_STATETRANSITION = new EmptyStateTransition();

    private Sql context;

    // constructors
    private StateTransitionImpl( Sql context ) {
        this.context = context;
        ref_sm_name = "";
        ref_sm_package = "";
        ref_start_state_name = "";
        ref_end_state_name = "";
        ref_event_sm_name = "";
        ref_event_sm_package = "";
        ref_event_name = "";
        ref_name = "";
        R427_is_a_InvocableObject_inst = InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
        R4757_TransitionTableCell_inst = TransitionTableCellImpl.EMPTY_TRANSITIONTABLECELL;
        R4757_transitions_to_State_inst = StateImpl.EMPTY_STATE;
    }

    private StateTransitionImpl( Sql context, UniqueId instanceId, String ref_sm_name, String ref_sm_package, String ref_start_state_name, String ref_end_state_name, String ref_event_sm_name, String ref_event_sm_package, String ref_event_name, String ref_name ) {
        super(instanceId);
        this.context = context;
        this.ref_sm_name = ref_sm_name;
        this.ref_sm_package = ref_sm_package;
        this.ref_start_state_name = ref_start_state_name;
        this.ref_end_state_name = ref_end_state_name;
        this.ref_event_sm_name = ref_event_sm_name;
        this.ref_event_sm_package = ref_event_sm_package;
        this.ref_event_name = ref_event_name;
        this.ref_name = ref_name;
        R427_is_a_InvocableObject_inst = InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
        R4757_TransitionTableCell_inst = TransitionTableCellImpl.EMPTY_TRANSITIONTABLECELL;
        R4757_transitions_to_State_inst = StateImpl.EMPTY_STATE;
    }

    public static StateTransition create( Sql context ) throws XtumlException {
        StateTransition newStateTransition = new StateTransitionImpl( context );
        if ( context.addInstance( newStateTransition ) ) {
            newStateTransition.getRunContext().addChange(new InstanceCreatedDelta(newStateTransition, KEY_LETTERS));
            return newStateTransition;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static StateTransition create( Sql context, String ref_sm_name, String ref_sm_package, String ref_start_state_name, String ref_end_state_name, String ref_event_sm_name, String ref_event_sm_package, String ref_event_name, String ref_name ) throws XtumlException {
        return create(context, UniqueId.random(), ref_sm_name, ref_sm_package, ref_start_state_name, ref_end_state_name, ref_event_sm_name, ref_event_sm_package, ref_event_name, ref_name);
    }

    public static StateTransition create( Sql context, UniqueId instanceId, String ref_sm_name, String ref_sm_package, String ref_start_state_name, String ref_end_state_name, String ref_event_sm_name, String ref_event_sm_package, String ref_event_name, String ref_name ) throws XtumlException {
        StateTransition newStateTransition = new StateTransitionImpl( context, instanceId, ref_sm_name, ref_sm_package, ref_start_state_name, ref_end_state_name, ref_event_sm_name, ref_event_sm_package, ref_event_name, ref_name );
        if ( context.addInstance( newStateTransition ) ) {
            return newStateTransition;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_sm_name;
    @Override
    public void setSm_name(String ref_sm_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_sm_name, this.ref_sm_name)) {
            final String oldValue = this.ref_sm_name;
            this.ref_sm_name = ref_sm_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_sm_name", oldValue, this.ref_sm_name));
        }
    }
    @Override
    public String getSm_name() throws XtumlException {
        checkLiving();
        return ref_sm_name;
    }
    private String ref_sm_package;
    @Override
    public void setSm_package(String ref_sm_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_sm_package, this.ref_sm_package)) {
            final String oldValue = this.ref_sm_package;
            this.ref_sm_package = ref_sm_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_sm_package", oldValue, this.ref_sm_package));
        }
    }
    @Override
    public String getSm_package() throws XtumlException {
        checkLiving();
        return ref_sm_package;
    }
    private String ref_start_state_name;
    @Override
    public void setStart_state_name(String ref_start_state_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_start_state_name, this.ref_start_state_name)) {
            final String oldValue = this.ref_start_state_name;
            this.ref_start_state_name = ref_start_state_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_start_state_name", oldValue, this.ref_start_state_name));
        }
    }
    @Override
    public String getStart_state_name() throws XtumlException {
        checkLiving();
        return ref_start_state_name;
    }
    private String ref_end_state_name;
    @Override
    public String getEnd_state_name() throws XtumlException {
        checkLiving();
        return ref_end_state_name;
    }
    @Override
    public void setEnd_state_name(String ref_end_state_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_end_state_name, this.ref_end_state_name)) {
            final String oldValue = this.ref_end_state_name;
            this.ref_end_state_name = ref_end_state_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_end_state_name", oldValue, this.ref_end_state_name));
        }
    }
    private String ref_event_sm_name;
    @Override
    public String getEvent_sm_name() throws XtumlException {
        checkLiving();
        return ref_event_sm_name;
    }
    @Override
    public void setEvent_sm_name(String ref_event_sm_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_event_sm_name, this.ref_event_sm_name)) {
            final String oldValue = this.ref_event_sm_name;
            this.ref_event_sm_name = ref_event_sm_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_event_sm_name", oldValue, this.ref_event_sm_name));
        }
    }
    private String ref_event_sm_package;
    @Override
    public void setEvent_sm_package(String ref_event_sm_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_event_sm_package, this.ref_event_sm_package)) {
            final String oldValue = this.ref_event_sm_package;
            this.ref_event_sm_package = ref_event_sm_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_event_sm_package", oldValue, this.ref_event_sm_package));
        }
    }
    @Override
    public String getEvent_sm_package() throws XtumlException {
        checkLiving();
        return ref_event_sm_package;
    }
    private String ref_event_name;
    @Override
    public void setEvent_name(String ref_event_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_event_name, this.ref_event_name)) {
            final String oldValue = this.ref_event_name;
            this.ref_event_name = ref_event_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_event_name", oldValue, this.ref_event_name));
        }
    }
    @Override
    public String getEvent_name() throws XtumlException {
        checkLiving();
        return ref_event_name;
    }
    private String ref_name;
    @Override
    public void setName(String ref_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_name, this.ref_name)) {
            final String oldValue = this.ref_name;
            this.ref_name = ref_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_name", oldValue, this.ref_name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return ref_name;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSm_name(), getSm_package(), getStart_state_name(), getEnd_state_name());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().push_buffer();
        String parameter_list = "";
        InvocableObject evt_invocable = self().R4757_TransitionTableCell().R4756_receives_Event().R427_is_a_InvocableObject();
        if ( !evt_invocable.isEmpty() ) {
            parameter_list = evt_invocable.parameter_list();
        }
        InvocableObject invocable = self().R427_is_a_InvocableObject();
        String body = invocable.body();
        context().T().pop_buffer();
        context().T().include( "statemachine/t.transition.java", body, parameter_list, self() );
    }



    // static operations


    // events


    // selections
    private InvocableObject R427_is_a_InvocableObject_inst;
    @Override
    public void setR427_is_a_InvocableObject( InvocableObject inst ) {
        R427_is_a_InvocableObject_inst = inst;
    }
    @Override
    public InvocableObject R427_is_a_InvocableObject() throws XtumlException {
        return R427_is_a_InvocableObject_inst;
    }
    private TransitionTableCell R4757_TransitionTableCell_inst;
    @Override
    public void setR4757_TransitionTableCell( TransitionTableCell inst ) {
        R4757_TransitionTableCell_inst = inst;
    }
    @Override
    public TransitionTableCell R4757_TransitionTableCell() throws XtumlException {
        return R4757_TransitionTableCell_inst;
    }
    private State R4757_transitions_to_State_inst;
    @Override
    public void setR4757_transitions_to_State( State inst ) {
        R4757_transitions_to_State_inst = inst;
    }
    @Override
    public State R4757_transitions_to_State() throws XtumlException {
        return R4757_transitions_to_State_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public StateTransition self() {
        return this;
    }

    @Override
    public StateTransition oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_STATETRANSITION;
    }

}

class EmptyStateTransition extends ModelInstance<StateTransition,Sql> implements StateTransition {

    // attributes
    public void setSm_name( String ref_sm_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getSm_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSm_package( String ref_sm_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getSm_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStart_state_name( String ref_start_state_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getStart_state_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getEnd_state_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setEnd_state_name( String ref_end_state_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getEvent_sm_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setEvent_sm_name( String ref_event_sm_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setEvent_sm_package( String ref_event_sm_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getEvent_sm_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setEvent_name( String ref_event_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getEvent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String ref_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public InvocableObject R427_is_a_InvocableObject() {
        return InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
    }
    @Override
    public TransitionTableCell R4757_TransitionTableCell() {
        return TransitionTableCellImpl.EMPTY_TRANSITIONTABLECELL;
    }
    @Override
    public State R4757_transitions_to_State() {
        return StateImpl.EMPTY_STATE;
    }


    @Override
    public String getKeyLetters() {
        return StateTransitionImpl.KEY_LETTERS;
    }

    @Override
    public StateTransition self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public StateTransition oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return StateTransitionImpl.EMPTY_STATETRANSITION;
    }

}
